/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.client;

import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.HttpClientSseClientTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.RefererFunctionTool;
import org.noear.solon.ai.image.Image;
import org.noear.solon.ai.mcp.exception.McpException;

public class McpClientWrapper
implements Closeable {
    private McpSyncClient real;
    private Collection<FunctionTool> tools;

    public McpClientWrapper(McpSyncClient client) {
        this.real = client;
        this.real.initialize();
    }

    public McpClientWrapper(McpClientTransport clientTransport) {
        this.real = McpClient.sync((McpClientTransport)clientTransport).clientInfo(new McpSchema.Implementation("Solon-Ai-Mcp-Client", "1.0.0")).build();
        this.real.initialize();
    }

    public McpClientWrapper(String baseUri, String sseEndpoint) {
        HttpClientSseClientTransport clientTransport = HttpClientSseClientTransport.builder((String)baseUri).sseEndpoint(sseEndpoint).build();
        this.real = McpClient.sync((McpClientTransport)clientTransport).clientInfo(new McpSchema.Implementation("Solon-Ai-Mcp-Client", "1.0.0")).build();
        this.real.initialize();
    }

    public String callToolAsText(String name, Map<String, Object> args) {
        McpSchema.CallToolResult result = this.callTool(name, args);
        if (Utils.isEmpty((Collection)result.content())) {
            return null;
        }
        return ((McpSchema.TextContent)result.content().get(0)).text();
    }

    public Image callToolAsImage(String name, Map<String, Object> args) {
        McpSchema.CallToolResult result = this.callTool(name, args);
        if (Utils.isEmpty((Collection)result.content())) {
            return null;
        }
        McpSchema.ImageContent imageContent = (McpSchema.ImageContent)result.content().get(0);
        return Image.ofBase64((String)imageContent.data(), (String)imageContent.mimeType());
    }

    public McpSchema.CallToolResult callTool(String name, Map<String, Object> args) {
        McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest(name, args);
        McpSchema.CallToolResult response = this.real.callTool(callToolRequest);
        if (response.isError() == null || !response.isError().booleanValue()) {
            return response;
        }
        if (Utils.isEmpty((Collection)response.content())) {
            throw new McpException("Call Toll Failed");
        }
        throw new McpException(((McpSchema.Content)response.content().get(0)).toString());
    }

    public Collection<FunctionTool> toTools() {
        return this.toTools(true);
    }

    public Collection<FunctionTool> toTools(boolean cached) {
        if (cached && this.tools != null) {
            return this.tools;
        }
        this.tools = this.buildTools();
        return this.tools;
    }

    protected Collection<FunctionTool> buildTools() {
        ArrayList<FunctionTool> toolList = new ArrayList<FunctionTool>();
        McpSchema.ListToolsResult result = this.real.listTools();
        for (McpSchema.Tool tool : result.tools()) {
            String name = tool.name();
            String description = tool.description();
            ONode parametersNode = ONode.load((Object)tool.inputSchema());
            RefererFunctionTool functionRefer = new RefererFunctionTool(name, description, parametersNode, args -> this.callToolAsText(name, (Map<String, Object>)args));
            toolList.add((FunctionTool)functionRefer);
        }
        return toolList;
    }

    @Override
    public void close() throws IOException {
        if (this.real != null) {
            this.real.close();
        }
    }
}

