/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.server.integration;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.transport.WebRxSseServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.util.Arrays;
import org.noear.snack.ONode;
import org.noear.solon.ai.chat.annotation.ToolMapping;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.MethodFunctionTool;
import org.noear.solon.ai.mcp.server.McpServerProperties;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Lifecycle;
import org.noear.solon.core.Plugin;
import reactor.core.publisher.Mono;

public class McpServerPlugin
implements Plugin {
    private WebRxSseServerTransportProvider mcpTransportProvider;
    private McpServer.AsyncSpecification mcpServerSpec;

    public void start(AppContext context) throws Throwable {
        McpServerProperties serverProperties = (McpServerProperties)context.cfg().bindTo(McpServerProperties.class);
        if (serverProperties.isEnabled()) {
            this.mcpTransportProvider = WebRxSseServerTransportProvider.builder().messageEndpoint(serverProperties.getMessageEndpoint()).sseEndpoint(serverProperties.getSseEndpoint()).objectMapper(new ObjectMapper()).build();
            this.mcpServerSpec = McpServer.async((McpServerTransportProvider)this.mcpTransportProvider).serverInfo(serverProperties.getName(), serverProperties.getVersion());
            context.beanExtractorAdd(ToolMapping.class, (bw, method, anno) -> {
                MethodFunctionTool functionTool = new MethodFunctionTool(bw.raw(), method);
                this.addToolSpec(this.mcpServerSpec, (FunctionTool)functionTool);
            });
            context.subBeansOfType(FunctionTool.class, functionTool -> this.addToolSpec(this.mcpServerSpec, (FunctionTool)functionTool));
            this.mcpTransportProvider.toHttpHandler(context.app());
            context.lifecycle(new Lifecycle(){

                public void start() throws Throwable {
                }

                public void postStart() throws Throwable {
                    McpServerPlugin.this.mcpServerSpec.build();
                }
            });
        }
    }

    private void addToolSpec(McpServer.AsyncSpecification mcpServerSpec, FunctionTool functionTool) {
        ONode jsonSchema = this.buildJsonSchema(functionTool);
        String jsonSchemaStr = jsonSchema.toJson();
        McpServerFeatures.AsyncToolSpecification toolSpec = new McpServerFeatures.AsyncToolSpecification(new McpSchema.Tool(functionTool.name(), functionTool.description(), jsonSchemaStr), (exchange, request) -> {
            McpSchema.CallToolResult toolResult = null;
            try {
                String rst = functionTool.handle(request);
                toolResult = new McpSchema.CallToolResult(Arrays.asList(new McpSchema.TextContent(rst)), Boolean.valueOf(false));
            }
            catch (Throwable ex) {
                toolResult = new McpSchema.CallToolResult(Arrays.asList(new McpSchema.TextContent(ex.getMessage())), Boolean.valueOf(true));
            }
            return Mono.just((Object)toolResult);
        });
        mcpServerSpec.tools(new McpServerFeatures.AsyncToolSpecification[]{toolSpec});
    }

    protected ONode buildJsonSchema(FunctionTool functionTool) {
        ONode jsonSchema = new ONode();
        jsonSchema.set("$schema", (Object)"http://json-schema.org/draft-07/schema#");
        jsonSchema.setAll(functionTool.inputSchema());
        return jsonSchema;
    }
}

