/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.client;

import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.HttpClientSseClientTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.io.Closeable;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.RefererFunctionTool;
import org.noear.solon.ai.chat.tool.ToolProvider;
import org.noear.solon.ai.image.Image;
import org.noear.solon.ai.mcp.client.McpClientProperties;
import org.noear.solon.ai.mcp.exception.McpException;
import org.noear.solon.core.Props;

public class McpClientToolProvider
implements ToolProvider,
Closeable {
    private final McpSyncClient client;
    protected AtomicBoolean initialized = new AtomicBoolean(false);

    public McpClientToolProvider(Properties clientProps) {
        this((McpClientProperties)Props.from((Properties)clientProps).bindTo((Object)new McpClientProperties()));
    }

    public McpClientToolProvider(String apiUrl) {
        this(new McpClientProperties(apiUrl));
    }

    public McpClientToolProvider(McpClientProperties clientProps) {
        if (Utils.isEmpty((String)clientProps.getApiUrl())) {
            throw new IllegalArgumentException("ApiUrl is empty!");
        }
        URI url = URI.create(clientProps.getApiUrl());
        String baseUri = url.getScheme() + "://" + url.getAuthority();
        String sseEndpoint = url.getPath();
        if (Utils.isEmpty((String)sseEndpoint)) {
            throw new IllegalArgumentException("SseEndpoint is empty!");
        }
        Duration timeout = clientProps.getTimeout();
        HttpClientSseClientTransport clientTransport = HttpClientSseClientTransport.builder((String)baseUri).sseEndpoint(sseEndpoint).build();
        this.client = McpClient.sync((McpClientTransport)clientTransport).clientInfo(new McpSchema.Implementation(clientProps.getName(), clientProps.getVersion())).build();
    }

    protected McpSyncClient getClient() {
        if (this.initialized.compareAndSet(false, true)) {
            this.client.initialize();
        }
        return this.client;
    }

    public String callToolAsText(String name, Map<String, Object> args) {
        McpSchema.CallToolResult result = this.callTool(name, args);
        if (Utils.isEmpty((Collection)result.content())) {
            return null;
        }
        return ((McpSchema.TextContent)result.content().get(0)).text();
    }

    public Image callToolAsImage(String name, Map<String, Object> args) {
        McpSchema.CallToolResult result = this.callTool(name, args);
        if (Utils.isEmpty((Collection)result.content())) {
            return null;
        }
        McpSchema.ImageContent imageContent = (McpSchema.ImageContent)result.content().get(0);
        return Image.ofBase64((String)imageContent.data(), (String)imageContent.mimeType());
    }

    public McpSchema.CallToolResult callTool(String name, Map<String, Object> args) {
        McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest(name, args);
        McpSchema.CallToolResult response = this.getClient().callTool(callToolRequest);
        if (response.isError() == null || !response.isError().booleanValue()) {
            return response;
        }
        if (Utils.isEmpty((Collection)response.content())) {
            throw new McpException("Call Toll Failed");
        }
        throw new McpException(((McpSchema.Content)response.content().get(0)).toString());
    }

    public Collection<FunctionTool> getTools() {
        ArrayList<FunctionTool> toolList = new ArrayList<FunctionTool>();
        McpSchema.ListToolsResult result = this.getClient().listTools();
        for (McpSchema.Tool tool : result.tools()) {
            String name = tool.name();
            String description = tool.description();
            ONode parametersNode = ONode.load((Object)tool.inputSchema());
            RefererFunctionTool functionRefer = new RefererFunctionTool(name, description, parametersNode, args -> this.callToolAsText(name, (Map<String, Object>)args));
            toolList.add((FunctionTool)functionRefer);
        }
        return toolList;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

