/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.transport.WebRxSseServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.util.Arrays;
import org.noear.snack.ONode;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.ToolProvider;
import org.noear.solon.ai.mcp.server.McpServerProperties;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class McpServerProvider
implements Lifecycle {
    private static Logger log = LoggerFactory.getLogger(McpServerProvider.class);
    private final AppContext appContext;
    private final WebRxSseServerTransportProvider mcpTransportProvider;
    private final McpServer.AsyncSpecification mcpServerSpec;
    private final McpServerProperties serverProperties;
    private McpAsyncServer server;

    public McpServerProvider(AppContext appContext, McpServerProperties serverProperties) {
        this.appContext = appContext;
        this.serverProperties = serverProperties;
        this.mcpTransportProvider = WebRxSseServerTransportProvider.builder().messageEndpoint(serverProperties.getMessageEndpoint()).sseEndpoint(serverProperties.getSseEndpoint()).objectMapper(new ObjectMapper()).build();
        this.mcpServerSpec = McpServer.async((McpServerTransportProvider)this.mcpTransportProvider).serverInfo(serverProperties.getName(), serverProperties.getVersion());
    }

    public void addTool(FunctionTool functionTool) {
        this.addToolSpec(this.mcpServerSpec, functionTool);
    }

    public void addTool(ToolProvider toolProvider) {
        for (FunctionTool functionTool : toolProvider.getTools()) {
            this.addToolSpec(this.mcpServerSpec, functionTool);
        }
    }

    public void start() throws Throwable {
        this.mcpTransportProvider.toHttpHandler(this.appContext.app());
    }

    public void postStart() throws Throwable {
        this.server = this.mcpServerSpec.build();
        log.info("Mcp-Server started, name={}, version={}, sseEndpoint={}", new Object[]{this.serverProperties.getName(), this.serverProperties.getVersion(), this.serverProperties.getSseEndpoint()});
    }

    public void stop() throws Throwable {
        if (this.server != null) {
            this.server.close();
        }
    }

    protected void addToolSpec(McpServer.AsyncSpecification mcpServerSpec, FunctionTool functionTool) {
        ONode jsonSchema = this.buildJsonSchema(functionTool);
        String jsonSchemaStr = jsonSchema.toJson();
        McpServerFeatures.AsyncToolSpecification toolSpec = new McpServerFeatures.AsyncToolSpecification(new McpSchema.Tool(functionTool.name(), functionTool.description(), jsonSchemaStr), (exchange, request) -> {
            McpSchema.CallToolResult toolResult = null;
            try {
                String rst = functionTool.handle(request);
                toolResult = new McpSchema.CallToolResult(Arrays.asList(new McpSchema.TextContent(rst)), Boolean.valueOf(false));
            }
            catch (Throwable ex) {
                toolResult = new McpSchema.CallToolResult(Arrays.asList(new McpSchema.TextContent(ex.getMessage())), Boolean.valueOf(true));
            }
            return Mono.just((Object)toolResult);
        });
        mcpServerSpec.tools(new McpServerFeatures.AsyncToolSpecification[]{toolSpec});
    }

    protected ONode buildJsonSchema(FunctionTool functionTool) {
        ONode jsonSchema = new ONode();
        jsonSchema.set("$schema", (Object)"http://json-schema.org/draft-07/schema#");
        jsonSchema.setAll(functionTool.inputSchema());
        return jsonSchema;
    }
}

