/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.client;

import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.WebRxSseClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.io.Closeable;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.RefererFunctionTool;
import org.noear.solon.ai.chat.tool.ToolProvider;
import org.noear.solon.ai.image.Image;
import org.noear.solon.ai.mcp.client.McpClientProperties;
import org.noear.solon.ai.mcp.exception.McpException;
import org.noear.solon.core.Props;
import org.noear.solon.net.http.HttpTimeout;
import org.noear.solon.net.http.HttpUtilsBuilder;

public class McpClientToolProvider
implements ToolProvider,
Closeable {
    private final McpSyncClient client;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public McpClientToolProvider(Properties clientProps) {
        this((McpClientProperties)Props.from((Properties)clientProps).bindTo((Object)new McpClientProperties()));
    }

    public McpClientToolProvider(String apiUrl) {
        this(new McpClientProperties(apiUrl));
    }

    public McpClientToolProvider(McpClientProperties clientProps) {
        if (Utils.isEmpty((String)clientProps.getApiUrl())) {
            throw new IllegalArgumentException("ApiUrl is empty!");
        }
        URI url = URI.create(clientProps.getApiUrl());
        String baseUri = url.getScheme() + "://" + url.getAuthority();
        String sseEndpoint = null;
        sseEndpoint = Utils.isEmpty((String)url.getRawQuery()) ? url.getRawPath() : url.getRawPath() + "?" + url.getRawQuery();
        if (Utils.isEmpty((String)sseEndpoint)) {
            throw new IllegalArgumentException("SseEndpoint is empty!");
        }
        HttpTimeout httpTimeout = clientProps.getHttpTimeout();
        HttpUtilsBuilder webBuilder = new HttpUtilsBuilder();
        webBuilder.baseUri(baseUri);
        if (Utils.isNotEmpty((String)clientProps.getApiKey())) {
            webBuilder.headerSet("Authorization", "Bearer " + clientProps.getApiKey());
        }
        clientProps.getHeaders().forEach((k, v) -> webBuilder.headerSet(k, v));
        if (httpTimeout != null) {
            webBuilder.timeout(httpTimeout);
        }
        WebRxSseClientTransport clientTransport = WebRxSseClientTransport.builder(webBuilder).sseEndpoint(sseEndpoint).build();
        this.client = McpClient.sync(clientTransport).clientInfo(new McpSchema.Implementation(clientProps.getName(), clientProps.getVersion())).requestTimeout(clientProps.getRequestTimeout()).initializationTimeout(clientProps.getInitializationTimeout()).build();
    }

    public McpSyncClient getClient() {
        if (this.initialized.compareAndSet(false, true)) {
            this.client.initialize();
        }
        return this.client;
    }

    public String callToolAsText(String name, Map<String, Object> args) {
        McpSchema.CallToolResult result = this.callTool(name, args);
        if (Utils.isEmpty(result.getContent())) {
            return null;
        }
        return ((McpSchema.TextContent)result.getContent().get(0)).getText();
    }

    public Image callToolAsImage(String name, Map<String, Object> args) {
        McpSchema.CallToolResult result = this.callTool(name, args);
        if (Utils.isEmpty(result.getContent())) {
            return null;
        }
        McpSchema.ImageContent imageContent = (McpSchema.ImageContent)result.getContent().get(0);
        return Image.ofBase64((String)imageContent.getData(), (String)imageContent.getMimeType());
    }

    protected McpSchema.CallToolResult callTool(String name, Map<String, Object> args) {
        McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest(name, args);
        McpSchema.CallToolResult response = this.getClient().callTool(callToolRequest);
        if (response.getIsError() == null || !response.getIsError().booleanValue()) {
            return response;
        }
        if (Utils.isEmpty(response.getContent())) {
            throw new McpException("Call Toll Failed");
        }
        throw new McpException(response.getContent().get(0).toString());
    }

    public Collection<FunctionTool> getTools() {
        return this.getTools(null);
    }

    public Collection<FunctionTool> getTools(String cursor) {
        ArrayList<FunctionTool> toolList = new ArrayList<FunctionTool>();
        McpSchema.ListToolsResult result = null;
        result = cursor == null ? this.getClient().listTools() : this.getClient().listTools(cursor);
        for (McpSchema.Tool tool : result.getTools()) {
            String name = tool.getName();
            String description = tool.getDescription();
            ONode parametersNode = ONode.load((Object)tool.getInputSchema());
            RefererFunctionTool functionRefer = new RefererFunctionTool(name, description, parametersNode, args -> this.callToolAsText(name, (Map<String, Object>)args));
            toolList.add((FunctionTool)functionRefer);
        }
        return toolList;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private McpClientProperties props = new McpClientProperties();

        public Builder name(String name) {
            this.props.setName(name);
            return this;
        }

        public Builder version(String version) {
            this.props.setVersion(version);
            return this;
        }

        public Builder apiUrl(String apiUrl) {
            this.props.setApiUrl(apiUrl);
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.props.setApiKey(apiKey);
            return this;
        }

        public Builder header(String name, String value) {
            this.props.getHeaders().put(name, value);
            return this;
        }

        public Builder httpTimeout(HttpTimeout httpTimeout) {
            this.props.setHttpTimeout(httpTimeout);
            return this;
        }

        public Builder requestTimeout(Duration requestTimeout) {
            this.props.setRequestTimeout(requestTimeout);
            return this;
        }

        public Builder initializationTimeout(Duration initializationTimeout) {
            this.props.setInitializationTimeout(initializationTimeout);
            return this;
        }

        public McpClientToolProvider build() {
            return new McpClientToolProvider(this.props);
        }
    }
}

