/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.integration;

import org.noear.solon.Utils;
import org.noear.solon.ai.chat.tool.MethodToolProvider;
import org.noear.solon.ai.chat.tool.ToolProvider;
import org.noear.solon.ai.mcp.server.McpServerEndpointProvider;
import org.noear.solon.ai.mcp.server.McpServerProperties;
import org.noear.solon.ai.mcp.server.annotation.McpServerEndpoint;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.util.ConvertUtil;

public class McpPlugin
implements Plugin {
    public void start(AppContext context) throws Throwable {
        context.beanBuilderAdd(McpServerEndpoint.class, (clz, bw, anno) -> {
            bw.context().beanExtractOrProxy(bw, false, true);
            McpServerProperties props = new McpServerProperties();
            if (Utils.isEmpty((String)anno.name())) {
                props.setName(clz.getSimpleName());
            } else {
                props.setName(anno.name());
            }
            props.setVersion(anno.version());
            props.setSseEndpoint(anno.sseEndpoint());
            if (Utils.isEmpty((String)anno.heartbeatInterval())) {
                props.setHeartbeatInterval(null);
            } else {
                props.setHeartbeatInterval(ConvertUtil.durationOf((String)anno.heartbeatInterval()));
            }
            McpServerEndpointProvider serverEndpointProvider = new McpServerEndpointProvider(props);
            serverEndpointProvider.addTool((ToolProvider)new MethodToolProvider(bw.rawClz(), bw.raw()));
            bw.context().lifecycle((LifecycleBean)serverEndpointProvider);
            if (Utils.isNotEmpty((String)anno.name())) {
                bw.context().wrapAndPut(anno.name(), (Object)serverEndpointProvider);
            }
        });
    }
}

