/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.transport.WebRxSseServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import java.time.Duration;
import java.util.Arrays;
import java.util.Properties;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.ToolProvider;
import org.noear.solon.ai.mcp.server.McpServerProperties;
import org.noear.solon.core.Props;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.core.util.RunUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpServerEndpointProvider
implements LifecycleBean {
    private static Logger log = LoggerFactory.getLogger(McpServerEndpointProvider.class);
    private final WebRxSseServerTransportProvider mcpTransportProvider;
    private final McpServer.SyncSpecification mcpServerSpec;
    private final McpServerProperties serverProperties;
    private final String sseEndpoint;
    private final String messageEndpoint;
    private McpSyncServer server;
    private int toolCount = 0;

    public McpServerEndpointProvider(Properties properties) {
        this((McpServerProperties)Props.from((Properties)properties).bindTo((Object)new McpServerProperties()));
    }

    public McpServerEndpointProvider(McpServerProperties serverProperties) {
        this.serverProperties = serverProperties;
        this.sseEndpoint = serverProperties.getSseEndpoint();
        this.messageEndpoint = PathUtil.mergePath((String)this.sseEndpoint, (String)"message");
        this.mcpTransportProvider = WebRxSseServerTransportProvider.builder().messageEndpoint(this.messageEndpoint).sseEndpoint(this.sseEndpoint).objectMapper(new ObjectMapper()).build();
        this.mcpServerSpec = McpServer.sync(this.mcpTransportProvider).serverInfo(serverProperties.getName(), serverProperties.getVersion());
    }

    public String getName() {
        return this.serverProperties.getName();
    }

    public String getSseEndpoint() {
        return this.sseEndpoint;
    }

    public WebRxSseServerTransportProvider getTransport() {
        return this.mcpTransportProvider;
    }

    public void addTool(FunctionTool functionTool) {
        this.addToolSpec(functionTool);
    }

    public void addTool(ToolProvider toolProvider) {
        for (FunctionTool functionTool : toolProvider.getTools()) {
            this.addToolSpec(functionTool);
        }
    }

    public void removeTool(String toolName) {
        if (this.server != null) {
            this.server.removeTool(toolName);
        }
    }

    public void removeTool(ToolProvider toolProvider) {
        if (this.server != null) {
            for (FunctionTool functionTool : toolProvider.getTools()) {
                this.server.removeTool(functionTool.name());
            }
        }
    }

    public void notifyToolsListChanged() {
        if (this.server != null) {
            this.server.notifyToolsListChanged();
        }
    }

    public void start() throws Throwable {
        this.mcpTransportProvider.toHttpHandler(Solon.app());
    }

    public void postStart() throws Throwable {
        this.server = this.mcpServerSpec.build();
        log.info("Mcp-Server started, name={}, version={}, sseEndpoint={}, messageEndpoint={}, toolRegistered={}", new Object[]{this.serverProperties.getName(), this.serverProperties.getVersion(), this.sseEndpoint, this.messageEndpoint, this.toolCount});
        if (this.serverProperties.getHeartbeatInterval() != null && this.serverProperties.getHeartbeatInterval().getSeconds() > 0L) {
            RunUtil.delayAndRepeat(() -> RunUtil.runAndTry(() -> this.mcpTransportProvider.sendHeartbeat()), (long)this.serverProperties.getHeartbeatInterval().toMillis());
        }
    }

    public void stop() throws Throwable {
        if (this.server != null) {
            this.server.close();
        }
    }

    protected void addToolSpec(FunctionTool functionTool) {
        ONode jsonSchema = this.buildJsonSchema(functionTool);
        String jsonSchemaStr = jsonSchema.toJson();
        McpServerFeatures.SyncToolSpecification toolSpec = new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool(functionTool.name(), functionTool.description(), jsonSchemaStr), (exchange, request) -> {
            McpSchema.CallToolResult toolResult = null;
            try {
                String rst = functionTool.handle(request);
                toolResult = new McpSchema.CallToolResult(Arrays.asList(new McpSchema.TextContent(rst)), false);
            }
            catch (Throwable ex) {
                toolResult = new McpSchema.CallToolResult(Arrays.asList(new McpSchema.TextContent(ex.getMessage())), true);
            }
            return toolResult;
        });
        ++this.toolCount;
        if (this.server != null) {
            this.server.addTool(toolSpec);
        } else {
            this.mcpServerSpec.tools(toolSpec);
        }
    }

    protected ONode buildJsonSchema(FunctionTool functionTool) {
        ONode jsonSchema = new ONode();
        jsonSchema.set("$schema", (Object)"http://json-schema.org/draft-07/schema#");
        jsonSchema.setAll(functionTool.inputSchema());
        return jsonSchema;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private McpServerProperties props = new McpServerProperties();

        public Builder name(String name) {
            this.props.setName(name);
            return this;
        }

        public Builder version(String version) {
            this.props.setVersion(version);
            return this;
        }

        public Builder sseEndpoint(String sseEndpoint) {
            this.props.setSseEndpoint(sseEndpoint);
            return this;
        }

        public Builder heartbeatInterval(Duration sseHeartbeatInterval) {
            this.props.setHeartbeatInterval(sseHeartbeatInterval);
            return this;
        }

        public McpServerEndpointProvider build() {
            return new McpServerEndpointProvider(this.props);
        }
    }
}

