/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.util;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import reactor.util.annotation.Nullable;

public final class Utils {
    public static boolean hasText(@Nullable String str) {
        return str != null && !str.isEmpty() && !str.trim().isEmpty();
    }

    public static boolean isEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <T> CompletableFuture<T> toCompletableFuture(Future<T> future) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static CompletableFuture<Void> toCompletableFutureDiscard(Future<?> future) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                future.get();
                return null;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

