/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.client;

import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.ServerParameters;
import io.modelcontextprotocol.client.transport.StdioClientTransport;
import io.modelcontextprotocol.client.transport.WebRxSseClientTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.RefererFunctionTool;
import org.noear.solon.ai.chat.tool.ToolProvider;
import org.noear.solon.ai.image.Image;
import org.noear.solon.ai.mcp.client.McpClientProperties;
import org.noear.solon.ai.mcp.client.McpServerParameters;
import org.noear.solon.ai.mcp.exception.McpException;
import org.noear.solon.core.Props;
import org.noear.solon.core.util.Assert;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.http.HttpProxy;
import org.noear.solon.net.http.HttpTimeout;
import org.noear.solon.net.http.HttpUtilsBuilder;

public class McpClientToolProvider
implements ToolProvider,
Closeable {
    private final ReentrantLock LOCKER = new ReentrantLock();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final McpClientProperties clientProps;
    private ScheduledExecutorService heartbeatExecutor;
    private McpSyncClient client;

    public McpClientToolProvider(Properties clientProps) {
        this((McpClientProperties)Props.from((Properties)clientProps).bindTo((Object)new McpClientProperties()));
    }

    public McpClientToolProvider(String apiUrl) {
        this(new McpClientProperties(apiUrl));
    }

    public McpClientToolProvider(McpClientProperties clientProps) {
        if (clientProps.getHeartbeatInterval() != null && clientProps.getHeartbeatInterval().getSeconds() < 10L) {
            throw new IllegalArgumentException("HeartbeatInterval cannot be less than 10s!");
        }
        if ("stdio".equals(clientProps.getChannel())) {
            if (clientProps.getServerParameters() == null) {
                throw new IllegalArgumentException("ServerParameters is null!");
            }
        } else if (Utils.isEmpty((String)clientProps.getApiUrl())) {
            throw new IllegalArgumentException("ApiUrl is empty!");
        }
        this.clientProps = clientProps;
        this.heartbeatHandle();
    }

    private McpSyncClient buildClient() {
        McpClientTransport clientTransport;
        if ("stdio".equals(this.clientProps.getChannel())) {
            clientTransport = new StdioClientTransport(ServerParameters.builder(this.clientProps.getServerParameters().getCommand()).args(this.clientProps.getServerParameters().getArgs()).env(this.clientProps.getServerParameters().getEnv()).build());
        } else {
            URI url = URI.create(this.clientProps.getApiUrl());
            String baseUri = url.getScheme() + "://" + url.getAuthority();
            String sseEndpoint = null;
            sseEndpoint = Utils.isEmpty((String)url.getRawQuery()) ? url.getRawPath() : url.getRawPath() + "?" + url.getRawQuery();
            if (Utils.isEmpty((String)sseEndpoint)) {
                throw new IllegalArgumentException("SseEndpoint is empty!");
            }
            HttpTimeout httpTimeout = this.clientProps.getHttpTimeout();
            HttpUtilsBuilder webBuilder = new HttpUtilsBuilder();
            webBuilder.baseUri(baseUri);
            if (Utils.isNotEmpty((String)this.clientProps.getApiKey())) {
                webBuilder.headerSet("Authorization", "Bearer " + this.clientProps.getApiKey());
            }
            this.clientProps.getHeaders().forEach((k, v) -> webBuilder.headerSet(k, v));
            if (httpTimeout != null) {
                webBuilder.timeout(httpTimeout);
            }
            clientTransport = WebRxSseClientTransport.builder(webBuilder).sseEndpoint(sseEndpoint).build();
        }
        return McpClient.sync(clientTransport).clientInfo(new McpSchema.Implementation(this.clientProps.getName(), this.clientProps.getVersion())).requestTimeout(this.clientProps.getRequestTimeout()).initializationTimeout(this.clientProps.getInitializationTimeout()).build();
    }

    public McpSyncClient getClient() {
        this.LOCKER.lock();
        try {
            if (this.isClosed.get()) {
                throw new IllegalStateException("The current status has been closed.");
            }
            this.isStarted.set(true);
            if (this.client == null) {
                this.client = this.buildClient();
            }
            if (!this.client.isInitialized()) {
                this.client.initialize();
            }
            McpSyncClient mcpSyncClient = this.client;
            return mcpSyncClient;
        }
        finally {
            this.LOCKER.unlock();
        }
    }

    private void heartbeatHandle() {
        if (this.heartbeatExecutor == null) {
            this.heartbeatExecutor = Executors.newSingleThreadScheduledExecutor();
        }
        this.heartbeatHandleDo();
    }

    private void heartbeatHandleDo() {
        if (this.heartbeatExecutor == null) {
            return;
        }
        if (this.clientProps.getHeartbeatInterval() == null) {
            return;
        }
        this.heartbeatExecutor.schedule(() -> {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (!this.isClosed.get()) {
                if (this.isStarted.get()) {
                    RunUtil.runAndTry(() -> {
                        try {
                            this.getClient().ping();
                        }
                        catch (Throwable ex) {
                            this.reset();
                        }
                    });
                }
                this.heartbeatHandleDo();
            }
        }, this.clientProps.getHeartbeatInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.LOCKER.lock();
        try {
            if (!this.isClosed.get()) {
                this.isClosed.set(true);
                this.isStarted.set(false);
                if (this.heartbeatExecutor != null) {
                    this.heartbeatExecutor.shutdownNow();
                    this.heartbeatExecutor = null;
                }
                this.reset();
            }
        }
        finally {
            this.LOCKER.unlock();
        }
    }

    public void reopen() {
        this.LOCKER.lock();
        try {
            if (this.isClosed.get()) {
                this.isClosed.set(false);
                this.getClient();
                this.heartbeatHandle();
            }
        }
        finally {
            this.LOCKER.unlock();
        }
    }

    private void reset() {
        this.LOCKER.lock();
        try {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
        finally {
            this.LOCKER.unlock();
        }
    }

    public String callToolAsText(String name, Map<String, Object> args) {
        McpSchema.CallToolResult result = this.callTool(name, args);
        if (Utils.isEmpty(result.getContent())) {
            return null;
        }
        return ((McpSchema.TextContent)result.getContent().get(0)).getText();
    }

    public Image callToolAsImage(String name, Map<String, Object> args) {
        McpSchema.CallToolResult result = this.callTool(name, args);
        if (Utils.isEmpty(result.getContent())) {
            return null;
        }
        McpSchema.ImageContent imageContent = (McpSchema.ImageContent)result.getContent().get(0);
        return Image.ofBase64((String)imageContent.getData(), (String)imageContent.getMimeType());
    }

    protected McpSchema.CallToolResult callTool(String name, Map<String, Object> args) {
        try {
            McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest(name, args);
            McpSchema.CallToolResult response = this.getClient().callTool(callToolRequest);
            if (response.getIsError() == null || !response.getIsError().booleanValue()) {
                return response;
            }
            if (Utils.isEmpty(response.getContent())) {
                throw new McpException("Call Toll Failed");
            }
            throw new McpException(response.getContent().get(0).toString());
        }
        catch (RuntimeException ex) {
            this.reset();
            throw ex;
        }
    }

    public Collection<FunctionTool> getTools() {
        return this.getTools(null);
    }

    public Collection<FunctionTool> getTools(String cursor) {
        ArrayList<FunctionTool> toolList = new ArrayList<FunctionTool>();
        McpSchema.ListToolsResult result = null;
        result = cursor == null ? this.getClient().listTools() : this.getClient().listTools(cursor);
        for (McpSchema.Tool tool : result.getTools()) {
            String name = tool.getName();
            String description = tool.getDescription();
            ONode parametersNode = ONode.load((Object)tool.getInputSchema());
            RefererFunctionTool functionRefer = new RefererFunctionTool(name, description, parametersNode, args -> this.callToolAsText(name, (Map<String, Object>)args));
            toolList.add((FunctionTool)functionRefer);
        }
        return toolList;
    }

    public static Map<String, McpClientToolProvider> fromMcpServers(String uri) throws IOException {
        Assert.notEmpty((String)uri, (String)"Uri is empty");
        URL res = ResourceUtil.findResource((String)uri);
        String json = ResourceUtil.getResourceAsString((URL)res);
        ONode jsonDom = ONode.loadStr((String)json);
        HashMap<String, McpClientToolProvider> map = new HashMap<String, McpClientToolProvider>();
        for (Map.Entry kv : jsonDom.get("mcpServers").obj().entrySet()) {
            String name = (String)kv.getKey();
            Map env = (Map)((ONode)kv.getValue()).get("env").toObject(new HashMap<String, String>(){}.getClass());
            String type = ((ONode)kv.getValue()).get("type").getString();
            if (Utils.isEmpty((String)type)) {
                type = ((ONode)kv.getValue()).contains("url") ? "sse" : "stdio";
            }
            Builder builder = McpClientToolProvider.builder().channel(type);
            if ("stdio".equalsIgnoreCase(type)) {
                String command = ((ONode)kv.getValue()).get("command").getString();
                List args = (List)((ONode)kv.getValue()).get("args").toObject(new ArrayList<String>(){}.getClass());
                builder.serverParameters(McpServerParameters.builder(command).args(args).env(env).build());
            } else {
                String url = ((ONode)kv.getValue()).get("url").getString();
                builder.apiUrl(url).headerSet(env);
            }
            map.put(name, builder.build());
        }
        return map;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private McpClientProperties props = new McpClientProperties();

        public Builder name(String name) {
            this.props.setName(name);
            return this;
        }

        public Builder version(String version) {
            this.props.setVersion(version);
            return this;
        }

        public Builder channel(String channel) {
            this.props.setChannel(channel);
            return this;
        }

        public Builder apiUrl(String apiUrl) {
            this.props.setApiUrl(apiUrl);
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.props.setApiKey(apiKey);
            return this;
        }

        public Builder headerSet(String name, String value) {
            this.props.getHeaders().put(name, value);
            return this;
        }

        public Builder headerSet(Map<String, String> headers) {
            if (Utils.isNotEmpty(headers)) {
                this.props.getHeaders().putAll(headers);
            }
            return this;
        }

        public Builder httpTimeout(HttpTimeout httpTimeout) {
            this.props.setHttpTimeout(httpTimeout);
            return this;
        }

        public Builder httpProxy(HttpProxy httpProxy) {
            this.props.setHttpProxy(httpProxy);
            return this;
        }

        public Builder httpProxy(String host, int port) {
            return this.httpProxy(HttpProxy.of((String)host, (int)port));
        }

        public Builder requestTimeout(Duration requestTimeout) {
            this.props.setRequestTimeout(requestTimeout);
            return this;
        }

        public Builder initializationTimeout(Duration initializationTimeout) {
            this.props.setInitializationTimeout(initializationTimeout);
            return this;
        }

        public Builder heartbeatInterval(Duration heartbeatInterval) {
            this.props.setHeartbeatInterval(heartbeatInterval);
            return this;
        }

        public Builder serverParameters(McpServerParameters serverParameters) {
            this.props.setServerParameters(serverParameters);
            return this;
        }

        public McpClientToolProvider build() {
            return new McpClientToolProvider(this.props);
        }
    }
}

