/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.server.manager;

import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.Utils;
import org.noear.solon.ai.mcp.exception.McpException;
import org.noear.solon.ai.mcp.server.McpServerContext;
import org.noear.solon.ai.mcp.server.manager.McpServerManager;
import org.noear.solon.ai.mcp.server.resource.FunctionResource;
import org.noear.solon.ai.media.Text;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextHolder;

public class ResourceMcpServerManager
implements McpServerManager<FunctionResource> {
    private final Map<String, FunctionResource> resourcesMap = new ConcurrentHashMap<String, FunctionResource>();

    @Override
    public int count() {
        return this.resourcesMap.size();
    }

    @Override
    public Collection<FunctionResource> all() {
        return this.resourcesMap.values();
    }

    @Override
    public void remove(McpSyncServer server, String resourceUri) {
        if (server != null) {
            server.removeResource(resourceUri);
            this.resourcesMap.remove(resourceUri);
        }
    }

    @Override
    public void add(McpSyncServer server, McpServer.SyncSpecification mcpServerSpec, FunctionResource functionResource) {
        this.resourcesMap.put(functionResource.uri(), functionResource);
        if (functionResource.uri().indexOf(123) < 0) {
            McpServerFeatures.SyncResourceSpecification resourceSpec = new McpServerFeatures.SyncResourceSpecification(new McpSchema.Resource(functionResource.uri(), functionResource.name(), functionResource.description(), functionResource.mimeType(), null), (exchange, request) -> {
                try {
                    ContextHolder.currentSet((Context)new McpServerContext((McpSyncServerExchange)exchange));
                    Text res = functionResource.handle(request.getUri());
                    if (res.isBase64()) {
                        McpSchema.ReadResourceResult readResourceResult = new McpSchema.ReadResourceResult(Arrays.asList(new McpSchema.BlobResourceContents(request.getUri(), functionResource.mimeType(), res.getContent())));
                        return readResourceResult;
                    }
                    McpSchema.ReadResourceResult readResourceResult = new McpSchema.ReadResourceResult(Arrays.asList(new McpSchema.TextResourceContents(request.getUri(), functionResource.mimeType(), res.getContent())));
                    return readResourceResult;
                }
                catch (Throwable ex) {
                    ex = Utils.throwableUnwrap((Throwable)ex);
                    throw new McpException(ex.getMessage(), ex);
                }
                finally {
                    ContextHolder.currentRemove();
                }
            });
            if (server != null) {
                server.addResource(resourceSpec);
            } else {
                mcpServerSpec.resources(resourceSpec);
            }
        } else {
            McpSchema.Annotations annotations = null;
            mcpServerSpec.resourceTemplates(new McpSchema.ResourceTemplate(functionResource.uri(), functionResource.name(), functionResource.description(), functionResource.mimeType(), annotations));
        }
    }
}

