/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.server.prompt;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.noear.snack.ONode;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.ai.mcp.server.prompt.FunctionPrompt;
import org.noear.solon.ai.util.ParamDesc;

public class FunctionPromptDesc
implements FunctionPrompt {
    private final String name;
    private final List<ParamDesc> params;
    private String description;
    private Function<Map<String, Object>, Collection<ChatMessage>> doHandler;

    public FunctionPromptDesc(String name) {
        this.name = name;
        this.params = new ArrayList<ParamDesc>();
    }

    public FunctionPromptDesc description(String description) {
        this.description = description;
        return this;
    }

    public FunctionPromptDesc param(String name, String description) {
        return this.param(name, true, description);
    }

    public FunctionPromptDesc param(String name, boolean required, String description) {
        this.params.add(new ParamDesc(name, String.class, required, description));
        return this;
    }

    public FunctionPromptDesc doHandle(Function<Map<String, Object>, Collection<ChatMessage>> handler) {
        this.doHandler = handler;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Collection<ParamDesc> params() {
        return this.params;
    }

    @Override
    public Collection<ChatMessage> handle(Map<String, Object> args) throws Throwable {
        HashMap<String, Object> argsNew = new HashMap<String, Object>();
        ONode argsNode = ONode.load(args);
        for (ParamDesc p1 : this.params) {
            ONode v1 = argsNode.getOrNull(p1.name());
            if (v1 == null) {
                argsNew.put(p1.name(), null);
                continue;
            }
            argsNew.put(p1.name(), v1.toObject((Type)p1.type()));
        }
        return this.doHandler.apply(argsNew);
    }

    public String toString() {
        return "FunctionPromptDesc{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", params=" + this.params + '}';
    }
}

