/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.spec;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class McpSchema {
    private static final Logger logger = LoggerFactory.getLogger(McpSchema.class);
    public static final String LATEST_PROTOCOL_VERSION = "2024-11-05";
    public static final String JSONRPC_VERSION = "2.0";
    public static final String METHOD_INITIALIZE = "initialize";
    public static final String METHOD_NOTIFICATION_INITIALIZED = "notifications/initialized";
    public static final String METHOD_PING = "ping";
    public static final String METHOD_TOOLS_LIST = "tools/list";
    public static final String METHOD_TOOLS_CALL = "tools/call";
    public static final String METHOD_NOTIFICATION_TOOLS_LIST_CHANGED = "notifications/tools/list_changed";
    public static final String METHOD_RESOURCES_LIST = "resources/list";
    public static final String METHOD_RESOURCES_READ = "resources/read";
    public static final String METHOD_NOTIFICATION_RESOURCES_LIST_CHANGED = "notifications/resources/list_changed";
    public static final String METHOD_RESOURCES_TEMPLATES_LIST = "resources/templates/list";
    public static final String METHOD_RESOURCES_SUBSCRIBE = "resources/subscribe";
    public static final String METHOD_RESOURCES_UNSUBSCRIBE = "resources/unsubscribe";
    public static final String METHOD_PROMPT_LIST = "prompts/list";
    public static final String METHOD_PROMPT_GET = "prompts/get";
    public static final String METHOD_NOTIFICATION_PROMPTS_LIST_CHANGED = "notifications/prompts/list_changed";
    public static final String METHOD_LOGGING_SET_LEVEL = "logging/setLevel";
    public static final String METHOD_NOTIFICATION_MESSAGE = "notifications/message";
    public static final String METHOD_ROOTS_LIST = "roots/list";
    public static final String METHOD_NOTIFICATION_ROOTS_LIST_CHANGED = "notifications/roots/list_changed";
    public static final String METHOD_SAMPLING_CREATE_MESSAGE = "sampling/createMessage";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<HashMap<String, Object>> MAP_TYPE_REF = new TypeReference<HashMap<String, Object>>(){};

    private McpSchema() {
    }

    public static JSONRPCMessage deserializeJsonRpcMessage(ObjectMapper objectMapper, String jsonText) throws IOException {
        logger.debug("Received JSON message: {}", (Object)jsonText);
        HashMap map = (HashMap)objectMapper.readValue(jsonText, MAP_TYPE_REF);
        if (map.containsKey("method") && map.containsKey("id")) {
            return (JSONRPCMessage)objectMapper.convertValue((Object)map, JSONRPCRequest.class);
        }
        if (map.containsKey("method") && !map.containsKey("id")) {
            return (JSONRPCMessage)objectMapper.convertValue((Object)map, JSONRPCNotification.class);
        }
        if (map.containsKey("result") || map.containsKey("error")) {
            return (JSONRPCMessage)objectMapper.convertValue((Object)map, JSONRPCResponse.class);
        }
        throw new IllegalArgumentException("Cannot deserialize JSONRPCMessage: " + jsonText);
    }

    public static JSONRPCMessage deserializeJsonRpcMessage(ObjectMapper objectMapper, JsonNode jsonNode) throws IOException {
        logger.debug("Received JSON message: {}", (Object)jsonNode);
        if (jsonNode.has("method") && jsonNode.has("id")) {
            return (JSONRPCMessage)objectMapper.treeToValue((TreeNode)jsonNode, JSONRPCRequest.class);
        }
        if (jsonNode.has("method") && !jsonNode.has("id")) {
            return (JSONRPCMessage)objectMapper.treeToValue((TreeNode)jsonNode, JSONRPCNotification.class);
        }
        if (jsonNode.has("result") || jsonNode.has("error")) {
            return (JSONRPCMessage)objectMapper.treeToValue((TreeNode)jsonNode, JSONRPCResponse.class);
        }
        throw new IllegalArgumentException("Cannot deserialize JSONRPCMessage: " + jsonNode);
    }

    private static JsonSchema parseSchema(String schema) {
        try {
            return (JsonSchema)OBJECT_MAPPER.readValue(schema, JsonSchema.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid schema: " + schema, e);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListRootsResult {
        @JsonProperty(value="roots")
        List<Root> roots;

        @Generated
        public List<Root> getRoots() {
            return this.roots;
        }

        @JsonProperty(value="roots")
        @Generated
        public void setRoots(List<Root> roots) {
            this.roots = roots;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListRootsResult)) {
                return false;
            }
            ListRootsResult other = (ListRootsResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Root> this$roots = this.getRoots();
            List<Root> other$roots = other.getRoots();
            return !(this$roots == null ? other$roots != null : !((Object)this$roots).equals(other$roots));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ListRootsResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Root> $roots = this.getRoots();
            result = result * 59 + ($roots == null ? 43 : ((Object)$roots).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ListRootsResult(roots=" + this.getRoots() + ")";
        }

        @Generated
        public ListRootsResult(List<Root> roots) {
            this.roots = roots;
        }

        @Generated
        public ListRootsResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Root {
        @JsonProperty(value="uri")
        String uri;
        @JsonProperty(value="name")
        String name;

        @Generated
        public String getUri() {
            return this.uri;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Root)) {
                return false;
            }
            Root other = (Root)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Root;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.Root(uri=" + this.getUri() + ", name=" + this.getName() + ")";
        }

        @Generated
        public Root(String uri, String name) {
            this.uri = uri;
            this.name = name;
        }

        @Generated
        public Root() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class EmbeddedResource
    implements Content {
        @JsonProperty(value="audience")
        List<Role> audience;
        @JsonProperty(value="priority")
        Double priority;
        @JsonProperty(value="resource")
        ResourceContents resource;

        @Generated
        public List<Role> getAudience() {
            return this.audience;
        }

        @Generated
        public Double getPriority() {
            return this.priority;
        }

        @Generated
        public ResourceContents getResource() {
            return this.resource;
        }

        @JsonProperty(value="audience")
        @Generated
        public void setAudience(List<Role> audience) {
            this.audience = audience;
        }

        @JsonProperty(value="priority")
        @Generated
        public void setPriority(Double priority) {
            this.priority = priority;
        }

        @JsonProperty(value="resource")
        @Generated
        public void setResource(ResourceContents resource) {
            this.resource = resource;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EmbeddedResource)) {
                return false;
            }
            EmbeddedResource other = (EmbeddedResource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$priority = this.getPriority();
            Double other$priority = other.getPriority();
            if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
                return false;
            }
            List<Role> this$audience = this.getAudience();
            List<Role> other$audience = other.getAudience();
            if (this$audience == null ? other$audience != null : !((Object)this$audience).equals(other$audience)) {
                return false;
            }
            ResourceContents this$resource = this.getResource();
            ResourceContents other$resource = other.getResource();
            return !(this$resource == null ? other$resource != null : !this$resource.equals(other$resource));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EmbeddedResource;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $priority = this.getPriority();
            result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
            List<Role> $audience = this.getAudience();
            result = result * 59 + ($audience == null ? 43 : ((Object)$audience).hashCode());
            ResourceContents $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.EmbeddedResource(audience=" + this.getAudience() + ", priority=" + this.getPriority() + ", resource=" + this.getResource() + ")";
        }

        @Generated
        public EmbeddedResource(List<Role> audience, Double priority, ResourceContents resource) {
            this.audience = audience;
            this.priority = priority;
            this.resource = resource;
        }

        @Generated
        public EmbeddedResource() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ImageContent
    implements Content {
        @JsonProperty(value="audience")
        List<Role> audience;
        @JsonProperty(value="priority")
        Double priority;
        @JsonProperty(value="data")
        String data;
        @JsonProperty(value="mimeType")
        String mimeType;

        @Generated
        public List<Role> getAudience() {
            return this.audience;
        }

        @Generated
        public Double getPriority() {
            return this.priority;
        }

        @Generated
        public String getData() {
            return this.data;
        }

        @Generated
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonProperty(value="audience")
        @Generated
        public void setAudience(List<Role> audience) {
            this.audience = audience;
        }

        @JsonProperty(value="priority")
        @Generated
        public void setPriority(Double priority) {
            this.priority = priority;
        }

        @JsonProperty(value="data")
        @Generated
        public void setData(String data) {
            this.data = data;
        }

        @JsonProperty(value="mimeType")
        @Generated
        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImageContent)) {
                return false;
            }
            ImageContent other = (ImageContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$priority = this.getPriority();
            Double other$priority = other.getPriority();
            if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
                return false;
            }
            List<Role> this$audience = this.getAudience();
            List<Role> other$audience = other.getAudience();
            if (this$audience == null ? other$audience != null : !((Object)this$audience).equals(other$audience)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$mimeType = this.getMimeType();
            String other$mimeType = other.getMimeType();
            return !(this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ImageContent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $priority = this.getPriority();
            result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
            List<Role> $audience = this.getAudience();
            result = result * 59 + ($audience == null ? 43 : ((Object)$audience).hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $mimeType = this.getMimeType();
            result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ImageContent(audience=" + this.getAudience() + ", priority=" + this.getPriority() + ", data=" + this.getData() + ", mimeType=" + this.getMimeType() + ")";
        }

        @Generated
        public ImageContent(List<Role> audience, Double priority, String data, String mimeType) {
            this.audience = audience;
            this.priority = priority;
            this.data = data;
            this.mimeType = mimeType;
        }

        @Generated
        public ImageContent() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TextContent
    implements Content {
        @JsonProperty(value="audience")
        List<Role> audience;
        @JsonProperty(value="priority")
        Double priority;
        @JsonProperty(value="text")
        String text;

        public TextContent(String content) {
            this(null, null, content);
        }

        @Generated
        public List<Role> getAudience() {
            return this.audience;
        }

        @Generated
        public Double getPriority() {
            return this.priority;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @JsonProperty(value="audience")
        @Generated
        public void setAudience(List<Role> audience) {
            this.audience = audience;
        }

        @JsonProperty(value="priority")
        @Generated
        public void setPriority(Double priority) {
            this.priority = priority;
        }

        @JsonProperty(value="text")
        @Generated
        public void setText(String text) {
            this.text = text;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TextContent)) {
                return false;
            }
            TextContent other = (TextContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$priority = this.getPriority();
            Double other$priority = other.getPriority();
            if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
                return false;
            }
            List<Role> this$audience = this.getAudience();
            List<Role> other$audience = other.getAudience();
            if (this$audience == null ? other$audience != null : !((Object)this$audience).equals(other$audience)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TextContent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $priority = this.getPriority();
            result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
            List<Role> $audience = this.getAudience();
            result = result * 59 + ($audience == null ? 43 : ((Object)$audience).hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.TextContent(audience=" + this.getAudience() + ", priority=" + this.getPriority() + ", text=" + this.getText() + ")";
        }

        @Generated
        public TextContent(List<Role> audience, Double priority, String text) {
            this.audience = audience;
            this.priority = priority;
            this.text = text;
        }

        @Generated
        public TextContent() {
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextContent.class, name="text"), @JsonSubTypes.Type(value=ImageContent.class, name="image"), @JsonSubTypes.Type(value=EmbeddedResource.class, name="resource")})
    public static interface Content {
        default public String type() {
            if (this instanceof TextContent) {
                return "text";
            }
            if (this instanceof ImageContent) {
                return "image";
            }
            if (this instanceof EmbeddedResource) {
                return "resource";
            }
            throw new IllegalArgumentException("Unknown content type: " + this);
        }
    }

    public static class CompleteResult {
        CompleteCompletion completion;

        @Generated
        public CompleteCompletion getCompletion() {
            return this.completion;
        }

        @Generated
        public void setCompletion(CompleteCompletion completion) {
            this.completion = completion;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompleteResult)) {
                return false;
            }
            CompleteResult other = (CompleteResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CompleteCompletion this$completion = this.getCompletion();
            CompleteCompletion other$completion = other.getCompletion();
            return !(this$completion == null ? other$completion != null : !((Object)this$completion).equals(other$completion));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CompleteResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CompleteCompletion $completion = this.getCompletion();
            result = result * 59 + ($completion == null ? 43 : ((Object)$completion).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.CompleteResult(completion=" + this.getCompletion() + ")";
        }

        @Generated
        public CompleteResult(CompleteCompletion completion) {
            this.completion = completion;
        }

        @Generated
        public CompleteResult() {
        }

        public static class CompleteCompletion {
            @JsonProperty(value="values")
            List<String> values;
            @JsonProperty(value="total")
            Integer total;
            @JsonProperty(value="hasMore")
            Boolean hasMore;

            @Generated
            public List<String> getValues() {
                return this.values;
            }

            @Generated
            public Integer getTotal() {
                return this.total;
            }

            @Generated
            public Boolean getHasMore() {
                return this.hasMore;
            }

            @JsonProperty(value="values")
            @Generated
            public void setValues(List<String> values) {
                this.values = values;
            }

            @JsonProperty(value="total")
            @Generated
            public void setTotal(Integer total) {
                this.total = total;
            }

            @JsonProperty(value="hasMore")
            @Generated
            public void setHasMore(Boolean hasMore) {
                this.hasMore = hasMore;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CompleteCompletion)) {
                    return false;
                }
                CompleteCompletion other = (CompleteCompletion)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$total = this.getTotal();
                Integer other$total = other.getTotal();
                if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
                    return false;
                }
                Boolean this$hasMore = this.getHasMore();
                Boolean other$hasMore = other.getHasMore();
                if (this$hasMore == null ? other$hasMore != null : !((Object)this$hasMore).equals(other$hasMore)) {
                    return false;
                }
                List<String> this$values = this.getValues();
                List<String> other$values = other.getValues();
                return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CompleteCompletion;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $total = this.getTotal();
                result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
                Boolean $hasMore = this.getHasMore();
                result = result * 59 + ($hasMore == null ? 43 : ((Object)$hasMore).hashCode());
                List<String> $values = this.getValues();
                result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.CompleteResult.CompleteCompletion(values=" + this.getValues() + ", total=" + this.getTotal() + ", hasMore=" + this.getHasMore() + ")";
            }

            @Generated
            public CompleteCompletion(List<String> values, Integer total, Boolean hasMore) {
                this.values = values;
                this.total = total;
                this.hasMore = hasMore;
            }

            @Generated
            public CompleteCompletion() {
            }
        }
    }

    public static class CompleteRequest
    implements Request {
        PromptOrResourceReference ref;
        CompleteArgument argument;

        @Generated
        public PromptOrResourceReference getRef() {
            return this.ref;
        }

        @Generated
        public CompleteArgument getArgument() {
            return this.argument;
        }

        @Generated
        public void setRef(PromptOrResourceReference ref) {
            this.ref = ref;
        }

        @Generated
        public void setArgument(CompleteArgument argument) {
            this.argument = argument;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompleteRequest)) {
                return false;
            }
            CompleteRequest other = (CompleteRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PromptOrResourceReference this$ref = this.getRef();
            PromptOrResourceReference other$ref = other.getRef();
            if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
                return false;
            }
            CompleteArgument this$argument = this.getArgument();
            CompleteArgument other$argument = other.getArgument();
            return !(this$argument == null ? other$argument != null : !((Object)this$argument).equals(other$argument));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CompleteRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PromptOrResourceReference $ref = this.getRef();
            result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
            CompleteArgument $argument = this.getArgument();
            result = result * 59 + ($argument == null ? 43 : ((Object)$argument).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.CompleteRequest(ref=" + this.getRef() + ", argument=" + this.getArgument() + ")";
        }

        @Generated
        public CompleteRequest(PromptOrResourceReference ref, CompleteArgument argument) {
            this.ref = ref;
            this.argument = argument;
        }

        @Generated
        public CompleteRequest() {
        }

        public static class CompleteArgument {
            @JsonProperty(value="name")
            String name;
            @JsonProperty(value="value")
            String value;

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @JsonProperty(value="name")
            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @JsonProperty(value="value")
            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CompleteArgument)) {
                    return false;
                }
                CompleteArgument other = (CompleteArgument)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CompleteArgument;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.CompleteRequest.CompleteArgument(name=" + this.getName() + ", value=" + this.getValue() + ")";
            }

            @Generated
            public CompleteArgument(String name, String value) {
                this.name = name;
                this.value = value;
            }

            @Generated
            public CompleteArgument() {
            }
        }

        public static class ResourceReference
        implements PromptOrResourceReference {
            @JsonProperty(value="type")
            String type;
            @JsonProperty(value="uri")
            String uri;

            @Override
            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public String getUri() {
                return this.uri;
            }

            @JsonProperty(value="type")
            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @JsonProperty(value="uri")
            @Generated
            public void setUri(String uri) {
                this.uri = uri;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ResourceReference)) {
                    return false;
                }
                ResourceReference other = (ResourceReference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$uri = this.getUri();
                String other$uri = other.getUri();
                return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ResourceReference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $uri = this.getUri();
                result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.CompleteRequest.ResourceReference(type=" + this.getType() + ", uri=" + this.getUri() + ")";
            }

            @Generated
            public ResourceReference(String type, String uri) {
                this.type = type;
                this.uri = uri;
            }

            @Generated
            public ResourceReference() {
            }
        }

        public static class PromptReference
        implements PromptOrResourceReference {
            @JsonProperty(value="type")
            String type;
            @JsonProperty(value="name")
            String name;

            @Override
            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @JsonProperty(value="type")
            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @JsonProperty(value="name")
            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PromptReference)) {
                    return false;
                }
                PromptReference other = (PromptReference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PromptReference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.CompleteRequest.PromptReference(type=" + this.getType() + ", name=" + this.getName() + ")";
            }

            @Generated
            public PromptReference(String type, String name) {
                this.type = type;
                this.name = name;
            }

            @Generated
            public PromptReference() {
            }
        }

        public static interface PromptOrResourceReference {
            public String getType();
        }
    }

    public static enum LoggingLevel {
        DEBUG(0),
        INFO(1),
        NOTICE(2),
        WARNING(3),
        ERROR(4),
        CRITICAL(5),
        ALERT(6),
        EMERGENCY(7);

        private final int level;

        private LoggingLevel(int level) {
            this.level = level;
        }

        public int level() {
            return this.level;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LoggingMessageNotification {
        @JsonProperty(value="level")
        LoggingLevel level;
        @JsonProperty(value="logger")
        String logger;
        @JsonProperty(value="data")
        String data;

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public LoggingLevel getLevel() {
            return this.level;
        }

        @Generated
        public String getLogger() {
            return this.logger;
        }

        @Generated
        public String getData() {
            return this.data;
        }

        @JsonProperty(value="level")
        @Generated
        public void setLevel(LoggingLevel level) {
            this.level = level;
        }

        @JsonProperty(value="logger")
        @Generated
        public void setLogger(String logger) {
            this.logger = logger;
        }

        @JsonProperty(value="data")
        @Generated
        public void setData(String data) {
            this.data = data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoggingMessageNotification)) {
                return false;
            }
            LoggingMessageNotification other = (LoggingMessageNotification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LoggingLevel this$level = this.getLevel();
            LoggingLevel other$level = other.getLevel();
            if (this$level == null ? other$level != null : !((Object)((Object)this$level)).equals((Object)other$level)) {
                return false;
            }
            String this$logger = this.getLogger();
            String other$logger = other.getLogger();
            if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LoggingMessageNotification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LoggingLevel $level = this.getLevel();
            result = result * 59 + ($level == null ? 43 : ((Object)((Object)$level)).hashCode());
            String $logger = this.getLogger();
            result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.LoggingMessageNotification(level=" + (Object)((Object)this.getLevel()) + ", logger=" + this.getLogger() + ", data=" + this.getData() + ")";
        }

        @Generated
        public LoggingMessageNotification(LoggingLevel level, String logger, String data) {
            this.level = level;
            this.logger = logger;
            this.data = data;
        }

        @Generated
        public LoggingMessageNotification() {
        }

        public static class Builder {
            private LoggingLevel level = LoggingLevel.INFO;
            private String logger = "server";
            private String data;

            public Builder level(LoggingLevel level) {
                this.level = level;
                return this;
            }

            public Builder logger(String logger) {
                this.logger = logger;
                return this;
            }

            public Builder data(String data) {
                this.data = data;
                return this;
            }

            public LoggingMessageNotification build() {
                return new LoggingMessageNotification(this.level, this.logger, this.data);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ProgressNotification {
        @JsonProperty(value="progressToken")
        String progressToken;
        @JsonProperty(value="progress")
        double progress;
        @JsonProperty(value="total")
        Double total;

        @Generated
        public String getProgressToken() {
            return this.progressToken;
        }

        @Generated
        public double getProgress() {
            return this.progress;
        }

        @Generated
        public Double getTotal() {
            return this.total;
        }

        @JsonProperty(value="progressToken")
        @Generated
        public void setProgressToken(String progressToken) {
            this.progressToken = progressToken;
        }

        @JsonProperty(value="progress")
        @Generated
        public void setProgress(double progress) {
            this.progress = progress;
        }

        @JsonProperty(value="total")
        @Generated
        public void setTotal(Double total) {
            this.total = total;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProgressNotification)) {
                return false;
            }
            ProgressNotification other = (ProgressNotification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getProgress(), other.getProgress()) != 0) {
                return false;
            }
            Double this$total = this.getTotal();
            Double other$total = other.getTotal();
            if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
                return false;
            }
            String this$progressToken = this.getProgressToken();
            String other$progressToken = other.getProgressToken();
            return !(this$progressToken == null ? other$progressToken != null : !this$progressToken.equals(other$progressToken));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProgressNotification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $progress = Double.doubleToLongBits(this.getProgress());
            result = result * 59 + (int)($progress >>> 32 ^ $progress);
            Double $total = this.getTotal();
            result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
            String $progressToken = this.getProgressToken();
            result = result * 59 + ($progressToken == null ? 43 : $progressToken.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ProgressNotification(progressToken=" + this.getProgressToken() + ", progress=" + this.getProgress() + ", total=" + this.getTotal() + ")";
        }

        @Generated
        public ProgressNotification(String progressToken, double progress, Double total) {
            this.progressToken = progressToken;
            this.progress = progress;
            this.total = total;
        }

        @Generated
        public ProgressNotification() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PaginatedResult {
        @JsonProperty(value="nextCursor")
        String nextCursor;

        @Generated
        public String getNextCursor() {
            return this.nextCursor;
        }

        @JsonProperty(value="nextCursor")
        @Generated
        public void setNextCursor(String nextCursor) {
            this.nextCursor = nextCursor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaginatedResult)) {
                return false;
            }
            PaginatedResult other = (PaginatedResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$nextCursor = this.getNextCursor();
            String other$nextCursor = other.getNextCursor();
            return !(this$nextCursor == null ? other$nextCursor != null : !this$nextCursor.equals(other$nextCursor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaginatedResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $nextCursor = this.getNextCursor();
            result = result * 59 + ($nextCursor == null ? 43 : $nextCursor.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.PaginatedResult(nextCursor=" + this.getNextCursor() + ")";
        }

        @Generated
        public PaginatedResult(String nextCursor) {
            this.nextCursor = nextCursor;
        }

        @Generated
        public PaginatedResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PaginatedRequest {
        @JsonProperty(value="cursor")
        String cursor;

        @Generated
        public String getCursor() {
            return this.cursor;
        }

        @JsonProperty(value="cursor")
        @Generated
        public void setCursor(String cursor) {
            this.cursor = cursor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaginatedRequest)) {
                return false;
            }
            PaginatedRequest other = (PaginatedRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$cursor = this.getCursor();
            String other$cursor = other.getCursor();
            return !(this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaginatedRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $cursor = this.getCursor();
            result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.PaginatedRequest(cursor=" + this.getCursor() + ")";
        }

        @Generated
        public PaginatedRequest(String cursor) {
            this.cursor = cursor;
        }

        @Generated
        public PaginatedRequest() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateMessageResult {
        @JsonProperty(value="role")
        Role role;
        @JsonProperty(value="content")
        Content content;
        @JsonProperty(value="model")
        String model;
        @JsonProperty(value="stopReason")
        StopReason stopReason;

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Role getRole() {
            return this.role;
        }

        @Generated
        public Content getContent() {
            return this.content;
        }

        @Generated
        public String getModel() {
            return this.model;
        }

        @Generated
        public StopReason getStopReason() {
            return this.stopReason;
        }

        @JsonProperty(value="role")
        @Generated
        public void setRole(Role role) {
            this.role = role;
        }

        @JsonProperty(value="content")
        @Generated
        public void setContent(Content content) {
            this.content = content;
        }

        @JsonProperty(value="model")
        @Generated
        public void setModel(String model) {
            this.model = model;
        }

        @JsonProperty(value="stopReason")
        @Generated
        public void setStopReason(StopReason stopReason) {
            this.stopReason = stopReason;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateMessageResult)) {
                return false;
            }
            CreateMessageResult other = (CreateMessageResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Role this$role = this.getRole();
            Role other$role = other.getRole();
            if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
                return false;
            }
            Content this$content = this.getContent();
            Content other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            String this$model = this.getModel();
            String other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            StopReason this$stopReason = this.getStopReason();
            StopReason other$stopReason = other.getStopReason();
            return !(this$stopReason == null ? other$stopReason != null : !((Object)((Object)this$stopReason)).equals((Object)other$stopReason));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateMessageResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Role $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
            Content $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            String $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            StopReason $stopReason = this.getStopReason();
            result = result * 59 + ($stopReason == null ? 43 : ((Object)((Object)$stopReason)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.CreateMessageResult(role=" + (Object)((Object)this.getRole()) + ", content=" + this.getContent() + ", model=" + this.getModel() + ", stopReason=" + (Object)((Object)this.getStopReason()) + ")";
        }

        @Generated
        public CreateMessageResult(Role role, Content content, String model, StopReason stopReason) {
            this.role = role;
            this.content = content;
            this.model = model;
            this.stopReason = stopReason;
        }

        @Generated
        public CreateMessageResult() {
        }

        public static class Builder {
            private Role role = Role.ASSISTANT;
            private Content content;
            private String model;
            private StopReason stopReason = StopReason.END_TURN;

            public Builder role(Role role) {
                this.role = role;
                return this;
            }

            public Builder content(Content content) {
                this.content = content;
                return this;
            }

            public Builder model(String model) {
                this.model = model;
                return this;
            }

            public Builder stopReason(StopReason stopReason) {
                this.stopReason = stopReason;
                return this;
            }

            public Builder message(String message) {
                this.content = new TextContent(message);
                return this;
            }

            public CreateMessageResult build() {
                return new CreateMessageResult(this.role, this.content, this.model, this.stopReason);
            }
        }

        public static enum StopReason {
            END_TURN,
            STOP_SEQUENCE,
            MAX_TOKENS;

        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateMessageRequest
    implements Request {
        @JsonProperty(value="messages")
        List<SamplingMessage> messages;
        @JsonProperty(value="modelPreferences")
        ModelPreferences modelPreferences;
        @JsonProperty(value="systemPrompt")
        String systemPrompt;
        @JsonProperty(value="includeContext")
        ContextInclusionStrategy includeContext;
        @JsonProperty(value="temperature")
        Double temperature;
        @JsonProperty(value="maxTokens")
        int maxTokens;
        @JsonProperty(value="stopSequences")
        List<String> stopSequences;
        @JsonProperty(value="metadata")
        Map<String, Object> metadata;

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public List<SamplingMessage> getMessages() {
            return this.messages;
        }

        @Generated
        public ModelPreferences getModelPreferences() {
            return this.modelPreferences;
        }

        @Generated
        public String getSystemPrompt() {
            return this.systemPrompt;
        }

        @Generated
        public ContextInclusionStrategy getIncludeContext() {
            return this.includeContext;
        }

        @Generated
        public Double getTemperature() {
            return this.temperature;
        }

        @Generated
        public int getMaxTokens() {
            return this.maxTokens;
        }

        @Generated
        public List<String> getStopSequences() {
            return this.stopSequences;
        }

        @Generated
        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        @JsonProperty(value="messages")
        @Generated
        public void setMessages(List<SamplingMessage> messages) {
            this.messages = messages;
        }

        @JsonProperty(value="modelPreferences")
        @Generated
        public void setModelPreferences(ModelPreferences modelPreferences) {
            this.modelPreferences = modelPreferences;
        }

        @JsonProperty(value="systemPrompt")
        @Generated
        public void setSystemPrompt(String systemPrompt) {
            this.systemPrompt = systemPrompt;
        }

        @JsonProperty(value="includeContext")
        @Generated
        public void setIncludeContext(ContextInclusionStrategy includeContext) {
            this.includeContext = includeContext;
        }

        @JsonProperty(value="temperature")
        @Generated
        public void setTemperature(Double temperature) {
            this.temperature = temperature;
        }

        @JsonProperty(value="maxTokens")
        @Generated
        public void setMaxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
        }

        @JsonProperty(value="stopSequences")
        @Generated
        public void setStopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
        }

        @JsonProperty(value="metadata")
        @Generated
        public void setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateMessageRequest)) {
                return false;
            }
            CreateMessageRequest other = (CreateMessageRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxTokens() != other.getMaxTokens()) {
                return false;
            }
            Double this$temperature = this.getTemperature();
            Double other$temperature = other.getTemperature();
            if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
                return false;
            }
            List<SamplingMessage> this$messages = this.getMessages();
            List<SamplingMessage> other$messages = other.getMessages();
            if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
                return false;
            }
            ModelPreferences this$modelPreferences = this.getModelPreferences();
            ModelPreferences other$modelPreferences = other.getModelPreferences();
            if (this$modelPreferences == null ? other$modelPreferences != null : !((Object)this$modelPreferences).equals(other$modelPreferences)) {
                return false;
            }
            String this$systemPrompt = this.getSystemPrompt();
            String other$systemPrompt = other.getSystemPrompt();
            if (this$systemPrompt == null ? other$systemPrompt != null : !this$systemPrompt.equals(other$systemPrompt)) {
                return false;
            }
            ContextInclusionStrategy this$includeContext = this.getIncludeContext();
            ContextInclusionStrategy other$includeContext = other.getIncludeContext();
            if (this$includeContext == null ? other$includeContext != null : !((Object)((Object)this$includeContext)).equals((Object)other$includeContext)) {
                return false;
            }
            List<String> this$stopSequences = this.getStopSequences();
            List<String> other$stopSequences = other.getStopSequences();
            if (this$stopSequences == null ? other$stopSequences != null : !((Object)this$stopSequences).equals(other$stopSequences)) {
                return false;
            }
            Map<String, Object> this$metadata = this.getMetadata();
            Map<String, Object> other$metadata = other.getMetadata();
            return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateMessageRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxTokens();
            Double $temperature = this.getTemperature();
            result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
            List<SamplingMessage> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            ModelPreferences $modelPreferences = this.getModelPreferences();
            result = result * 59 + ($modelPreferences == null ? 43 : ((Object)$modelPreferences).hashCode());
            String $systemPrompt = this.getSystemPrompt();
            result = result * 59 + ($systemPrompt == null ? 43 : $systemPrompt.hashCode());
            ContextInclusionStrategy $includeContext = this.getIncludeContext();
            result = result * 59 + ($includeContext == null ? 43 : ((Object)((Object)$includeContext)).hashCode());
            List<String> $stopSequences = this.getStopSequences();
            result = result * 59 + ($stopSequences == null ? 43 : ((Object)$stopSequences).hashCode());
            Map<String, Object> $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.CreateMessageRequest(messages=" + this.getMessages() + ", modelPreferences=" + this.getModelPreferences() + ", systemPrompt=" + this.getSystemPrompt() + ", includeContext=" + (Object)((Object)this.getIncludeContext()) + ", temperature=" + this.getTemperature() + ", maxTokens=" + this.getMaxTokens() + ", stopSequences=" + this.getStopSequences() + ", metadata=" + this.getMetadata() + ")";
        }

        @Generated
        public CreateMessageRequest(List<SamplingMessage> messages, ModelPreferences modelPreferences, String systemPrompt, ContextInclusionStrategy includeContext, Double temperature, int maxTokens, List<String> stopSequences, Map<String, Object> metadata) {
            this.messages = messages;
            this.modelPreferences = modelPreferences;
            this.systemPrompt = systemPrompt;
            this.includeContext = includeContext;
            this.temperature = temperature;
            this.maxTokens = maxTokens;
            this.stopSequences = stopSequences;
            this.metadata = metadata;
        }

        @Generated
        public CreateMessageRequest() {
        }

        public static class Builder {
            private List<SamplingMessage> messages;
            private ModelPreferences modelPreferences;
            private String systemPrompt;
            private ContextInclusionStrategy includeContext;
            private Double temperature;
            private int maxTokens;
            private List<String> stopSequences;
            private Map<String, Object> metadata;

            public Builder messages(List<SamplingMessage> messages) {
                this.messages = messages;
                return this;
            }

            public Builder modelPreferences(ModelPreferences modelPreferences) {
                this.modelPreferences = modelPreferences;
                return this;
            }

            public Builder systemPrompt(String systemPrompt) {
                this.systemPrompt = systemPrompt;
                return this;
            }

            public Builder includeContext(ContextInclusionStrategy includeContext) {
                this.includeContext = includeContext;
                return this;
            }

            public Builder temperature(Double temperature) {
                this.temperature = temperature;
                return this;
            }

            public Builder maxTokens(int maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            public Builder stopSequences(List<String> stopSequences) {
                this.stopSequences = stopSequences;
                return this;
            }

            public Builder metadata(Map<String, Object> metadata) {
                this.metadata = metadata;
                return this;
            }

            public CreateMessageRequest build() {
                return new CreateMessageRequest(this.messages, this.modelPreferences, this.systemPrompt, this.includeContext, this.temperature, this.maxTokens, this.stopSequences, this.metadata);
            }
        }

        public static enum ContextInclusionStrategy {
            NONE,
            THIS_SERVER,
            ALL_SERVERS;

        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SamplingMessage {
        @JsonProperty(value="role")
        Role role;
        @JsonProperty(value="content")
        Content content;

        @Generated
        public Role getRole() {
            return this.role;
        }

        @Generated
        public Content getContent() {
            return this.content;
        }

        @JsonProperty(value="role")
        @Generated
        public void setRole(Role role) {
            this.role = role;
        }

        @JsonProperty(value="content")
        @Generated
        public void setContent(Content content) {
            this.content = content;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SamplingMessage)) {
                return false;
            }
            SamplingMessage other = (SamplingMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Role this$role = this.getRole();
            Role other$role = other.getRole();
            if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
                return false;
            }
            Content this$content = this.getContent();
            Content other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SamplingMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Role $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
            Content $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.SamplingMessage(role=" + (Object)((Object)this.getRole()) + ", content=" + this.getContent() + ")";
        }

        @Generated
        public SamplingMessage(Role role, Content content) {
            this.role = role;
            this.content = content;
        }

        @Generated
        public SamplingMessage() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModelHint {
        @JsonProperty(value="name")
        String name;

        public static ModelHint of(String name) {
            return new ModelHint(name);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModelHint)) {
                return false;
            }
            ModelHint other = (ModelHint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ModelHint;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ModelHint(name=" + this.getName() + ")";
        }

        @Generated
        public ModelHint(String name) {
            this.name = name;
        }

        @Generated
        public ModelHint() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModelPreferences {
        @JsonProperty(value="hints")
        List<ModelHint> hints;
        @JsonProperty(value="costPriority")
        Double costPriority;
        @JsonProperty(value="speedPriority")
        Double speedPriority;
        @JsonProperty(value="intelligencePriority")
        Double intelligencePriority;

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public List<ModelHint> getHints() {
            return this.hints;
        }

        @Generated
        public Double getCostPriority() {
            return this.costPriority;
        }

        @Generated
        public Double getSpeedPriority() {
            return this.speedPriority;
        }

        @Generated
        public Double getIntelligencePriority() {
            return this.intelligencePriority;
        }

        @JsonProperty(value="hints")
        @Generated
        public void setHints(List<ModelHint> hints) {
            this.hints = hints;
        }

        @JsonProperty(value="costPriority")
        @Generated
        public void setCostPriority(Double costPriority) {
            this.costPriority = costPriority;
        }

        @JsonProperty(value="speedPriority")
        @Generated
        public void setSpeedPriority(Double speedPriority) {
            this.speedPriority = speedPriority;
        }

        @JsonProperty(value="intelligencePriority")
        @Generated
        public void setIntelligencePriority(Double intelligencePriority) {
            this.intelligencePriority = intelligencePriority;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModelPreferences)) {
                return false;
            }
            ModelPreferences other = (ModelPreferences)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$costPriority = this.getCostPriority();
            Double other$costPriority = other.getCostPriority();
            if (this$costPriority == null ? other$costPriority != null : !((Object)this$costPriority).equals(other$costPriority)) {
                return false;
            }
            Double this$speedPriority = this.getSpeedPriority();
            Double other$speedPriority = other.getSpeedPriority();
            if (this$speedPriority == null ? other$speedPriority != null : !((Object)this$speedPriority).equals(other$speedPriority)) {
                return false;
            }
            Double this$intelligencePriority = this.getIntelligencePriority();
            Double other$intelligencePriority = other.getIntelligencePriority();
            if (this$intelligencePriority == null ? other$intelligencePriority != null : !((Object)this$intelligencePriority).equals(other$intelligencePriority)) {
                return false;
            }
            List<ModelHint> this$hints = this.getHints();
            List<ModelHint> other$hints = other.getHints();
            return !(this$hints == null ? other$hints != null : !((Object)this$hints).equals(other$hints));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ModelPreferences;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $costPriority = this.getCostPriority();
            result = result * 59 + ($costPriority == null ? 43 : ((Object)$costPriority).hashCode());
            Double $speedPriority = this.getSpeedPriority();
            result = result * 59 + ($speedPriority == null ? 43 : ((Object)$speedPriority).hashCode());
            Double $intelligencePriority = this.getIntelligencePriority();
            result = result * 59 + ($intelligencePriority == null ? 43 : ((Object)$intelligencePriority).hashCode());
            List<ModelHint> $hints = this.getHints();
            result = result * 59 + ($hints == null ? 43 : ((Object)$hints).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ModelPreferences(hints=" + this.getHints() + ", costPriority=" + this.getCostPriority() + ", speedPriority=" + this.getSpeedPriority() + ", intelligencePriority=" + this.getIntelligencePriority() + ")";
        }

        @Generated
        public ModelPreferences(List<ModelHint> hints, Double costPriority, Double speedPriority, Double intelligencePriority) {
            this.hints = hints;
            this.costPriority = costPriority;
            this.speedPriority = speedPriority;
            this.intelligencePriority = intelligencePriority;
        }

        @Generated
        public ModelPreferences() {
        }

        public static class Builder {
            private List<ModelHint> hints;
            private Double costPriority;
            private Double speedPriority;
            private Double intelligencePriority;

            public Builder hints(List<ModelHint> hints) {
                this.hints = hints;
                return this;
            }

            public Builder addHint(String name) {
                if (this.hints == null) {
                    this.hints = new ArrayList<ModelHint>();
                }
                this.hints.add(new ModelHint(name));
                return this;
            }

            public Builder costPriority(Double costPriority) {
                this.costPriority = costPriority;
                return this;
            }

            public Builder speedPriority(Double speedPriority) {
                this.speedPriority = speedPriority;
                return this;
            }

            public Builder intelligencePriority(Double intelligencePriority) {
                this.intelligencePriority = intelligencePriority;
                return this;
            }

            public ModelPreferences build() {
                return new ModelPreferences(this.hints, this.costPriority, this.speedPriority, this.intelligencePriority);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CallToolResult {
        @JsonProperty(value="content")
        List<Content> content;
        @JsonProperty(value="isError")
        Boolean isError;

        @Generated
        public List<Content> getContent() {
            return this.content;
        }

        @Generated
        public Boolean getIsError() {
            return this.isError;
        }

        @JsonProperty(value="content")
        @Generated
        public void setContent(List<Content> content) {
            this.content = content;
        }

        @JsonProperty(value="isError")
        @Generated
        public void setIsError(Boolean isError) {
            this.isError = isError;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallToolResult)) {
                return false;
            }
            CallToolResult other = (CallToolResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isError = this.getIsError();
            Boolean other$isError = other.getIsError();
            if (this$isError == null ? other$isError != null : !((Object)this$isError).equals(other$isError)) {
                return false;
            }
            List<Content> this$content = this.getContent();
            List<Content> other$content = other.getContent();
            return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CallToolResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isError = this.getIsError();
            result = result * 59 + ($isError == null ? 43 : ((Object)$isError).hashCode());
            List<Content> $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.CallToolResult(content=" + this.getContent() + ", isError=" + this.getIsError() + ")";
        }

        @Generated
        public CallToolResult(List<Content> content, Boolean isError) {
            this.content = content;
            this.isError = isError;
        }

        @Generated
        public CallToolResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CallToolRequest
    implements Request {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="arguments")
        Map<String, Object> arguments;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Map<String, Object> getArguments() {
            return this.arguments;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="arguments")
        @Generated
        public void setArguments(Map<String, Object> arguments) {
            this.arguments = arguments;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallToolRequest)) {
                return false;
            }
            CallToolRequest other = (CallToolRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Map<String, Object> this$arguments = this.getArguments();
            Map<String, Object> other$arguments = other.getArguments();
            return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CallToolRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Map<String, Object> $arguments = this.getArguments();
            result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.CallToolRequest(name=" + this.getName() + ", arguments=" + this.getArguments() + ")";
        }

        @Generated
        public CallToolRequest(String name, Map<String, Object> arguments) {
            this.name = name;
            this.arguments = arguments;
        }

        @Generated
        public CallToolRequest() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Tool {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="returnDirect")
        Boolean returnDirect;
        @JsonProperty(value="inputSchema")
        JsonSchema inputSchema;
        @JsonProperty(value="outputSchema")
        JsonSchema outputSchema;

        public Tool(String name, String description, Boolean returnDirect, String inSchemaJson, String outSchemaJson) {
            this(name, description, returnDirect, McpSchema.parseSchema(inSchemaJson), outSchemaJson == null || outSchemaJson.isEmpty() ? null : McpSchema.parseSchema(outSchemaJson));
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Boolean getReturnDirect() {
            return this.returnDirect;
        }

        @Generated
        public JsonSchema getInputSchema() {
            return this.inputSchema;
        }

        @Generated
        public JsonSchema getOutputSchema() {
            return this.outputSchema;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="returnDirect")
        @Generated
        public void setReturnDirect(Boolean returnDirect) {
            this.returnDirect = returnDirect;
        }

        @JsonProperty(value="inputSchema")
        @Generated
        public void setInputSchema(JsonSchema inputSchema) {
            this.inputSchema = inputSchema;
        }

        @JsonProperty(value="outputSchema")
        @Generated
        public void setOutputSchema(JsonSchema outputSchema) {
            this.outputSchema = outputSchema;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tool)) {
                return false;
            }
            Tool other = (Tool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$returnDirect = this.getReturnDirect();
            Boolean other$returnDirect = other.getReturnDirect();
            if (this$returnDirect == null ? other$returnDirect != null : !((Object)this$returnDirect).equals(other$returnDirect)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            JsonSchema this$inputSchema = this.getInputSchema();
            JsonSchema other$inputSchema = other.getInputSchema();
            if (this$inputSchema == null ? other$inputSchema != null : !((Object)this$inputSchema).equals(other$inputSchema)) {
                return false;
            }
            JsonSchema this$outputSchema = this.getOutputSchema();
            JsonSchema other$outputSchema = other.getOutputSchema();
            return !(this$outputSchema == null ? other$outputSchema != null : !((Object)this$outputSchema).equals(other$outputSchema));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Tool;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $returnDirect = this.getReturnDirect();
            result = result * 59 + ($returnDirect == null ? 43 : ((Object)$returnDirect).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            JsonSchema $inputSchema = this.getInputSchema();
            result = result * 59 + ($inputSchema == null ? 43 : ((Object)$inputSchema).hashCode());
            JsonSchema $outputSchema = this.getOutputSchema();
            result = result * 59 + ($outputSchema == null ? 43 : ((Object)$outputSchema).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.Tool(name=" + this.getName() + ", description=" + this.getDescription() + ", returnDirect=" + this.getReturnDirect() + ", inputSchema=" + this.getInputSchema() + ", outputSchema=" + this.getOutputSchema() + ")";
        }

        @Generated
        public Tool(String name, String description, Boolean returnDirect, JsonSchema inputSchema, JsonSchema outputSchema) {
            this.name = name;
            this.description = description;
            this.returnDirect = returnDirect;
            this.inputSchema = inputSchema;
            this.outputSchema = outputSchema;
        }

        @Generated
        public Tool() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonSchema {
        @JsonProperty(value="type")
        String type;
        @JsonProperty(value="properties")
        Map<String, Object> properties;
        @JsonProperty(value="required")
        List<String> required;
        @JsonProperty(value="additionalProperties")
        Boolean additionalProperties;

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Map<String, Object> getProperties() {
            return this.properties;
        }

        @Generated
        public List<String> getRequired() {
            return this.required;
        }

        @Generated
        public Boolean getAdditionalProperties() {
            return this.additionalProperties;
        }

        @JsonProperty(value="type")
        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="properties")
        @Generated
        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }

        @JsonProperty(value="required")
        @Generated
        public void setRequired(List<String> required) {
            this.required = required;
        }

        @JsonProperty(value="additionalProperties")
        @Generated
        public void setAdditionalProperties(Boolean additionalProperties) {
            this.additionalProperties = additionalProperties;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsonSchema)) {
                return false;
            }
            JsonSchema other = (JsonSchema)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$additionalProperties = this.getAdditionalProperties();
            Boolean other$additionalProperties = other.getAdditionalProperties();
            if (this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Map<String, Object> this$properties = this.getProperties();
            Map<String, Object> other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
                return false;
            }
            List<String> this$required = this.getRequired();
            List<String> other$required = other.getRequired();
            return !(this$required == null ? other$required != null : !((Object)this$required).equals(other$required));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JsonSchema;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $additionalProperties = this.getAdditionalProperties();
            result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Map<String, Object> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            List<String> $required = this.getRequired();
            result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.JsonSchema(type=" + this.getType() + ", properties=" + this.getProperties() + ", required=" + this.getRequired() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
        }

        @Generated
        public JsonSchema(String type, Map<String, Object> properties, List<String> required, Boolean additionalProperties) {
            this.type = type;
            this.properties = properties;
            this.required = required;
            this.additionalProperties = additionalProperties;
        }

        @Generated
        public JsonSchema() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListToolsResult {
        @JsonProperty(value="tools")
        List<Tool> tools;
        @JsonProperty(value="nextCursor")
        String nextCursor;

        @Generated
        public List<Tool> getTools() {
            return this.tools;
        }

        @Generated
        public String getNextCursor() {
            return this.nextCursor;
        }

        @JsonProperty(value="tools")
        @Generated
        public void setTools(List<Tool> tools) {
            this.tools = tools;
        }

        @JsonProperty(value="nextCursor")
        @Generated
        public void setNextCursor(String nextCursor) {
            this.nextCursor = nextCursor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListToolsResult)) {
                return false;
            }
            ListToolsResult other = (ListToolsResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Tool> this$tools = this.getTools();
            List<Tool> other$tools = other.getTools();
            if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
                return false;
            }
            String this$nextCursor = this.getNextCursor();
            String other$nextCursor = other.getNextCursor();
            return !(this$nextCursor == null ? other$nextCursor != null : !this$nextCursor.equals(other$nextCursor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ListToolsResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Tool> $tools = this.getTools();
            result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
            String $nextCursor = this.getNextCursor();
            result = result * 59 + ($nextCursor == null ? 43 : $nextCursor.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ListToolsResult(tools=" + this.getTools() + ", nextCursor=" + this.getNextCursor() + ")";
        }

        @Generated
        public ListToolsResult(List<Tool> tools, String nextCursor) {
            this.tools = tools;
            this.nextCursor = nextCursor;
        }

        @Generated
        public ListToolsResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetPromptResult {
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="messages")
        List<PromptMessage> messages;

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public List<PromptMessage> getMessages() {
            return this.messages;
        }

        @JsonProperty(value="description")
        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="messages")
        @Generated
        public void setMessages(List<PromptMessage> messages) {
            this.messages = messages;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetPromptResult)) {
                return false;
            }
            GetPromptResult other = (GetPromptResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            List<PromptMessage> this$messages = this.getMessages();
            List<PromptMessage> other$messages = other.getMessages();
            return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GetPromptResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            List<PromptMessage> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.GetPromptResult(description=" + this.getDescription() + ", messages=" + this.getMessages() + ")";
        }

        @Generated
        public GetPromptResult(String description, List<PromptMessage> messages) {
            this.description = description;
            this.messages = messages;
        }

        @Generated
        public GetPromptResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetPromptRequest
    implements Request {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="arguments")
        Map<String, Object> arguments;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Map<String, Object> getArguments() {
            return this.arguments;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="arguments")
        @Generated
        public void setArguments(Map<String, Object> arguments) {
            this.arguments = arguments;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetPromptRequest)) {
                return false;
            }
            GetPromptRequest other = (GetPromptRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Map<String, Object> this$arguments = this.getArguments();
            Map<String, Object> other$arguments = other.getArguments();
            return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GetPromptRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Map<String, Object> $arguments = this.getArguments();
            result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.GetPromptRequest(name=" + this.getName() + ", arguments=" + this.getArguments() + ")";
        }

        @Generated
        public GetPromptRequest(String name, Map<String, Object> arguments) {
            this.name = name;
            this.arguments = arguments;
        }

        @Generated
        public GetPromptRequest() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListPromptsResult {
        @JsonProperty(value="prompts")
        List<Prompt> prompts;
        @JsonProperty(value="nextCursor")
        String nextCursor;

        @Generated
        public List<Prompt> getPrompts() {
            return this.prompts;
        }

        @Generated
        public String getNextCursor() {
            return this.nextCursor;
        }

        @JsonProperty(value="prompts")
        @Generated
        public void setPrompts(List<Prompt> prompts) {
            this.prompts = prompts;
        }

        @JsonProperty(value="nextCursor")
        @Generated
        public void setNextCursor(String nextCursor) {
            this.nextCursor = nextCursor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListPromptsResult)) {
                return false;
            }
            ListPromptsResult other = (ListPromptsResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Prompt> this$prompts = this.getPrompts();
            List<Prompt> other$prompts = other.getPrompts();
            if (this$prompts == null ? other$prompts != null : !((Object)this$prompts).equals(other$prompts)) {
                return false;
            }
            String this$nextCursor = this.getNextCursor();
            String other$nextCursor = other.getNextCursor();
            return !(this$nextCursor == null ? other$nextCursor != null : !this$nextCursor.equals(other$nextCursor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ListPromptsResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Prompt> $prompts = this.getPrompts();
            result = result * 59 + ($prompts == null ? 43 : ((Object)$prompts).hashCode());
            String $nextCursor = this.getNextCursor();
            result = result * 59 + ($nextCursor == null ? 43 : $nextCursor.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ListPromptsResult(prompts=" + this.getPrompts() + ", nextCursor=" + this.getNextCursor() + ")";
        }

        @Generated
        public ListPromptsResult(List<Prompt> prompts, String nextCursor) {
            this.prompts = prompts;
            this.nextCursor = nextCursor;
        }

        @Generated
        public ListPromptsResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PromptMessage {
        @JsonProperty(value="role")
        Role role;
        @JsonProperty(value="content")
        Content content;

        @Generated
        public Role getRole() {
            return this.role;
        }

        @Generated
        public Content getContent() {
            return this.content;
        }

        @JsonProperty(value="role")
        @Generated
        public void setRole(Role role) {
            this.role = role;
        }

        @JsonProperty(value="content")
        @Generated
        public void setContent(Content content) {
            this.content = content;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PromptMessage)) {
                return false;
            }
            PromptMessage other = (PromptMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Role this$role = this.getRole();
            Role other$role = other.getRole();
            if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
                return false;
            }
            Content this$content = this.getContent();
            Content other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PromptMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Role $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
            Content $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.PromptMessage(role=" + (Object)((Object)this.getRole()) + ", content=" + this.getContent() + ")";
        }

        @Generated
        public PromptMessage(Role role, Content content) {
            this.role = role;
            this.content = content;
        }

        @Generated
        public PromptMessage() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PromptArgument {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="required")
        Boolean required;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Boolean getRequired() {
            return this.required;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="required")
        @Generated
        public void setRequired(Boolean required) {
            this.required = required;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PromptArgument)) {
                return false;
            }
            PromptArgument other = (PromptArgument)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$required = this.getRequired();
            Boolean other$required = other.getRequired();
            if (this$required == null ? other$required != null : !((Object)this$required).equals(other$required)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PromptArgument;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $required = this.getRequired();
            result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.PromptArgument(name=" + this.getName() + ", description=" + this.getDescription() + ", required=" + this.getRequired() + ")";
        }

        @Generated
        public PromptArgument(String name, String description, Boolean required) {
            this.name = name;
            this.description = description;
            this.required = required;
        }

        @Generated
        public PromptArgument() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Prompt {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="arguments")
        List<PromptArgument> arguments;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public List<PromptArgument> getArguments() {
            return this.arguments;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="arguments")
        @Generated
        public void setArguments(List<PromptArgument> arguments) {
            this.arguments = arguments;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prompt)) {
                return false;
            }
            Prompt other = (Prompt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            List<PromptArgument> this$arguments = this.getArguments();
            List<PromptArgument> other$arguments = other.getArguments();
            return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Prompt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            List<PromptArgument> $arguments = this.getArguments();
            result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.Prompt(name=" + this.getName() + ", description=" + this.getDescription() + ", arguments=" + this.getArguments() + ")";
        }

        @Generated
        public Prompt(String name, String description, List<PromptArgument> arguments) {
            this.name = name;
            this.description = description;
            this.arguments = arguments;
        }

        @Generated
        public Prompt() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class BlobResourceContents
    implements ResourceContents {
        @JsonProperty(value="uri")
        String uri;
        @JsonProperty(value="mimeType")
        String mimeType;
        @JsonProperty(value="blob")
        String blob;

        @Override
        @Generated
        public String getUri() {
            return this.uri;
        }

        @Override
        @Generated
        public String getMimeType() {
            return this.mimeType;
        }

        @Generated
        public String getBlob() {
            return this.blob;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="mimeType")
        @Generated
        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @JsonProperty(value="blob")
        @Generated
        public void setBlob(String blob) {
            this.blob = blob;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlobResourceContents)) {
                return false;
            }
            BlobResourceContents other = (BlobResourceContents)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$mimeType = this.getMimeType();
            String other$mimeType = other.getMimeType();
            if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
                return false;
            }
            String this$blob = this.getBlob();
            String other$blob = other.getBlob();
            return !(this$blob == null ? other$blob != null : !this$blob.equals(other$blob));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BlobResourceContents;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $mimeType = this.getMimeType();
            result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
            String $blob = this.getBlob();
            result = result * 59 + ($blob == null ? 43 : $blob.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.BlobResourceContents(uri=" + this.getUri() + ", mimeType=" + this.getMimeType() + ", blob=" + this.getBlob() + ")";
        }

        @Generated
        public BlobResourceContents(String uri, String mimeType, String blob) {
            this.uri = uri;
            this.mimeType = mimeType;
            this.blob = blob;
        }

        @Generated
        public BlobResourceContents() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TextResourceContents
    implements ResourceContents {
        @JsonProperty(value="uri")
        String uri;
        @JsonProperty(value="mimeType")
        String mimeType;
        @JsonProperty(value="text")
        String text;

        @Override
        @Generated
        public String getUri() {
            return this.uri;
        }

        @Override
        @Generated
        public String getMimeType() {
            return this.mimeType;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="mimeType")
        @Generated
        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @JsonProperty(value="text")
        @Generated
        public void setText(String text) {
            this.text = text;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TextResourceContents)) {
                return false;
            }
            TextResourceContents other = (TextResourceContents)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$mimeType = this.getMimeType();
            String other$mimeType = other.getMimeType();
            if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TextResourceContents;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $mimeType = this.getMimeType();
            result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.TextResourceContents(uri=" + this.getUri() + ", mimeType=" + this.getMimeType() + ", text=" + this.getText() + ")";
        }

        @Generated
        public TextResourceContents(String uri, String mimeType, String text) {
            this.uri = uri;
            this.mimeType = mimeType;
            this.text = text;
        }

        @Generated
        public TextResourceContents() {
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.DEDUCTION, include=JsonTypeInfo.As.PROPERTY)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextResourceContents.class, name="text"), @JsonSubTypes.Type(value=BlobResourceContents.class, name="blob")})
    public static interface ResourceContents {
        public String getUri();

        public String getMimeType();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UnsubscribeRequest {
        @JsonProperty(value="uri")
        String uri;

        @Generated
        public String getUri() {
            return this.uri;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnsubscribeRequest)) {
                return false;
            }
            UnsubscribeRequest other = (UnsubscribeRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UnsubscribeRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.UnsubscribeRequest(uri=" + this.getUri() + ")";
        }

        @Generated
        public UnsubscribeRequest(String uri) {
            this.uri = uri;
        }

        @Generated
        public UnsubscribeRequest() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SubscribeRequest {
        @JsonProperty(value="uri")
        String uri;

        @Generated
        public String getUri() {
            return this.uri;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubscribeRequest)) {
                return false;
            }
            SubscribeRequest other = (SubscribeRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SubscribeRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.SubscribeRequest(uri=" + this.getUri() + ")";
        }

        @Generated
        public SubscribeRequest(String uri) {
            this.uri = uri;
        }

        @Generated
        public SubscribeRequest() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ReadResourceResult {
        @JsonProperty(value="contents")
        List<ResourceContents> contents;

        @Generated
        public List<ResourceContents> getContents() {
            return this.contents;
        }

        @JsonProperty(value="contents")
        @Generated
        public void setContents(List<ResourceContents> contents) {
            this.contents = contents;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadResourceResult)) {
                return false;
            }
            ReadResourceResult other = (ReadResourceResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<ResourceContents> this$contents = this.getContents();
            List<ResourceContents> other$contents = other.getContents();
            return !(this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReadResourceResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ResourceContents> $contents = this.getContents();
            result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ReadResourceResult(contents=" + this.getContents() + ")";
        }

        @Generated
        public ReadResourceResult(List<ResourceContents> contents) {
            this.contents = contents;
        }

        @Generated
        public ReadResourceResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ReadResourceRequest {
        @JsonProperty(value="uri")
        String uri;

        @Generated
        public String getUri() {
            return this.uri;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadResourceRequest)) {
                return false;
            }
            ReadResourceRequest other = (ReadResourceRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReadResourceRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ReadResourceRequest(uri=" + this.getUri() + ")";
        }

        @Generated
        public ReadResourceRequest(String uri) {
            this.uri = uri;
        }

        @Generated
        public ReadResourceRequest() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListResourceTemplatesResult {
        @JsonProperty(value="resourceTemplates")
        List<ResourceTemplate> resourceTemplates;
        @JsonProperty(value="nextCursor")
        String nextCursor;

        @Generated
        public List<ResourceTemplate> getResourceTemplates() {
            return this.resourceTemplates;
        }

        @Generated
        public String getNextCursor() {
            return this.nextCursor;
        }

        @JsonProperty(value="resourceTemplates")
        @Generated
        public void setResourceTemplates(List<ResourceTemplate> resourceTemplates) {
            this.resourceTemplates = resourceTemplates;
        }

        @JsonProperty(value="nextCursor")
        @Generated
        public void setNextCursor(String nextCursor) {
            this.nextCursor = nextCursor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListResourceTemplatesResult)) {
                return false;
            }
            ListResourceTemplatesResult other = (ListResourceTemplatesResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<ResourceTemplate> this$resourceTemplates = this.getResourceTemplates();
            List<ResourceTemplate> other$resourceTemplates = other.getResourceTemplates();
            if (this$resourceTemplates == null ? other$resourceTemplates != null : !((Object)this$resourceTemplates).equals(other$resourceTemplates)) {
                return false;
            }
            String this$nextCursor = this.getNextCursor();
            String other$nextCursor = other.getNextCursor();
            return !(this$nextCursor == null ? other$nextCursor != null : !this$nextCursor.equals(other$nextCursor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ListResourceTemplatesResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ResourceTemplate> $resourceTemplates = this.getResourceTemplates();
            result = result * 59 + ($resourceTemplates == null ? 43 : ((Object)$resourceTemplates).hashCode());
            String $nextCursor = this.getNextCursor();
            result = result * 59 + ($nextCursor == null ? 43 : $nextCursor.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ListResourceTemplatesResult(resourceTemplates=" + this.getResourceTemplates() + ", nextCursor=" + this.getNextCursor() + ")";
        }

        @Generated
        public ListResourceTemplatesResult(List<ResourceTemplate> resourceTemplates, String nextCursor) {
            this.resourceTemplates = resourceTemplates;
            this.nextCursor = nextCursor;
        }

        @Generated
        public ListResourceTemplatesResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListResourcesResult {
        @JsonProperty(value="resources")
        List<Resource> resources;
        @JsonProperty(value="nextCursor")
        String nextCursor;

        @Generated
        public List<Resource> getResources() {
            return this.resources;
        }

        @Generated
        public String getNextCursor() {
            return this.nextCursor;
        }

        @JsonProperty(value="resources")
        @Generated
        public void setResources(List<Resource> resources) {
            this.resources = resources;
        }

        @JsonProperty(value="nextCursor")
        @Generated
        public void setNextCursor(String nextCursor) {
            this.nextCursor = nextCursor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListResourcesResult)) {
                return false;
            }
            ListResourcesResult other = (ListResourcesResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Resource> this$resources = this.getResources();
            List<Resource> other$resources = other.getResources();
            if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
                return false;
            }
            String this$nextCursor = this.getNextCursor();
            String other$nextCursor = other.getNextCursor();
            return !(this$nextCursor == null ? other$nextCursor != null : !this$nextCursor.equals(other$nextCursor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ListResourcesResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Resource> $resources = this.getResources();
            result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
            String $nextCursor = this.getNextCursor();
            result = result * 59 + ($nextCursor == null ? 43 : $nextCursor.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ListResourcesResult(resources=" + this.getResources() + ", nextCursor=" + this.getNextCursor() + ")";
        }

        @Generated
        public ListResourcesResult(List<Resource> resources, String nextCursor) {
            this.resources = resources;
            this.nextCursor = nextCursor;
        }

        @Generated
        public ListResourcesResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResourceTemplate
    implements Annotated {
        @JsonProperty(value="uriTemplate")
        String uriTemplate;
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="mimeType")
        String mimeType;
        @JsonProperty(value="annotations")
        Annotations annotations;

        @Generated
        public String getUriTemplate() {
            return this.uriTemplate;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        @Generated
        public Annotations getAnnotations() {
            return this.annotations;
        }

        @JsonProperty(value="uriTemplate")
        @Generated
        public void setUriTemplate(String uriTemplate) {
            this.uriTemplate = uriTemplate;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="mimeType")
        @Generated
        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @JsonProperty(value="annotations")
        @Generated
        public void setAnnotations(Annotations annotations) {
            this.annotations = annotations;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceTemplate)) {
                return false;
            }
            ResourceTemplate other = (ResourceTemplate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uriTemplate = this.getUriTemplate();
            String other$uriTemplate = other.getUriTemplate();
            if (this$uriTemplate == null ? other$uriTemplate != null : !this$uriTemplate.equals(other$uriTemplate)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$mimeType = this.getMimeType();
            String other$mimeType = other.getMimeType();
            if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
                return false;
            }
            Annotations this$annotations = this.getAnnotations();
            Annotations other$annotations = other.getAnnotations();
            return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResourceTemplate;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uriTemplate = this.getUriTemplate();
            result = result * 59 + ($uriTemplate == null ? 43 : $uriTemplate.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $mimeType = this.getMimeType();
            result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
            Annotations $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ResourceTemplate(uriTemplate=" + this.getUriTemplate() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", mimeType=" + this.getMimeType() + ", annotations=" + this.getAnnotations() + ")";
        }

        @Generated
        public ResourceTemplate(String uriTemplate, String name, String description, String mimeType, Annotations annotations) {
            this.uriTemplate = uriTemplate;
            this.name = name;
            this.description = description;
            this.mimeType = mimeType;
            this.annotations = annotations;
        }

        @Generated
        public ResourceTemplate() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Resource
    implements Annotated {
        @JsonProperty(value="uri")
        String uri;
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="mimeType")
        String mimeType;
        @JsonProperty(value="annotations")
        Annotations annotations;

        @Generated
        public String getUri() {
            return this.uri;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        @Generated
        public Annotations getAnnotations() {
            return this.annotations;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="mimeType")
        @Generated
        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @JsonProperty(value="annotations")
        @Generated
        public void setAnnotations(Annotations annotations) {
            this.annotations = annotations;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$mimeType = this.getMimeType();
            String other$mimeType = other.getMimeType();
            if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
                return false;
            }
            Annotations this$annotations = this.getAnnotations();
            Annotations other$annotations = other.getAnnotations();
            return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Resource;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $mimeType = this.getMimeType();
            result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
            Annotations $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.Resource(uri=" + this.getUri() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", mimeType=" + this.getMimeType() + ", annotations=" + this.getAnnotations() + ")";
        }

        @Generated
        public Resource(String uri, String name, String description, String mimeType, Annotations annotations) {
            this.uri = uri;
            this.name = name;
            this.description = description;
            this.mimeType = mimeType;
            this.annotations = annotations;
        }

        @Generated
        public Resource() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Annotations {
        @JsonProperty(value="audience")
        List<Role> audience;
        @JsonProperty(value="priority")
        Double priority;

        @Generated
        public List<Role> getAudience() {
            return this.audience;
        }

        @Generated
        public Double getPriority() {
            return this.priority;
        }

        @JsonProperty(value="audience")
        @Generated
        public void setAudience(List<Role> audience) {
            this.audience = audience;
        }

        @JsonProperty(value="priority")
        @Generated
        public void setPriority(Double priority) {
            this.priority = priority;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Annotations)) {
                return false;
            }
            Annotations other = (Annotations)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$priority = this.getPriority();
            Double other$priority = other.getPriority();
            if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
                return false;
            }
            List<Role> this$audience = this.getAudience();
            List<Role> other$audience = other.getAudience();
            return !(this$audience == null ? other$audience != null : !((Object)this$audience).equals(other$audience));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Annotations;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $priority = this.getPriority();
            result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
            List<Role> $audience = this.getAudience();
            result = result * 59 + ($audience == null ? 43 : ((Object)$audience).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.Annotations(audience=" + this.getAudience() + ", priority=" + this.getPriority() + ")";
        }

        @Generated
        public Annotations(List<Role> audience, Double priority) {
            this.audience = audience;
            this.priority = priority;
        }

        @Generated
        public Annotations() {
        }
    }

    public static interface Annotated {
        public Annotations getAnnotations();
    }

    public static enum Role {
        USER,
        ASSISTANT;

    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Implementation {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="version")
        String version;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="version")
        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Implementation)) {
                return false;
            }
            Implementation other = (Implementation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Implementation;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.Implementation(name=" + this.getName() + ", version=" + this.getVersion() + ")";
        }

        @Generated
        public Implementation(String name, String version) {
            this.name = name;
            this.version = version;
        }

        @Generated
        public Implementation() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ServerCapabilities {
        @JsonProperty(value="experimental")
        Map<String, Object> experimental;
        @JsonProperty(value="logging")
        LoggingCapabilities logging;
        @JsonProperty(value="prompts")
        PromptCapabilities prompts;
        @JsonProperty(value="resources")
        ResourceCapabilities resources;
        @JsonProperty(value="tools")
        ToolCapabilities tools;

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExperimental() {
            return this.experimental;
        }

        @Generated
        public LoggingCapabilities getLogging() {
            return this.logging;
        }

        @Generated
        public PromptCapabilities getPrompts() {
            return this.prompts;
        }

        @Generated
        public ResourceCapabilities getResources() {
            return this.resources;
        }

        @Generated
        public ToolCapabilities getTools() {
            return this.tools;
        }

        @JsonProperty(value="experimental")
        @Generated
        public void setExperimental(Map<String, Object> experimental) {
            this.experimental = experimental;
        }

        @JsonProperty(value="logging")
        @Generated
        public void setLogging(LoggingCapabilities logging) {
            this.logging = logging;
        }

        @JsonProperty(value="prompts")
        @Generated
        public void setPrompts(PromptCapabilities prompts) {
            this.prompts = prompts;
        }

        @JsonProperty(value="resources")
        @Generated
        public void setResources(ResourceCapabilities resources) {
            this.resources = resources;
        }

        @JsonProperty(value="tools")
        @Generated
        public void setTools(ToolCapabilities tools) {
            this.tools = tools;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerCapabilities)) {
                return false;
            }
            ServerCapabilities other = (ServerCapabilities)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$experimental = this.getExperimental();
            Map<String, Object> other$experimental = other.getExperimental();
            if (this$experimental == null ? other$experimental != null : !((Object)this$experimental).equals(other$experimental)) {
                return false;
            }
            LoggingCapabilities this$logging = this.getLogging();
            LoggingCapabilities other$logging = other.getLogging();
            if (this$logging == null ? other$logging != null : !this$logging.equals(other$logging)) {
                return false;
            }
            PromptCapabilities this$prompts = this.getPrompts();
            PromptCapabilities other$prompts = other.getPrompts();
            if (this$prompts == null ? other$prompts != null : !((Object)this$prompts).equals(other$prompts)) {
                return false;
            }
            ResourceCapabilities this$resources = this.getResources();
            ResourceCapabilities other$resources = other.getResources();
            if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
                return false;
            }
            ToolCapabilities this$tools = this.getTools();
            ToolCapabilities other$tools = other.getTools();
            return !(this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ServerCapabilities;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $experimental = this.getExperimental();
            result = result * 59 + ($experimental == null ? 43 : ((Object)$experimental).hashCode());
            LoggingCapabilities $logging = this.getLogging();
            result = result * 59 + ($logging == null ? 43 : $logging.hashCode());
            PromptCapabilities $prompts = this.getPrompts();
            result = result * 59 + ($prompts == null ? 43 : ((Object)$prompts).hashCode());
            ResourceCapabilities $resources = this.getResources();
            result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
            ToolCapabilities $tools = this.getTools();
            result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ServerCapabilities(experimental=" + this.getExperimental() + ", logging=" + this.getLogging() + ", prompts=" + this.getPrompts() + ", resources=" + this.getResources() + ", tools=" + this.getTools() + ")";
        }

        @Generated
        public ServerCapabilities(Map<String, Object> experimental, LoggingCapabilities logging, PromptCapabilities prompts, ResourceCapabilities resources, ToolCapabilities tools) {
            this.experimental = experimental;
            this.logging = logging;
            this.prompts = prompts;
            this.resources = resources;
            this.tools = tools;
        }

        @Generated
        public ServerCapabilities() {
        }

        public static class Builder {
            private Map<String, Object> experimental;
            private LoggingCapabilities logging = new LoggingCapabilities();
            private PromptCapabilities prompts;
            private ResourceCapabilities resources;
            private ToolCapabilities tools;

            public Builder experimental(Map<String, Object> experimental) {
                this.experimental = experimental;
                return this;
            }

            public Builder logging() {
                this.logging = new LoggingCapabilities();
                return this;
            }

            public Builder prompts(Boolean listChanged) {
                this.prompts = new PromptCapabilities(listChanged);
                return this;
            }

            public Builder resources(Boolean subscribe, Boolean listChanged) {
                this.resources = new ResourceCapabilities(subscribe, listChanged);
                return this;
            }

            public Builder tools(Boolean listChanged) {
                this.tools = new ToolCapabilities(listChanged);
                return this;
            }

            public ServerCapabilities build() {
                return new ServerCapabilities(this.experimental, this.logging, this.prompts, this.resources, this.tools);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class ToolCapabilities {
            @JsonProperty(value="listChanged")
            Boolean listChanged;

            @Generated
            public Boolean getListChanged() {
                return this.listChanged;
            }

            @JsonProperty(value="listChanged")
            @Generated
            public void setListChanged(Boolean listChanged) {
                this.listChanged = listChanged;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ToolCapabilities)) {
                    return false;
                }
                ToolCapabilities other = (ToolCapabilities)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$listChanged = this.getListChanged();
                Boolean other$listChanged = other.getListChanged();
                return !(this$listChanged == null ? other$listChanged != null : !((Object)this$listChanged).equals(other$listChanged));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ToolCapabilities;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $listChanged = this.getListChanged();
                result = result * 59 + ($listChanged == null ? 43 : ((Object)$listChanged).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.ServerCapabilities.ToolCapabilities(listChanged=" + this.getListChanged() + ")";
            }

            @Generated
            public ToolCapabilities(Boolean listChanged) {
                this.listChanged = listChanged;
            }

            @Generated
            public ToolCapabilities() {
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class ResourceCapabilities {
            @JsonProperty(value="subscribe")
            Boolean subscribe;
            @JsonProperty(value="listChanged")
            Boolean listChanged;

            @Generated
            public Boolean getSubscribe() {
                return this.subscribe;
            }

            @Generated
            public Boolean getListChanged() {
                return this.listChanged;
            }

            @JsonProperty(value="subscribe")
            @Generated
            public void setSubscribe(Boolean subscribe) {
                this.subscribe = subscribe;
            }

            @JsonProperty(value="listChanged")
            @Generated
            public void setListChanged(Boolean listChanged) {
                this.listChanged = listChanged;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ResourceCapabilities)) {
                    return false;
                }
                ResourceCapabilities other = (ResourceCapabilities)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$subscribe = this.getSubscribe();
                Boolean other$subscribe = other.getSubscribe();
                if (this$subscribe == null ? other$subscribe != null : !((Object)this$subscribe).equals(other$subscribe)) {
                    return false;
                }
                Boolean this$listChanged = this.getListChanged();
                Boolean other$listChanged = other.getListChanged();
                return !(this$listChanged == null ? other$listChanged != null : !((Object)this$listChanged).equals(other$listChanged));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ResourceCapabilities;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $subscribe = this.getSubscribe();
                result = result * 59 + ($subscribe == null ? 43 : ((Object)$subscribe).hashCode());
                Boolean $listChanged = this.getListChanged();
                result = result * 59 + ($listChanged == null ? 43 : ((Object)$listChanged).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.ServerCapabilities.ResourceCapabilities(subscribe=" + this.getSubscribe() + ", listChanged=" + this.getListChanged() + ")";
            }

            @Generated
            public ResourceCapabilities(Boolean subscribe, Boolean listChanged) {
                this.subscribe = subscribe;
                this.listChanged = listChanged;
            }

            @Generated
            public ResourceCapabilities() {
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class PromptCapabilities {
            @JsonProperty(value="listChanged")
            Boolean listChanged;

            @Generated
            public Boolean getListChanged() {
                return this.listChanged;
            }

            @JsonProperty(value="listChanged")
            @Generated
            public void setListChanged(Boolean listChanged) {
                this.listChanged = listChanged;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PromptCapabilities)) {
                    return false;
                }
                PromptCapabilities other = (PromptCapabilities)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$listChanged = this.getListChanged();
                Boolean other$listChanged = other.getListChanged();
                return !(this$listChanged == null ? other$listChanged != null : !((Object)this$listChanged).equals(other$listChanged));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PromptCapabilities;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $listChanged = this.getListChanged();
                result = result * 59 + ($listChanged == null ? 43 : ((Object)$listChanged).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.ServerCapabilities.PromptCapabilities(listChanged=" + this.getListChanged() + ")";
            }

            @Generated
            public PromptCapabilities(Boolean listChanged) {
                this.listChanged = listChanged;
            }

            @Generated
            public PromptCapabilities() {
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class LoggingCapabilities {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ClientCapabilities {
        @JsonProperty(value="experimental")
        Map<String, Object> experimental;
        @JsonProperty(value="roots")
        RootCapabilities roots;
        @JsonProperty(value="sampling")
        Sampling sampling;

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExperimental() {
            return this.experimental;
        }

        @Generated
        public RootCapabilities getRoots() {
            return this.roots;
        }

        @Generated
        public Sampling getSampling() {
            return this.sampling;
        }

        @JsonProperty(value="experimental")
        @Generated
        public void setExperimental(Map<String, Object> experimental) {
            this.experimental = experimental;
        }

        @JsonProperty(value="roots")
        @Generated
        public void setRoots(RootCapabilities roots) {
            this.roots = roots;
        }

        @JsonProperty(value="sampling")
        @Generated
        public void setSampling(Sampling sampling) {
            this.sampling = sampling;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientCapabilities)) {
                return false;
            }
            ClientCapabilities other = (ClientCapabilities)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$experimental = this.getExperimental();
            Map<String, Object> other$experimental = other.getExperimental();
            if (this$experimental == null ? other$experimental != null : !((Object)this$experimental).equals(other$experimental)) {
                return false;
            }
            RootCapabilities this$roots = this.getRoots();
            RootCapabilities other$roots = other.getRoots();
            if (this$roots == null ? other$roots != null : !((Object)this$roots).equals(other$roots)) {
                return false;
            }
            Sampling this$sampling = this.getSampling();
            Sampling other$sampling = other.getSampling();
            return !(this$sampling == null ? other$sampling != null : !((Object)this$sampling).equals(other$sampling));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClientCapabilities;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $experimental = this.getExperimental();
            result = result * 59 + ($experimental == null ? 43 : ((Object)$experimental).hashCode());
            RootCapabilities $roots = this.getRoots();
            result = result * 59 + ($roots == null ? 43 : ((Object)$roots).hashCode());
            Sampling $sampling = this.getSampling();
            result = result * 59 + ($sampling == null ? 43 : ((Object)$sampling).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ClientCapabilities(experimental=" + this.getExperimental() + ", roots=" + this.getRoots() + ", sampling=" + this.getSampling() + ")";
        }

        @Generated
        public ClientCapabilities(Map<String, Object> experimental, RootCapabilities roots, Sampling sampling) {
            this.experimental = experimental;
            this.roots = roots;
            this.sampling = sampling;
        }

        @Generated
        public ClientCapabilities() {
        }

        public static class Builder {
            private Map<String, Object> experimental;
            private RootCapabilities roots;
            private Sampling sampling;

            public Builder experimental(Map<String, Object> experimental) {
                this.experimental = experimental;
                return this;
            }

            public Builder roots(Boolean listChanged) {
                this.roots = new RootCapabilities(listChanged);
                return this;
            }

            public Builder sampling() {
                this.sampling = new Sampling();
                return this;
            }

            public ClientCapabilities build() {
                return new ClientCapabilities(this.experimental, this.roots, this.sampling);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class Sampling {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sampling)) {
                    return false;
                }
                Sampling other = (Sampling)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sampling;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }

            @Generated
            public String toString() {
                return "McpSchema.ClientCapabilities.Sampling()";
            }

            @Generated
            public Sampling() {
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class RootCapabilities {
            @JsonProperty(value="listChanged")
            Boolean listChanged;

            @Generated
            public Boolean getListChanged() {
                return this.listChanged;
            }

            @JsonProperty(value="listChanged")
            @Generated
            public void setListChanged(Boolean listChanged) {
                this.listChanged = listChanged;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RootCapabilities)) {
                    return false;
                }
                RootCapabilities other = (RootCapabilities)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$listChanged = this.getListChanged();
                Boolean other$listChanged = other.getListChanged();
                return !(this$listChanged == null ? other$listChanged != null : !((Object)this$listChanged).equals(other$listChanged));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof RootCapabilities;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $listChanged = this.getListChanged();
                result = result * 59 + ($listChanged == null ? 43 : ((Object)$listChanged).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.ClientCapabilities.RootCapabilities(listChanged=" + this.getListChanged() + ")";
            }

            @Generated
            public RootCapabilities(Boolean listChanged) {
                this.listChanged = listChanged;
            }

            @Generated
            public RootCapabilities() {
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InitializeResult {
        @JsonProperty(value="protocolVersion")
        String protocolVersion;
        @JsonProperty(value="capabilities")
        ServerCapabilities capabilities;
        @JsonProperty(value="serverInfo")
        Implementation serverInfo;
        @JsonProperty(value="instructions")
        String instructions;

        @Generated
        public String getProtocolVersion() {
            return this.protocolVersion;
        }

        @Generated
        public ServerCapabilities getCapabilities() {
            return this.capabilities;
        }

        @Generated
        public Implementation getServerInfo() {
            return this.serverInfo;
        }

        @Generated
        public String getInstructions() {
            return this.instructions;
        }

        @JsonProperty(value="protocolVersion")
        @Generated
        public void setProtocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        @JsonProperty(value="capabilities")
        @Generated
        public void setCapabilities(ServerCapabilities capabilities) {
            this.capabilities = capabilities;
        }

        @JsonProperty(value="serverInfo")
        @Generated
        public void setServerInfo(Implementation serverInfo) {
            this.serverInfo = serverInfo;
        }

        @JsonProperty(value="instructions")
        @Generated
        public void setInstructions(String instructions) {
            this.instructions = instructions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitializeResult)) {
                return false;
            }
            InitializeResult other = (InitializeResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$protocolVersion = this.getProtocolVersion();
            String other$protocolVersion = other.getProtocolVersion();
            if (this$protocolVersion == null ? other$protocolVersion != null : !this$protocolVersion.equals(other$protocolVersion)) {
                return false;
            }
            ServerCapabilities this$capabilities = this.getCapabilities();
            ServerCapabilities other$capabilities = other.getCapabilities();
            if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
                return false;
            }
            Implementation this$serverInfo = this.getServerInfo();
            Implementation other$serverInfo = other.getServerInfo();
            if (this$serverInfo == null ? other$serverInfo != null : !((Object)this$serverInfo).equals(other$serverInfo)) {
                return false;
            }
            String this$instructions = this.getInstructions();
            String other$instructions = other.getInstructions();
            return !(this$instructions == null ? other$instructions != null : !this$instructions.equals(other$instructions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InitializeResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $protocolVersion = this.getProtocolVersion();
            result = result * 59 + ($protocolVersion == null ? 43 : $protocolVersion.hashCode());
            ServerCapabilities $capabilities = this.getCapabilities();
            result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
            Implementation $serverInfo = this.getServerInfo();
            result = result * 59 + ($serverInfo == null ? 43 : ((Object)$serverInfo).hashCode());
            String $instructions = this.getInstructions();
            result = result * 59 + ($instructions == null ? 43 : $instructions.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.InitializeResult(protocolVersion=" + this.getProtocolVersion() + ", capabilities=" + this.getCapabilities() + ", serverInfo=" + this.getServerInfo() + ", instructions=" + this.getInstructions() + ")";
        }

        @Generated
        public InitializeResult(String protocolVersion, ServerCapabilities capabilities, Implementation serverInfo, String instructions) {
            this.protocolVersion = protocolVersion;
            this.capabilities = capabilities;
            this.serverInfo = serverInfo;
            this.instructions = instructions;
        }

        @Generated
        public InitializeResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InitializeRequest
    implements Request {
        @JsonProperty(value="protocolVersion")
        String protocolVersion;
        @JsonProperty(value="capabilities")
        ClientCapabilities capabilities;
        @JsonProperty(value="clientInfo")
        Implementation clientInfo;

        @Generated
        public String getProtocolVersion() {
            return this.protocolVersion;
        }

        @Generated
        public ClientCapabilities getCapabilities() {
            return this.capabilities;
        }

        @Generated
        public Implementation getClientInfo() {
            return this.clientInfo;
        }

        @JsonProperty(value="protocolVersion")
        @Generated
        public void setProtocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        @JsonProperty(value="capabilities")
        @Generated
        public void setCapabilities(ClientCapabilities capabilities) {
            this.capabilities = capabilities;
        }

        @JsonProperty(value="clientInfo")
        @Generated
        public void setClientInfo(Implementation clientInfo) {
            this.clientInfo = clientInfo;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitializeRequest)) {
                return false;
            }
            InitializeRequest other = (InitializeRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$protocolVersion = this.getProtocolVersion();
            String other$protocolVersion = other.getProtocolVersion();
            if (this$protocolVersion == null ? other$protocolVersion != null : !this$protocolVersion.equals(other$protocolVersion)) {
                return false;
            }
            ClientCapabilities this$capabilities = this.getCapabilities();
            ClientCapabilities other$capabilities = other.getCapabilities();
            if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
                return false;
            }
            Implementation this$clientInfo = this.getClientInfo();
            Implementation other$clientInfo = other.getClientInfo();
            return !(this$clientInfo == null ? other$clientInfo != null : !((Object)this$clientInfo).equals(other$clientInfo));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InitializeRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $protocolVersion = this.getProtocolVersion();
            result = result * 59 + ($protocolVersion == null ? 43 : $protocolVersion.hashCode());
            ClientCapabilities $capabilities = this.getCapabilities();
            result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
            Implementation $clientInfo = this.getClientInfo();
            result = result * 59 + ($clientInfo == null ? 43 : ((Object)$clientInfo).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.InitializeRequest(protocolVersion=" + this.getProtocolVersion() + ", capabilities=" + this.getCapabilities() + ", clientInfo=" + this.getClientInfo() + ")";
        }

        @Generated
        public InitializeRequest(String protocolVersion, ClientCapabilities capabilities, Implementation clientInfo) {
            this.protocolVersion = protocolVersion;
            this.capabilities = capabilities;
            this.clientInfo = clientInfo;
        }

        @Generated
        public InitializeRequest() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JSONRPCResponse
    implements JSONRPCMessage {
        @JsonProperty(value="jsonrpc")
        String jsonrpc;
        @JsonProperty(value="id")
        Object id;
        @JsonProperty(value="result")
        Object result;
        @JsonProperty(value="error")
        JSONRPCError error;

        @Override
        @Generated
        public String getJsonrpc() {
            return this.jsonrpc;
        }

        @Generated
        public Object getId() {
            return this.id;
        }

        @Generated
        public Object getResult() {
            return this.result;
        }

        @Generated
        public JSONRPCError getError() {
            return this.error;
        }

        @JsonProperty(value="jsonrpc")
        @Generated
        public void setJsonrpc(String jsonrpc) {
            this.jsonrpc = jsonrpc;
        }

        @JsonProperty(value="id")
        @Generated
        public void setId(Object id) {
            this.id = id;
        }

        @JsonProperty(value="result")
        @Generated
        public void setResult(Object result) {
            this.result = result;
        }

        @JsonProperty(value="error")
        @Generated
        public void setError(JSONRPCError error) {
            this.error = error;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JSONRPCResponse)) {
                return false;
            }
            JSONRPCResponse other = (JSONRPCResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jsonrpc = this.getJsonrpc();
            String other$jsonrpc = other.getJsonrpc();
            if (this$jsonrpc == null ? other$jsonrpc != null : !this$jsonrpc.equals(other$jsonrpc)) {
                return false;
            }
            Object this$id = this.getId();
            Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            Object this$result = this.getResult();
            Object other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            JSONRPCError this$error = this.getError();
            JSONRPCError other$error = other.getError();
            return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JSONRPCResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jsonrpc = this.getJsonrpc();
            result = result * 59 + ($jsonrpc == null ? 43 : $jsonrpc.hashCode());
            Object $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            Object $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            JSONRPCError $error = this.getError();
            result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.JSONRPCResponse(jsonrpc=" + this.getJsonrpc() + ", id=" + this.getId() + ", result=" + this.getResult() + ", error=" + this.getError() + ")";
        }

        @Generated
        public JSONRPCResponse(String jsonrpc, Object id, Object result, JSONRPCError error) {
            this.jsonrpc = jsonrpc;
            this.id = id;
            this.result = result;
            this.error = error;
        }

        @Generated
        public JSONRPCResponse() {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class JSONRPCError {
            @JsonProperty(value="code")
            int code;
            @JsonProperty(value="message")
            String message;
            @JsonProperty(value="data")
            Object data;

            @Generated
            public int getCode() {
                return this.code;
            }

            @Generated
            public String getMessage() {
                return this.message;
            }

            @Generated
            public Object getData() {
                return this.data;
            }

            @JsonProperty(value="code")
            @Generated
            public void setCode(int code) {
                this.code = code;
            }

            @JsonProperty(value="message")
            @Generated
            public void setMessage(String message) {
                this.message = message;
            }

            @JsonProperty(value="data")
            @Generated
            public void setData(Object data) {
                this.data = data;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof JSONRPCError)) {
                    return false;
                }
                JSONRPCError other = (JSONRPCError)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getCode() != other.getCode()) {
                    return false;
                }
                String this$message = this.getMessage();
                String other$message = other.getMessage();
                if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                    return false;
                }
                Object this$data = this.getData();
                Object other$data = other.getData();
                return !(this$data == null ? other$data != null : !this$data.equals(other$data));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof JSONRPCError;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getCode();
                String $message = this.getMessage();
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                Object $data = this.getData();
                result = result * 59 + ($data == null ? 43 : $data.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.JSONRPCResponse.JSONRPCError(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
            }

            @Generated
            public JSONRPCError(int code, String message, Object data) {
                this.code = code;
                this.message = message;
                this.data = data;
            }

            @Generated
            public JSONRPCError() {
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JSONRPCNotification
    implements JSONRPCMessage {
        @JsonProperty(value="jsonrpc")
        String jsonrpc;
        @JsonProperty(value="method")
        String method;
        @JsonProperty(value="params")
        Map<String, Object> params;

        @Override
        @Generated
        public String getJsonrpc() {
            return this.jsonrpc;
        }

        @Generated
        public String getMethod() {
            return this.method;
        }

        @Generated
        public Map<String, Object> getParams() {
            return this.params;
        }

        @JsonProperty(value="jsonrpc")
        @Generated
        public void setJsonrpc(String jsonrpc) {
            this.jsonrpc = jsonrpc;
        }

        @JsonProperty(value="method")
        @Generated
        public void setMethod(String method) {
            this.method = method;
        }

        @JsonProperty(value="params")
        @Generated
        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JSONRPCNotification)) {
                return false;
            }
            JSONRPCNotification other = (JSONRPCNotification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jsonrpc = this.getJsonrpc();
            String other$jsonrpc = other.getJsonrpc();
            if (this$jsonrpc == null ? other$jsonrpc != null : !this$jsonrpc.equals(other$jsonrpc)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            Map<String, Object> this$params = this.getParams();
            Map<String, Object> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JSONRPCNotification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jsonrpc = this.getJsonrpc();
            result = result * 59 + ($jsonrpc == null ? 43 : $jsonrpc.hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            Map<String, Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.JSONRPCNotification(jsonrpc=" + this.getJsonrpc() + ", method=" + this.getMethod() + ", params=" + this.getParams() + ")";
        }

        @Generated
        public JSONRPCNotification(String jsonrpc, String method, Map<String, Object> params) {
            this.jsonrpc = jsonrpc;
            this.method = method;
            this.params = params;
        }

        @Generated
        public JSONRPCNotification() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JSONRPCRequest
    implements JSONRPCMessage {
        @JsonProperty(value="jsonrpc")
        String jsonrpc;
        @JsonProperty(value="method")
        String method;
        @JsonProperty(value="id")
        Object id;
        @JsonProperty(value="params")
        Object params;

        @Override
        @Generated
        public String getJsonrpc() {
            return this.jsonrpc;
        }

        @Generated
        public String getMethod() {
            return this.method;
        }

        @Generated
        public Object getId() {
            return this.id;
        }

        @Generated
        public Object getParams() {
            return this.params;
        }

        @JsonProperty(value="jsonrpc")
        @Generated
        public void setJsonrpc(String jsonrpc) {
            this.jsonrpc = jsonrpc;
        }

        @JsonProperty(value="method")
        @Generated
        public void setMethod(String method) {
            this.method = method;
        }

        @JsonProperty(value="id")
        @Generated
        public void setId(Object id) {
            this.id = id;
        }

        @JsonProperty(value="params")
        @Generated
        public void setParams(Object params) {
            this.params = params;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JSONRPCRequest)) {
                return false;
            }
            JSONRPCRequest other = (JSONRPCRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jsonrpc = this.getJsonrpc();
            String other$jsonrpc = other.getJsonrpc();
            if (this$jsonrpc == null ? other$jsonrpc != null : !this$jsonrpc.equals(other$jsonrpc)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            Object this$id = this.getId();
            Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            Object this$params = this.getParams();
            Object other$params = other.getParams();
            return !(this$params == null ? other$params != null : !this$params.equals(other$params));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JSONRPCRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jsonrpc = this.getJsonrpc();
            result = result * 59 + ($jsonrpc == null ? 43 : $jsonrpc.hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            Object $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            Object $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : $params.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.JSONRPCRequest(jsonrpc=" + this.getJsonrpc() + ", method=" + this.getMethod() + ", id=" + this.getId() + ", params=" + this.getParams() + ")";
        }

        @Generated
        public JSONRPCRequest(String jsonrpc, String method, Object id, Object params) {
            this.jsonrpc = jsonrpc;
            this.method = method;
            this.id = id;
            this.params = params;
        }

        @Generated
        public JSONRPCRequest() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JSONRPCBatchResponse
    implements JSONRPCMessage {
        @JsonProperty(value="items")
        List<JSONRPCMessage> items;

        @Override
        @JsonIgnore
        public String getJsonrpc() {
            return McpSchema.JSONRPC_VERSION;
        }

        @Generated
        public List<JSONRPCMessage> getItems() {
            return this.items;
        }

        @JsonProperty(value="items")
        @Generated
        public void setItems(List<JSONRPCMessage> items) {
            this.items = items;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JSONRPCBatchResponse)) {
                return false;
            }
            JSONRPCBatchResponse other = (JSONRPCBatchResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<JSONRPCMessage> this$items = this.getItems();
            List<JSONRPCMessage> other$items = other.getItems();
            return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JSONRPCBatchResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<JSONRPCMessage> $items = this.getItems();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.JSONRPCBatchResponse(items=" + this.getItems() + ")";
        }

        @Generated
        public JSONRPCBatchResponse(List<JSONRPCMessage> items) {
            this.items = items;
        }

        @Generated
        public JSONRPCBatchResponse() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JSONRPCBatchRequest
    implements JSONRPCMessage {
        @JsonProperty(value="items")
        List<JSONRPCMessage> items;

        @Override
        @JsonIgnore
        public String getJsonrpc() {
            return McpSchema.JSONRPC_VERSION;
        }

        @Generated
        public List<JSONRPCMessage> getItems() {
            return this.items;
        }

        @JsonProperty(value="items")
        @Generated
        public void setItems(List<JSONRPCMessage> items) {
            this.items = items;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JSONRPCBatchRequest)) {
                return false;
            }
            JSONRPCBatchRequest other = (JSONRPCBatchRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<JSONRPCMessage> this$items = this.getItems();
            List<JSONRPCMessage> other$items = other.getItems();
            return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JSONRPCBatchRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<JSONRPCMessage> $items = this.getItems();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.JSONRPCBatchRequest(items=" + this.getItems() + ")";
        }

        @Generated
        public JSONRPCBatchRequest(List<JSONRPCMessage> items) {
            this.items = items;
        }

        @Generated
        public JSONRPCBatchRequest() {
        }
    }

    public static interface JSONRPCMessage {
        public String getJsonrpc();

        public static void checkSealed(JSONRPCMessage message) {
            boolean permitted = false;
            for (Class<?> clazz : SealedControl.PERMITTED) {
                if (!clazz.isInstance(message)) continue;
                permitted = true;
                break;
            }
            if (!permitted) {
                throw new IllegalArgumentException("Prohibited subtype: " + message.getClass());
            }
        }

        public static final class SealedControl {
            static final Class<?>[] PERMITTED = new Class[]{JSONRPCBatchRequest.class, JSONRPCBatchResponse.class, JSONRPCRequest.class, JSONRPCNotification.class, JSONRPCResponse.class};

            private SealedControl() {
            }
        }
    }

    public static interface Request {
    }

    public static final class ErrorCodes {
        public static final int PARSE_ERROR = -32700;
        public static final int INVALID_REQUEST = -32600;
        public static final int METHOD_NOT_FOUND = -32601;
        public static final int INVALID_PARAMS = -32602;
        public static final int INTERNAL_ERROR = -32603;
    }
}

