/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.server.prompt;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.ai.annotation.PromptMapping;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.ai.chat.tool.MethodExecuteHandler;
import org.noear.solon.ai.chat.tool.ToolSchemaUtil;
import org.noear.solon.ai.mcp.server.prompt.FunctionPrompt;
import org.noear.solon.ai.util.ParamDesc;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.util.Assert;
import org.noear.solon.core.wrap.MethodWrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodFunctionPrompt
implements FunctionPrompt {
    static final Logger log = LoggerFactory.getLogger(MethodFunctionPrompt.class);
    private final BeanWrap beanWrap;
    private final MethodWrap methodWrap;
    private final String name;
    private final PromptMapping mapping;
    private final List<ParamDesc> params;

    public MethodFunctionPrompt(BeanWrap beanWrap, Method method) {
        this.beanWrap = beanWrap;
        this.methodWrap = new MethodWrap(beanWrap.context(), method.getDeclaringClass(), method);
        this.mapping = method.getAnnotation(PromptMapping.class);
        this.name = Utils.annoAlias((String)this.mapping.name(), (String)method.getName());
        Assert.notNull((Object)this.mapping, (String)"@PromptMapping annotation is missing");
        Assert.notEmpty((String)this.mapping.description(), (String)"PromptMapping description cannot be empty");
        if (!Collection.class.isAssignableFrom(method.getReturnType())) {
            throw new IllegalArgumentException("@PromptMapping return type is not Collection");
        }
        this.params = new ArrayList<ParamDesc>();
        for (Parameter p1 : method.getParameters()) {
            ParamDesc toolParam = ToolSchemaUtil.paramOf((AnnotatedElement)p1);
            if (toolParam == null) continue;
            this.params.add(toolParam);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.mapping.description();
    }

    @Override
    public Collection<ParamDesc> params() {
        return this.params;
    }

    @Override
    public Collection<ChatMessage> handle(Map<String, Object> args) throws Throwable {
        try {
            return this.doHandle(args);
        }
        catch (Throwable ex) {
            if (log.isWarnEnabled()) {
                log.warn("Prompt handle error, name: '{}'", (Object)this.name, (Object)ex);
            }
            throw ex;
        }
    }

    private Collection<ChatMessage> doHandle(Map<String, Object> args) throws Throwable {
        Context ctx = Context.current();
        if (ctx == null) {
            ctx = new ContextEmpty();
        }
        ctx.attrSet("MCP_BODY", args);
        ctx.result = MethodExecuteHandler.getInstance().executeHandle(ctx, this.beanWrap.get(), this.methodWrap);
        return (Collection)ctx.result;
    }
}

