/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.spec;

import com.fasterxml.jackson.core.type.TypeReference;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpSession;
import io.modelcontextprotocol.spec.McpTransport;
import java.util.Map;
import java.util.UUID;
import reactor.core.publisher.Mono;

public class StatelessMcpSession
implements McpSession {
    private final McpTransport transport;

    public StatelessMcpSession(McpTransport transport) {
        this.transport = transport;
    }

    @Override
    public String getId() {
        return "stateless";
    }

    @Override
    public Mono<Void> handle(McpSchema.JSONRPCMessage message) {
        if (message instanceof McpSchema.JSONRPCRequest) {
            McpSchema.JSONRPCRequest request = (McpSchema.JSONRPCRequest)message;
            McpSchema.JSONRPCResponse errorResponse = new McpSchema.JSONRPCResponse("2.0", request.getId(), null, new McpSchema.JSONRPCResponse.JSONRPCError(-32601, "Stateless session does not handle requests", null));
            return this.transport.sendMessage(errorResponse);
        }
        if (message instanceof McpSchema.JSONRPCNotification) {
            return Mono.empty();
        }
        if (message instanceof McpSchema.JSONRPCResponse) {
            return Mono.empty();
        }
        return Mono.empty();
    }

    @Override
    public <T> Mono<T> sendRequest(String method, Object requestParams, TypeReference<T> typeRef) {
        String requestId = UUID.randomUUID().toString();
        McpSchema.JSONRPCRequest request = new McpSchema.JSONRPCRequest("2.0", method, requestId, requestParams);
        return Mono.defer(() -> Mono.from(this.transport.sendMessage(request)).then(Mono.error((Throwable)new IllegalStateException("Stateless session cannot receive responses"))));
    }

    @Override
    public Mono<Void> sendNotification(String method, Map<String, Object> params) {
        McpSchema.JSONRPCNotification notification = new McpSchema.JSONRPCNotification("2.0", method, params);
        return Mono.from(this.transport.sendMessage(notification));
    }

    @Override
    public Mono<Void> closeGracefully() {
        return this.transport.closeGracefully();
    }

    @Override
    public void close() {
        this.closeGracefully().subscribe();
    }
}

