/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.server.resource;

import java.util.function.Function;
import org.noear.solon.ai.mcp.server.resource.FunctionResource;
import org.noear.solon.ai.media.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionResourceDesc
implements FunctionResource {
    static final Logger log = LoggerFactory.getLogger(FunctionResourceDesc.class);
    private final String name;
    private String uri;
    private String description;
    private String mimeType;
    private Function<String, Text> doHandler;

    public FunctionResourceDesc(String name) {
        this.name = name;
    }

    public FunctionResourceDesc uri(String uri) {
        this.uri = uri;
        return this;
    }

    public FunctionResourceDesc description(String description) {
        this.description = description;
        return this;
    }

    public FunctionResourceDesc mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public FunctionResourceDesc doHandle(Function<String, Text> handler) {
        this.doHandler = handler;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public Text handle(String reqUri) throws Throwable {
        try {
            return this.doHandler.apply(reqUri);
        }
        catch (Throwable ex) {
            if (log.isWarnEnabled()) {
                log.warn("Resource handle error, name: '{}'", (Object)this.name, (Object)ex);
            }
            throw ex;
        }
    }

    public String toString() {
        return "FunctionResourceDesc{name='" + this.name + '\'' + ", uri='" + this.uri + '\'' + ", description='" + this.description + '\'' + ", mimeType='" + this.mimeType + '\'' + '}';
    }
}

