/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

class McpClientFeatures {
    McpClientFeatures() {
    }

    public static class Sync {
        McpSchema.Implementation clientInfo;
        McpSchema.ClientCapabilities clientCapabilities;
        Map<String, McpSchema.Root> roots;
        List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers;
        List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers;
        List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers;
        List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers;
        Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler;

        public Sync(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers, List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers, List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers, List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers, Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler) {
            Assert.notNull(clientInfo, "Client info must not be null");
            this.clientInfo = clientInfo;
            this.clientCapabilities = clientCapabilities != null ? clientCapabilities : new McpSchema.ClientCapabilities(null, !Utils.isEmpty(roots) ? new McpSchema.ClientCapabilities.RootCapabilities(false) : null, samplingHandler != null ? new McpSchema.ClientCapabilities.Sampling() : null);
            this.roots = roots != null ? new HashMap<String, McpSchema.Root>(roots) : new HashMap();
            this.toolsChangeConsumers = toolsChangeConsumers != null ? toolsChangeConsumers : Collections.emptyList();
            this.resourcesChangeConsumers = resourcesChangeConsumers != null ? resourcesChangeConsumers : Collections.emptyList();
            this.promptsChangeConsumers = promptsChangeConsumers != null ? promptsChangeConsumers : Collections.emptyList();
            this.loggingConsumers = loggingConsumers != null ? loggingConsumers : Collections.emptyList();
            this.samplingHandler = samplingHandler;
        }

        @Generated
        public McpSchema.Implementation getClientInfo() {
            return this.clientInfo;
        }

        @Generated
        public McpSchema.ClientCapabilities getClientCapabilities() {
            return this.clientCapabilities;
        }

        @Generated
        public Map<String, McpSchema.Root> getRoots() {
            return this.roots;
        }

        @Generated
        public List<Consumer<List<McpSchema.Tool>>> getToolsChangeConsumers() {
            return this.toolsChangeConsumers;
        }

        @Generated
        public List<Consumer<List<McpSchema.Resource>>> getResourcesChangeConsumers() {
            return this.resourcesChangeConsumers;
        }

        @Generated
        public List<Consumer<List<McpSchema.Prompt>>> getPromptsChangeConsumers() {
            return this.promptsChangeConsumers;
        }

        @Generated
        public List<Consumer<McpSchema.LoggingMessageNotification>> getLoggingConsumers() {
            return this.loggingConsumers;
        }

        @Generated
        public Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> getSamplingHandler() {
            return this.samplingHandler;
        }

        @Generated
        public void setClientInfo(McpSchema.Implementation clientInfo) {
            this.clientInfo = clientInfo;
        }

        @Generated
        public void setClientCapabilities(McpSchema.ClientCapabilities clientCapabilities) {
            this.clientCapabilities = clientCapabilities;
        }

        @Generated
        public void setRoots(Map<String, McpSchema.Root> roots) {
            this.roots = roots;
        }

        @Generated
        public void setToolsChangeConsumers(List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers) {
            this.toolsChangeConsumers = toolsChangeConsumers;
        }

        @Generated
        public void setResourcesChangeConsumers(List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers) {
            this.resourcesChangeConsumers = resourcesChangeConsumers;
        }

        @Generated
        public void setPromptsChangeConsumers(List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers) {
            this.promptsChangeConsumers = promptsChangeConsumers;
        }

        @Generated
        public void setLoggingConsumers(List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers) {
            this.loggingConsumers = loggingConsumers;
        }

        @Generated
        public void setSamplingHandler(Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler) {
            this.samplingHandler = samplingHandler;
        }
    }

    static class Async {
        McpSchema.Implementation clientInfo;
        McpSchema.ClientCapabilities clientCapabilities;
        Map<String, McpSchema.Root> roots;
        List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers;
        List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers;
        List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers;
        List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers;
        Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler;

        public Async(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers, List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers, List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers, List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers, Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler) {
            Assert.notNull(clientInfo, "Client info must not be null");
            this.clientInfo = clientInfo;
            this.clientCapabilities = clientCapabilities != null ? clientCapabilities : new McpSchema.ClientCapabilities(null, !Utils.isEmpty(roots) ? new McpSchema.ClientCapabilities.RootCapabilities(false) : null, samplingHandler != null ? new McpSchema.ClientCapabilities.Sampling() : null);
            this.roots = roots != null ? new ConcurrentHashMap<String, McpSchema.Root>(roots) : new ConcurrentHashMap();
            this.toolsChangeConsumers = toolsChangeConsumers != null ? toolsChangeConsumers : Collections.emptyList();
            this.resourcesChangeConsumers = resourcesChangeConsumers != null ? resourcesChangeConsumers : Collections.emptyList();
            this.promptsChangeConsumers = promptsChangeConsumers != null ? promptsChangeConsumers : Collections.emptyList();
            this.loggingConsumers = loggingConsumers != null ? loggingConsumers : Collections.emptyList();
            this.samplingHandler = samplingHandler;
        }

        public static Async fromSync(Sync syncSpec) {
            ArrayList<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers = new ArrayList<Function<List<McpSchema.Tool>, Mono<Void>>>();
            for (Consumer<List<McpSchema.Tool>> consumer : syncSpec.getToolsChangeConsumers()) {
                toolsChangeConsumers.add(t -> Mono.fromRunnable(() -> consumer.accept(t)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers = new ArrayList<Function<List<McpSchema.Resource>, Mono<Void>>>();
            for (Consumer<List<McpSchema.Resource>> consumer : syncSpec.getResourcesChangeConsumers()) {
                resourcesChangeConsumers.add(r -> Mono.fromRunnable(() -> consumer.accept((List<McpSchema.Resource>)r)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<List<McpSchema.Prompt>, Mono<Void>>> arrayList = new ArrayList<Function<List<McpSchema.Prompt>, Mono<Void>>>();
            for (Consumer<List<McpSchema.Prompt>> consumer : syncSpec.getPromptsChangeConsumers()) {
                arrayList.add(p -> Mono.fromRunnable(() -> consumer.accept((List<McpSchema.Prompt>)p)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> arrayList2 = new ArrayList<Function<McpSchema.LoggingMessageNotification, Mono<Void>>>();
            for (Consumer<McpSchema.LoggingMessageNotification> consumer : syncSpec.getLoggingConsumers()) {
                arrayList2.add(l -> Mono.fromRunnable(() -> consumer.accept(l)).subscribeOn(Schedulers.boundedElastic()));
            }
            Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> function = r -> Mono.fromCallable(() -> syncSpec.getSamplingHandler().apply((McpSchema.CreateMessageRequest)r)).subscribeOn(Schedulers.boundedElastic());
            return new Async(syncSpec.getClientInfo(), syncSpec.getClientCapabilities(), syncSpec.getRoots(), toolsChangeConsumers, resourcesChangeConsumers, arrayList, arrayList2, function);
        }

        @Generated
        public McpSchema.Implementation getClientInfo() {
            return this.clientInfo;
        }

        @Generated
        public McpSchema.ClientCapabilities getClientCapabilities() {
            return this.clientCapabilities;
        }

        @Generated
        public Map<String, McpSchema.Root> getRoots() {
            return this.roots;
        }

        @Generated
        public List<Function<List<McpSchema.Tool>, Mono<Void>>> getToolsChangeConsumers() {
            return this.toolsChangeConsumers;
        }

        @Generated
        public List<Function<List<McpSchema.Resource>, Mono<Void>>> getResourcesChangeConsumers() {
            return this.resourcesChangeConsumers;
        }

        @Generated
        public List<Function<List<McpSchema.Prompt>, Mono<Void>>> getPromptsChangeConsumers() {
            return this.promptsChangeConsumers;
        }

        @Generated
        public List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> getLoggingConsumers() {
            return this.loggingConsumers;
        }

        @Generated
        public Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> getSamplingHandler() {
            return this.samplingHandler;
        }

        @Generated
        public void setClientInfo(McpSchema.Implementation clientInfo) {
            this.clientInfo = clientInfo;
        }

        @Generated
        public void setClientCapabilities(McpSchema.ClientCapabilities clientCapabilities) {
            this.clientCapabilities = clientCapabilities;
        }

        @Generated
        public void setRoots(Map<String, McpSchema.Root> roots) {
            this.roots = roots;
        }

        @Generated
        public void setToolsChangeConsumers(List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers) {
            this.toolsChangeConsumers = toolsChangeConsumers;
        }

        @Generated
        public void setResourcesChangeConsumers(List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers) {
            this.resourcesChangeConsumers = resourcesChangeConsumers;
        }

        @Generated
        public void setPromptsChangeConsumers(List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers) {
            this.promptsChangeConsumers = promptsChangeConsumers;
        }

        @Generated
        public void setLoggingConsumers(List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers) {
            this.loggingConsumers = loggingConsumers;
        }

        @Generated
        public void setSamplingHandler(Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler) {
            this.samplingHandler = samplingHandler;
        }
    }
}

