/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.client;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.util.Assert;

public class McpServerParameters
implements Serializable {
    private String transport;
    private String type;
    private String url;
    private Map<String, String> headers = new HashMap<String, String>();
    private Duration timeout;
    private String command;
    private List<String> args = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public static Builder builder(String command) {
        return new Builder(command);
    }

    public static class Builder {
        private McpServerParameters params = new McpServerParameters();

        public Builder(String command) {
            Assert.notNull((Object)command, (String)"The command can not be null");
            this.params.command = command;
        }

        public Builder args(String ... args) {
            Assert.notNull((Object)args, (String)"The args can not be null");
            this.params.args = Arrays.asList(args);
            return this;
        }

        public Builder args(List<String> args) {
            Assert.notNull(args, (String)"The args can not be null");
            this.params.args = new ArrayList<String>(args);
            return this;
        }

        public Builder arg(String arg) {
            Assert.notNull((Object)arg, (String)"The arg can not be null");
            this.params.args.add(arg);
            return this;
        }

        public Builder env(Map<String, String> env) {
            if (Utils.isNotEmpty(env)) {
                this.params.env.putAll(env);
            }
            return this;
        }

        public Builder addEnvVar(String key, String value) {
            Assert.notNull((Object)key, (String)"The key can not be null");
            Assert.notNull((Object)value, (String)"The value can not be null");
            this.params.env.put(key, value);
            return this;
        }

        public McpServerParameters build() {
            return this.params;
        }
    }
}

