/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.server;

import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.server.transport.StdioServerTransportProvider;
import io.modelcontextprotocol.server.transport.WebRxSseServerTransportProvider;
import java.util.Collection;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;

public class McpServerContext
extends ContextEmpty {
    private final McpSyncServerExchange serverExchange;
    private final Context context;

    public McpServerContext(McpSyncServerExchange serverExchange) {
        this.serverExchange = serverExchange;
        if (serverExchange.getSession().getTransport() instanceof WebRxSseServerTransportProvider.WebRxMcpSessionTransport) {
            this.context = ((WebRxSseServerTransportProvider.WebRxMcpSessionTransport)serverExchange.getSession().getTransport()).getContext();
            for (KeyValues kv : this.context.paramMap()) {
                for (String v : kv.getValues()) {
                    this.paramMap().add(kv.getKey(), (Object)v);
                    this.headerMap().add(kv.getKey(), (Object)v);
                }
            }
            for (KeyValues kv : this.context.headerMap()) {
                for (String v : kv.getValues()) {
                    this.headerMap().add(kv.getKey(), (Object)v);
                }
            }
        } else {
            this.context = new ContextEmpty();
            if (serverExchange.getSession().getTransport() instanceof StdioServerTransportProvider.StdioMcpSessionTransport) {
                this.headerMap().addAll(System.getenv());
            }
        }
    }

    public String sessionId() {
        return this.serverExchange.getSession().getId();
    }

    public String realIp() {
        return this.context.realIp();
    }

    public String remoteIp() {
        return this.context.remoteIp();
    }

    public int remotePort() {
        return this.context.remotePort();
    }

    public String referer() {
        return this.context.referer();
    }

    public String userAgent() {
        return this.context.userAgent();
    }

    public String protocol() {
        return this.context.protocol();
    }

    public String queryString() {
        return this.context.queryString();
    }

    public SessionState sessionState() {
        return this.context.sessionState();
    }

    public <T> T session(String name, Class<T> clz) {
        return (T)this.context.session(name, clz);
    }

    public double sessionAsDouble(String name) {
        return this.context.sessionAsDouble(name);
    }

    public double sessionAsDouble(String name, double def) {
        return this.context.sessionAsDouble(name, def);
    }

    public int sessionAsInt(String name) {
        return this.context.sessionAsInt(name);
    }

    public int sessionAsInt(String name, int def) {
        return this.context.sessionAsInt(name, def);
    }

    public long sessionAsLong(String name) {
        return this.context.sessionAsLong(name);
    }

    public long sessionAsLong(String name, long def) {
        return this.context.sessionAsLong(name, def);
    }

    public <T> T sessionOrDefault(String name, T def) {
        return (T)this.context.sessionOrDefault(name, def);
    }

    public void sessionSet(String name, Object val) {
        this.context.sessionSet(name, val);
    }

    public void sessionClear() {
        this.context.sessionClear();
    }

    public void sessionRemove(String name) {
        this.context.sessionRemove(name);
    }

    public void sessionReset() {
        this.context.sessionReset();
    }

    public String cookie(String name) {
        return this.context.cookie(name);
    }

    public String cookieOrDefault(String name, String def) {
        return this.context.cookieOrDefault(name, def);
    }

    public String[] cookieValues(String name) {
        return this.context.cookieValues(name);
    }

    public Collection<String> cookieNames() {
        return this.context.cookieNames();
    }

    public MultiMap<String> cookieMap() {
        throw new UnsupportedOperationException();
    }
}

