/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.UriTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import reactor.core.publisher.Mono;

public interface McpServer {
    public static SyncSpecification sync(McpServerTransportProvider transportProvider) {
        return new SyncSpecification(transportProvider);
    }

    public static AsyncSpecification async(McpServerTransportProvider transportProvider) {
        return new AsyncSpecification(transportProvider);
    }

    public static class SyncSpecification {
        private static final McpSchema.Implementation DEFAULT_SERVER_INFO = new McpSchema.Implementation("mcp-server", "1.0.0");
        private final McpServerTransportProvider transportProvider;
        private ObjectMapper objectMapper;
        private McpSchema.Implementation serverInfo = DEFAULT_SERVER_INFO;
        private McpSchema.ServerCapabilities serverCapabilities;
        private final List<McpServerFeatures.SyncToolSpecification> tools = new ArrayList<McpServerFeatures.SyncToolSpecification>();
        private final Map<String, McpServerFeatures.SyncResourceSpecification> resources = new HashMap<String, McpServerFeatures.SyncResourceSpecification>();
        private final Map<String, McpServerFeatures.SyncResourceTemplateSpecification> resourceTemplates = new HashMap<String, McpServerFeatures.SyncResourceTemplateSpecification>();
        private final Map<String, McpServerFeatures.SyncPromptSpecification> prompts = new HashMap<String, McpServerFeatures.SyncPromptSpecification>();
        private final List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeHandlers = new ArrayList<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>>();

        private SyncSpecification(McpServerTransportProvider transportProvider) {
            Assert.notNull(transportProvider, "Transport provider must not be null");
            this.transportProvider = transportProvider;
        }

        public SyncSpecification serverInfo(McpSchema.Implementation serverInfo) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            return this;
        }

        public SyncSpecification serverInfo(String name, String version) {
            Assert.hasText(name, "Name must not be null or empty");
            Assert.hasText(version, "Version must not be null or empty");
            this.serverInfo = new McpSchema.Implementation(name, version);
            return this;
        }

        public SyncSpecification capabilities(McpSchema.ServerCapabilities serverCapabilities) {
            Assert.notNull(serverCapabilities, "Server capabilities must not be null");
            this.serverCapabilities = serverCapabilities;
            return this;
        }

        public SyncSpecification tool(McpSchema.Tool tool, BiFunction<McpSyncServerExchange, Map<String, Object>, McpSchema.CallToolResult> handler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.tools.add(new McpServerFeatures.SyncToolSpecification(tool, handler));
            return this;
        }

        public SyncSpecification tools(List<McpServerFeatures.SyncToolSpecification> toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            this.tools.addAll(toolSpecifications);
            return this;
        }

        public SyncSpecification tools(McpServerFeatures.SyncToolSpecification ... toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            for (McpServerFeatures.SyncToolSpecification tool : toolSpecifications) {
                this.tools.add(tool);
            }
            return this;
        }

        public SyncSpecification resources(Map<String, McpServerFeatures.SyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers map must not be null");
            this.resources.putAll(resourceSpecifications);
            return this;
        }

        public SyncSpecification resources(List<McpServerFeatures.SyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpServerFeatures.SyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.getResource().getUri(), resource);
            }
            return this;
        }

        public SyncSpecification resources(McpServerFeatures.SyncResourceSpecification ... resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpServerFeatures.SyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.getResource().getUri(), resource);
            }
            return this;
        }

        public SyncSpecification resourceTemplates(List<McpServerFeatures.SyncResourceTemplateSpecification> resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            for (McpServerFeatures.SyncResourceTemplateSpecification resource : resourceTemplates) {
                this.resourceTemplates.put(resource.getResource().getUriTemplate(), resource);
            }
            return this;
        }

        public SyncSpecification resourceTemplates(McpServerFeatures.SyncResourceTemplateSpecification ... resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            for (McpServerFeatures.SyncResourceTemplateSpecification resource : resourceTemplates) {
                this.resourceTemplates.put(resource.getResource().getUriTemplate(), resource);
            }
            return this;
        }

        public SyncSpecification prompts(Map<String, McpServerFeatures.SyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts map must not be null");
            this.prompts.putAll(prompts);
            return this;
        }

        public SyncSpecification prompts(List<McpServerFeatures.SyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpServerFeatures.SyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.getPrompt().getName(), prompt);
            }
            return this;
        }

        public SyncSpecification prompts(McpServerFeatures.SyncPromptSpecification ... prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpServerFeatures.SyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.getPrompt().getName(), prompt);
            }
            return this;
        }

        public SyncSpecification rootsChangeHandler(BiConsumer<McpSyncServerExchange, List<McpSchema.Root>> handler) {
            Assert.notNull(handler, "Consumer must not be null");
            this.rootsChangeHandlers.add(handler);
            return this;
        }

        public SyncSpecification rootsChangeHandlers(List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> handlers) {
            Assert.notNull(handlers, "Handlers list must not be null");
            this.rootsChangeHandlers.addAll(handlers);
            return this;
        }

        public SyncSpecification rootsChangeHandlers(BiConsumer<McpSyncServerExchange, List<McpSchema.Root>> ... handlers) {
            Assert.notNull(handlers, "Handlers list must not be null");
            return this.rootsChangeHandlers(Arrays.asList(handlers));
        }

        public SyncSpecification objectMapper(ObjectMapper objectMapper) {
            Assert.notNull(objectMapper, "ObjectMapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public McpSyncServer build() {
            McpServerFeatures.Sync syncFeatures = new McpServerFeatures.Sync(this.serverInfo, this.serverCapabilities, this.tools, this.resources, this.resourceTemplates, this.prompts, this.rootsChangeHandlers);
            McpServerFeatures.Async asyncFeatures = McpServerFeatures.Async.fromSync(syncFeatures);
            ObjectMapper mapper = this.objectMapper != null ? this.objectMapper : new ObjectMapper();
            McpAsyncServer asyncServer = new McpAsyncServer(this.transportProvider, mapper, asyncFeatures);
            return new McpSyncServer(asyncServer);
        }
    }

    public static class AsyncSpecification {
        private static final McpSchema.Implementation DEFAULT_SERVER_INFO = new McpSchema.Implementation("mcp-server", "1.0.0");
        private final McpServerTransportProvider transportProvider;
        private ObjectMapper objectMapper;
        private McpSchema.Implementation serverInfo = DEFAULT_SERVER_INFO;
        private McpSchema.ServerCapabilities serverCapabilities;
        private final List<McpServerFeatures.AsyncToolSpecification> tools = new ArrayList<McpServerFeatures.AsyncToolSpecification>();
        private final Map<String, McpServerFeatures.AsyncResourceSpecification> resources = new HashMap<String, McpServerFeatures.AsyncResourceSpecification>();
        private final Map<UriTemplate, McpServerFeatures.AsyncResourceTemplateSpecification> resourceTemplates = new HashMap<UriTemplate, McpServerFeatures.AsyncResourceTemplateSpecification>();
        private final Map<String, McpServerFeatures.AsyncPromptSpecification> prompts = new HashMap<String, McpServerFeatures.AsyncPromptSpecification>();
        private final List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeHandlers = new ArrayList<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>>();

        private AsyncSpecification(McpServerTransportProvider transportProvider) {
            Assert.notNull(transportProvider, "Transport provider must not be null");
            this.transportProvider = transportProvider;
        }

        public AsyncSpecification serverInfo(McpSchema.Implementation serverInfo) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            return this;
        }

        public AsyncSpecification serverInfo(String name, String version) {
            Assert.hasText(name, "Name must not be null or empty");
            Assert.hasText(version, "Version must not be null or empty");
            this.serverInfo = new McpSchema.Implementation(name, version);
            return this;
        }

        public AsyncSpecification capabilities(McpSchema.ServerCapabilities serverCapabilities) {
            Assert.notNull(serverCapabilities, "Server capabilities must not be null");
            this.serverCapabilities = serverCapabilities;
            return this;
        }

        public AsyncSpecification tool(McpSchema.Tool tool, BiFunction<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>> handler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.tools.add(new McpServerFeatures.AsyncToolSpecification(tool, handler));
            return this;
        }

        public AsyncSpecification tools(List<McpServerFeatures.AsyncToolSpecification> toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            this.tools.addAll(toolSpecifications);
            return this;
        }

        public AsyncSpecification tools(McpServerFeatures.AsyncToolSpecification ... toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            for (McpServerFeatures.AsyncToolSpecification tool : toolSpecifications) {
                this.tools.add(tool);
            }
            return this;
        }

        public AsyncSpecification resources(Map<String, McpServerFeatures.AsyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers map must not be null");
            this.resources.putAll(resourceSpecifications);
            return this;
        }

        public AsyncSpecification resources(List<McpServerFeatures.AsyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpServerFeatures.AsyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.getResource().getUri(), resource);
            }
            return this;
        }

        public AsyncSpecification resources(McpServerFeatures.AsyncResourceSpecification ... resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpServerFeatures.AsyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.getResource().getUri(), resource);
            }
            return this;
        }

        public AsyncSpecification resourceTemplates(List<McpServerFeatures.AsyncResourceTemplateSpecification> resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            for (McpServerFeatures.AsyncResourceTemplateSpecification resource : resourceTemplates) {
                this.resourceTemplates.put(new UriTemplate(resource.getResource().getUriTemplate()), resource);
            }
            return this;
        }

        public AsyncSpecification resourceTemplates(McpServerFeatures.AsyncResourceTemplateSpecification ... resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            for (McpServerFeatures.AsyncResourceTemplateSpecification resource : resourceTemplates) {
                this.resourceTemplates.put(new UriTemplate(resource.getResource().getUriTemplate()), resource);
            }
            return this;
        }

        public AsyncSpecification prompts(Map<String, McpServerFeatures.AsyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts map must not be null");
            this.prompts.putAll(prompts);
            return this;
        }

        public AsyncSpecification prompts(List<McpServerFeatures.AsyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpServerFeatures.AsyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.getPrompt().getName(), prompt);
            }
            return this;
        }

        public AsyncSpecification prompts(McpServerFeatures.AsyncPromptSpecification ... prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpServerFeatures.AsyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.getPrompt().getName(), prompt);
            }
            return this;
        }

        public AsyncSpecification rootsChangeHandler(BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>> handler) {
            Assert.notNull(handler, "Consumer must not be null");
            this.rootsChangeHandlers.add(handler);
            return this;
        }

        public AsyncSpecification rootsChangeHandlers(List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> handlers) {
            Assert.notNull(handlers, "Handlers list must not be null");
            this.rootsChangeHandlers.addAll(handlers);
            return this;
        }

        public AsyncSpecification rootsChangeHandlers(BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>> ... handlers) {
            Assert.notNull(handlers, "Handlers list must not be null");
            return this.rootsChangeHandlers(Arrays.asList(handlers));
        }

        public AsyncSpecification objectMapper(ObjectMapper objectMapper) {
            Assert.notNull(objectMapper, "ObjectMapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public McpAsyncServer build() {
            McpServerFeatures.Async features = new McpServerFeatures.Async(this.serverInfo, this.serverCapabilities, this.tools, this.resources, this.resourceTemplates, this.prompts, this.rootsChangeHandlers);
            ObjectMapper mapper = this.objectMapper != null ? this.objectMapper : new ObjectMapper();
            return new McpAsyncServer(this.transportProvider, mapper, features);
        }
    }
}

