/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.server.manager;

import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.mcp.server.McpServerContext;
import org.noear.solon.ai.mcp.server.McpServerProperties;
import org.noear.solon.ai.mcp.server.manager.McpServerManager;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextHolder;

public class ToolMcpServerManager
implements McpServerManager<FunctionTool> {
    private final Map<String, FunctionTool> toolsMap = new ConcurrentHashMap<String, FunctionTool>();

    @Override
    public int count() {
        return this.toolsMap.size();
    }

    @Override
    public Collection<FunctionTool> all() {
        return this.toolsMap.values();
    }

    @Override
    public boolean contains(String toolName) {
        return this.toolsMap.containsKey(toolName);
    }

    @Override
    public void remove(McpSyncServer server, String toolName) {
        if (server != null) {
            server.removeTool(toolName);
            this.toolsMap.remove(toolName);
        }
    }

    @Override
    public void add(McpSyncServer server, McpServer.SyncSpecification mcpServerSpec, McpServerProperties mcpServerProps, FunctionTool functionTool) {
        this.toolsMap.put(functionTool.name(), functionTool);
        String inSchemaJson = this.buildJsonSchema(functionTool).toJson();
        String outSchemaJson = mcpServerProps.isEnableOutputSchema() ? functionTool.outputSchema() : null;
        McpServerFeatures.SyncToolSpecification toolSpec = new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool(functionTool.name(), functionTool.description(), (Boolean)functionTool.returnDirect(), inSchemaJson, outSchemaJson), (exchange, request) -> {
            try {
                ContextHolder.currentSet((Context)new McpServerContext((McpSyncServerExchange)exchange));
                String rst = functionTool.handle(request);
                McpSchema.CallToolResult callToolResult = new McpSchema.CallToolResult(Arrays.asList(new McpSchema.TextContent(rst)), false);
                return callToolResult;
            }
            catch (Throwable ex) {
                ex = Utils.throwableUnwrap((Throwable)ex);
                McpSchema.CallToolResult callToolResult = new McpSchema.CallToolResult(Arrays.asList(new McpSchema.TextContent(ex.getMessage())), true);
                return callToolResult;
            }
            finally {
                ContextHolder.currentRemove();
            }
        });
        if (server != null) {
            server.addTool(toolSpec);
        } else {
            mcpServerSpec.tools(toolSpec);
        }
    }

    protected ONode buildJsonSchema(FunctionTool functionTool) {
        ONode jsonSchema = new ONode();
        jsonSchema.set("$schema", (Object)"http://json-schema.org/draft-07/schema#");
        jsonSchema.setAll(ONode.loadStr((String)functionTool.inputSchema()));
        return jsonSchema;
    }
}

