/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import reactor.util.annotation.Nullable;

public final class Utils {
    public static boolean hasText(@Nullable String str) {
        return str != null && !Utils.isBlank(str);
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static URI resolveUri(URI baseUrl, String endpointUrl) {
        if (!Utils.hasText(endpointUrl)) {
            return baseUrl;
        }
        URI endpointUri = URI.create(endpointUrl);
        if (endpointUri.isAbsolute() && !Utils.isUnderBaseUri(baseUrl, endpointUri)) {
            throw new IllegalArgumentException("Absolute endpoint URL does not match the base URL.");
        }
        return baseUrl.resolve(endpointUri);
    }

    private static boolean isUnderBaseUri(URI baseUri, URI endpointUri) {
        if (!baseUri.getScheme().equals(endpointUri.getScheme()) || !baseUri.getAuthority().equals(endpointUri.getAuthority())) {
            return false;
        }
        URI normalizedBase = baseUri.normalize();
        URI normalizedEndpoint = endpointUri.normalize();
        String basePath = normalizedBase.getPath();
        String endpointPath = normalizedEndpoint.getPath();
        if (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return endpointPath.startsWith(basePath);
    }

    public static <T> List<T> asList(T ... ary) {
        if (ary == null) {
            return new ArrayList();
        }
        ArrayList list = new ArrayList(ary.length);
        Collections.addAll(list, ary);
        return list;
    }

    public static <T> Set<T> asSet(T ... ary) {
        if (ary == null) {
            return new HashSet();
        }
        HashSet list = new HashSet(ary.length);
        Collections.addAll(list, ary);
        return list;
    }

    public static Map asMap(Object ... keyValues) {
        if (keyValues == null || keyValues.length == 0) {
            return new LinkedHashMap();
        }
        if (keyValues.length % 2 != 0) {
            throw new IllegalArgumentException("keyValues.length % 2 != 0");
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(keyValues.length / 2);
        for (int i = 0; i < keyValues.length; i += 2) {
            map.put(keyValues[i], keyValues[i + 1]);
        }
        return map;
    }
}

