/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.ToolProvider;
import org.noear.solon.ai.mcp.client.McpClientProvider;
import org.noear.solon.ai.mcp.client.McpServerParameters;
import org.noear.solon.ai.mcp.server.prompt.FunctionPrompt;
import org.noear.solon.ai.mcp.server.prompt.PromptProvider;
import org.noear.solon.ai.mcp.server.resource.FunctionResource;
import org.noear.solon.ai.mcp.server.resource.ResourceProvider;
import org.noear.solon.core.util.Assert;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.net.http.HttpTimeout;

public class McpProviders
implements ToolProvider,
ResourceProvider,
PromptProvider,
Closeable {
    private final Map<String, McpClientProvider> providers;

    public McpProviders(Map<String, McpClientProvider> providers) {
        this.providers = providers;
    }

    public Map<String, McpClientProvider> getProviders() {
        return Collections.unmodifiableMap(this.providers);
    }

    public McpClientProvider getProvider(String key) {
        return this.providers.get(key);
    }

    public int size() {
        return this.providers.size();
    }

    @Override
    public void close() throws IOException {
        for (Map.Entry<String, McpClientProvider> entry : this.providers.entrySet()) {
            entry.getValue().close();
        }
    }

    public Collection<FunctionTool> getTools() {
        ArrayList<FunctionTool> tools = new ArrayList<FunctionTool>();
        for (Map.Entry<String, McpClientProvider> entry : this.providers.entrySet()) {
            tools.addAll(entry.getValue().getTools());
        }
        return tools;
    }

    @Override
    public Collection<FunctionPrompt> getPrompts() {
        ArrayList<FunctionPrompt> prompts = new ArrayList<FunctionPrompt>();
        for (Map.Entry<String, McpClientProvider> entry : this.providers.entrySet()) {
            prompts.addAll(entry.getValue().getPrompts());
        }
        return prompts;
    }

    @Override
    public Collection<FunctionResource> getResources() {
        ArrayList<FunctionResource> resources = new ArrayList<FunctionResource>();
        for (Map.Entry<String, McpClientProvider> entry : this.providers.entrySet()) {
            resources.addAll(entry.getValue().getResources());
        }
        return resources;
    }

    public static Map<String, McpServerParameters> parseMcpServers(String uri) throws IOException {
        Assert.notEmpty((String)uri, (String)"uri is empty");
        URL res = ResourceUtil.findResource((String)uri);
        String json = ResourceUtil.getResourceAsString((URL)res);
        ONode jsonDom = ONode.loadStr((String)json);
        return McpProviders.parseMcpServers(jsonDom);
    }

    public static Map<String, McpServerParameters> parseMcpServers(ONode configDom) throws IOException {
        Assert.notNull((Object)configDom, (String)"configDom is null");
        ONode mcpServersNode = configDom.getOrNull("mcpServers");
        if (mcpServersNode == null) {
            mcpServersNode = configDom;
        }
        Map mcpServers = (Map)mcpServersNode.toObject(new HashMap<String, McpServerParameters>(){}.getClass());
        return mcpServers;
    }

    public static McpProviders fromMcpServers(String uri) throws IOException {
        Map<String, McpServerParameters> mcpServers = McpProviders.parseMcpServers(uri);
        return McpProviders.fromMcpServers(mcpServers);
    }

    public static McpProviders fromMcpServers(ONode configDom) throws IOException {
        Map<String, McpServerParameters> mcpServers = McpProviders.parseMcpServers(configDom);
        return McpProviders.fromMcpServers(mcpServers);
    }

    public static McpProviders fromMcpServers(Map<String, McpServerParameters> mcpServers) throws IOException {
        HashMap<String, McpClientProvider> mcpClients = new HashMap<String, McpClientProvider>();
        if (Utils.isNotEmpty(mcpServers)) {
            for (Map.Entry<String, McpServerParameters> kv : mcpServers.entrySet()) {
                McpClientProvider mcpClient = McpProviders.fromMcpServer(kv.getValue());
                mcpClients.put(kv.getKey(), mcpClient);
            }
        }
        return new McpProviders(mcpClients);
    }

    public static McpClientProvider fromMcpServer(McpServerParameters serverParameters) throws IOException {
        Assert.notNull((Object)serverParameters, (String)"serverParameters is null");
        String type = Utils.valueOr((String[])new String[]{serverParameters.getType(), serverParameters.getTransport()});
        if (Utils.isEmpty((String)type)) {
            if (Utils.isNotEmpty((String)serverParameters.getUrl())) {
                throw new IllegalArgumentException("The type or transport  is required");
            }
            type = "stdio";
        }
        McpClientProvider.Builder builder = McpClientProvider.builder();
        builder.channel(type);
        if ("stdio".equalsIgnoreCase(type)) {
            builder.command(serverParameters.getCommand());
            builder.args(serverParameters.getArgs());
            builder.env(serverParameters.getEnv());
        } else {
            builder.apiUrl(serverParameters.getUrl());
            builder.headerSet(serverParameters.getEnv());
            builder.headerSet(serverParameters.getHeaders());
            if (serverParameters.getTimeout() != null) {
                builder.httpTimeout(HttpTimeout.of((int)((int)serverParameters.getTimeout().getSeconds())));
                builder.requestTimeout(serverParameters.getTimeout());
                builder.initializationTimeout(serverParameters.getTimeout());
            }
        }
        return builder.build();
    }
}

