/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.server.manager;

import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.mcp.exception.McpException;
import org.noear.solon.ai.mcp.server.McpServerContext;
import org.noear.solon.ai.mcp.server.McpServerProperties;
import org.noear.solon.ai.mcp.server.manager.McpServerManager;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextHolder;

public class ToolMcpServerManager
implements McpServerManager<FunctionTool> {
    private final Map<String, FunctionTool> toolsMap = new ConcurrentHashMap<String, FunctionTool>();

    @Override
    public int count() {
        return this.toolsMap.size();
    }

    @Override
    public Collection<FunctionTool> all() {
        return this.toolsMap.values();
    }

    @Override
    public boolean contains(String toolName) {
        return this.toolsMap.containsKey(toolName);
    }

    @Override
    public void remove(McpSyncServer server, String toolName) {
        if (server != null) {
            server.removeTool(toolName);
            this.toolsMap.remove(toolName);
        }
    }

    @Override
    public void add(McpSyncServer server, McpServer.SyncSpecification mcpServerSpec, McpServerProperties mcpServerProps, FunctionTool functionTool) {
        try {
            this.toolsMap.put(functionTool.name(), functionTool);
            String inSchemaJson = this.buildJsonSchema(functionTool).toJson();
            McpSchema.ToolAnnotations toolAnnotations = new McpSchema.ToolAnnotations();
            toolAnnotations.setReturnDirect(functionTool.returnDirect());
            McpSchema.Tool.Builder toolBuilder = McpSchema.Tool.builder().name(functionTool.name()).title(functionTool.title()).description(functionTool.description()).annotations(toolAnnotations).inputSchema(inSchemaJson);
            if (mcpServerProps.isEnableOutputSchema() && Utils.isNotEmpty((String)functionTool.outputSchema())) {
                toolBuilder.outputSchema(functionTool.outputSchema());
            }
            McpServerFeatures.SyncToolSpecification toolSpec = new McpServerFeatures.SyncToolSpecification(toolBuilder.build(), (exchange, request) -> {
                try {
                    ContextHolder.currentSet((Context)new McpServerContext((McpSyncServerExchange)exchange));
                    String rst = functionTool.handle(request);
                    if (mcpServerProps.isEnableOutputSchema() && Utils.isNotEmpty((String)functionTool.outputSchema())) {
                        Map map = (Map)ONode.load((Object)rst).toObject(Map.class);
                        McpSchema.CallToolResult callToolResult = new McpSchema.CallToolResult(Arrays.asList(new McpSchema.TextContent(rst)), false, map);
                        return callToolResult;
                    }
                    McpSchema.CallToolResult callToolResult = new McpSchema.CallToolResult(Arrays.asList(new McpSchema.TextContent(rst)), (Boolean)false);
                    return callToolResult;
                }
                catch (Throwable ex) {
                    ex = Utils.throwableUnwrap((Throwable)ex);
                    throw new McpException(ex.getMessage(), ex);
                }
                finally {
                    ContextHolder.currentRemove();
                }
            });
            if (server != null) {
                server.addTool(toolSpec);
            } else {
                mcpServerSpec.tools(toolSpec);
            }
        }
        catch (Throwable ex) {
            throw new McpException("Tool add failed, tool: " + functionTool.name(), ex);
        }
    }

    protected ONode buildJsonSchema(FunctionTool functionTool) {
        ONode jsonSchema = new ONode();
        jsonSchema.set("$schema", (Object)"http://json-schema.org/draft-07/schema#");
        jsonSchema.setAll(ONode.loadStr((String)functionTool.inputSchema()));
        return jsonSchema;
    }
}

