/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.client;

import io.modelcontextprotocol.spec.McpSchema;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.noear.solon.ai.mcp.client.McpServerParameters;
import org.noear.solon.ai.util.ProxyDesc;
import org.noear.solon.net.http.HttpSslSupplier;
import org.noear.solon.net.http.HttpTimeout;
import reactor.core.publisher.Mono;

public class McpClientProperties {
    private String name = "Solon-Ai-Mcp-Client";
    private String version = "1.0.0";
    private String channel;
    @Deprecated
    private String apiUrl;
    private String url;
    private String apiKey;
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private Duration timeout = Duration.ofSeconds(30L);
    private HttpTimeout httpTimeout;
    protected ProxyDesc httpProxy;
    private Proxy httpProxyInstance;
    private HttpSslSupplier httpSsl;
    private Duration requestTimeout;
    private Duration initializationTimeout;
    private Duration heartbeatInterval = Duration.ofSeconds(15L);
    private int cacheSeconds = 30;
    @Deprecated
    private McpServerParameters serverParameters;
    private String command;
    private List<String> args = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private transient Function<List<McpSchema.Tool>, Mono<Void>> toolsChangeConsumer;
    private transient Function<List<McpSchema.Resource>, Mono<Void>> resourcesChangeConsumer;
    private transient Function<List<McpSchema.ResourceContents>, Mono<Void>> resourcesUpdateConsumer;
    private transient Function<List<McpSchema.Prompt>, Mono<Void>> promptsChangeConsumer;

    public McpClientProperties() {
    }

    public McpClientProperties(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Deprecated
    public String getApiUrl() {
        return this.apiUrl;
    }

    @Deprecated
    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getUrl() {
        if (this.apiUrl != null) {
            return this.apiUrl;
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.apiUrl = null;
        this.url = url;
    }

    @Deprecated
    public String getApiKey() {
        return this.apiKey;
    }

    @Deprecated
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public HttpTimeout getHttpTimeout() {
        return this.httpTimeout;
    }

    public void setHttpTimeout(HttpTimeout httpTimeout) {
        this.httpTimeout = httpTimeout;
    }

    public Proxy getHttpProxy() {
        if (this.httpProxyInstance == null && this.httpProxy != null) {
            this.httpProxyInstance = new Proxy(this.httpProxy.type, new InetSocketAddress(this.httpProxy.host, this.httpProxy.port));
        }
        return this.httpProxyInstance;
    }

    public void setHttpProxy(Proxy httpProxy) {
        this.httpProxyInstance = httpProxy;
        this.httpProxy = null;
    }

    public void setHttpSsl(HttpSslSupplier httpSslSupplier) {
        this.httpSsl = httpSslSupplier;
    }

    public HttpSslSupplier getHttpSsl() {
        return this.httpSsl;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Duration getInitializationTimeout() {
        return this.initializationTimeout;
    }

    public void setInitializationTimeout(Duration initializationTimeout) {
        this.initializationTimeout = initializationTimeout;
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public int getCacheSeconds() {
        return this.cacheSeconds;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheSeconds = cacheSeconds;
    }

    @Deprecated
    public McpServerParameters getServerParameters() {
        return this.serverParameters;
    }

    @Deprecated
    public void setServerParameters(McpServerParameters serverParameters) {
        this.serverParameters = serverParameters;
    }

    public String getCommand() {
        if (this.serverParameters != null) {
            return this.serverParameters.getCommand();
        }
        return this.command;
    }

    public void setCommand(String command) {
        this.serverParameters = null;
        this.command = command;
    }

    public List<String> getArgs() {
        if (this.serverParameters != null) {
            return this.serverParameters.getArgs();
        }
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.serverParameters = null;
        this.args = args;
    }

    public Map<String, String> getEnv() {
        if (this.serverParameters != null) {
            return this.serverParameters.getEnv();
        }
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.serverParameters = null;
        this.env = env;
    }

    public void setToolsChangeConsumer(Function<List<McpSchema.Tool>, Mono<Void>> toolsChangeConsumer) {
        this.toolsChangeConsumer = toolsChangeConsumer;
    }

    public Function<List<McpSchema.Tool>, Mono<Void>> getToolsChangeConsumer() {
        return this.toolsChangeConsumer;
    }

    public void setResourcesChangeConsumer(Function<List<McpSchema.Resource>, Mono<Void>> resourcesChangeConsumer) {
        this.resourcesChangeConsumer = resourcesChangeConsumer;
    }

    public Function<List<McpSchema.Resource>, Mono<Void>> getResourcesChangeConsumer() {
        return this.resourcesChangeConsumer;
    }

    public void setResourcesUpdateConsumer(Function<List<McpSchema.ResourceContents>, Mono<Void>> resourcesUpdateConsumer) {
        this.resourcesUpdateConsumer = resourcesUpdateConsumer;
    }

    public Function<List<McpSchema.ResourceContents>, Mono<Void>> getResourcesUpdateConsumer() {
        return this.resourcesUpdateConsumer;
    }

    public void setPromptsChangeConsumer(Function<List<McpSchema.Prompt>, Mono<Void>> promptsChangeConsumer) {
        this.promptsChangeConsumer = promptsChangeConsumer;
    }

    public Function<List<McpSchema.Prompt>, Mono<Void>> getPromptsChangeConsumer() {
        return this.promptsChangeConsumer;
    }

    public void prepare() {
        if (this.timeout == null) {
            this.timeout = Duration.ofSeconds(30L);
        }
        if (this.httpTimeout == null) {
            this.httpTimeout = HttpTimeout.of((int)((int)this.timeout.getSeconds()));
        }
        if (this.initializationTimeout == null) {
            this.initializationTimeout = this.timeout;
        }
        if (this.requestTimeout == null) {
            this.requestTimeout = this.timeout;
        }
    }

    public String toString() {
        return "McpClientProperties{name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", channel='" + this.channel + '\'' + ", apiUrl='" + this.apiUrl + '\'' + ", apiKey='" + this.apiKey + '\'' + ", headers=" + this.headers + ", timeout=" + this.timeout + ", httpTimeout=" + this.httpTimeout + ", httpProxy=" + this.getHttpProxy() + ", requestTimeout=" + this.requestTimeout + ", initializationTimeout=" + this.initializationTimeout + ", heartbeatInterval=" + this.heartbeatInterval + ", command='" + this.command + '\'' + ", args=" + this.args + ", env=" + this.env + '}';
    }
}

