/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.client;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.transport.ServerParameters;
import io.modelcontextprotocol.client.transport.StdioClientTransport;
import io.modelcontextprotocol.client.transport.WebRxSseClientTransport;
import io.modelcontextprotocol.client.transport.WebRxStreamableHttpTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiMedia;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.FunctionToolDesc;
import org.noear.solon.ai.chat.tool.ToolProvider;
import org.noear.solon.ai.mcp.client.McpClientProperties;
import org.noear.solon.ai.mcp.client.McpProviders;
import org.noear.solon.ai.mcp.client.McpServerParameters;
import org.noear.solon.ai.mcp.exception.McpException;
import org.noear.solon.ai.mcp.server.prompt.FunctionPrompt;
import org.noear.solon.ai.mcp.server.prompt.FunctionPromptDesc;
import org.noear.solon.ai.mcp.server.prompt.PromptProvider;
import org.noear.solon.ai.mcp.server.resource.FunctionResource;
import org.noear.solon.ai.mcp.server.resource.FunctionResourceDesc;
import org.noear.solon.ai.mcp.server.resource.ResourceProvider;
import org.noear.solon.ai.media.Audio;
import org.noear.solon.ai.media.Image;
import org.noear.solon.ai.media.Text;
import org.noear.solon.core.Props;
import org.noear.solon.core.util.Assert;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.data.cache.LocalCacheService;
import org.noear.solon.data.util.StringMutexLock;
import org.noear.solon.net.http.HttpSslSupplier;
import org.noear.solon.net.http.HttpTimeout;
import org.noear.solon.net.http.HttpUtilsBuilder;
import reactor.core.publisher.Mono;

public class McpClientProvider
implements ToolProvider,
ResourceProvider,
PromptProvider,
Closeable {
    private final ReentrantLock LOCKER = new ReentrantLock();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final McpClientProperties clientProps;
    private ScheduledExecutorService heartbeatExecutor;
    private McpAsyncClient client;
    private McpSchema.LoggingLevel loggingLevel = McpSchema.LoggingLevel.INFO;
    private static final String cache_prefix_tools = "getTools:";
    private static final String cache_prefix_resource = "getResources:";
    private static final String cache_prefix_resource_templates = "getResourceTemplates:";
    private static final String cache_prefix_prompts = "getPrompts:";
    private LocalCacheService cacheService = new LocalCacheService();
    private final StringMutexLock cacheLocker = new StringMutexLock();

    public McpClientProvider(Properties clientProps) {
        this((McpClientProperties)Props.from((Properties)clientProps).bindTo((Object)new McpClientProperties()));
    }

    public McpClientProvider(String apiUrl) {
        this(new McpClientProperties(apiUrl));
    }

    public McpClientProvider(McpClientProperties clientProps) {
        if (Utils.isEmpty((String)clientProps.getChannel())) {
            throw new IllegalArgumentException("The channel is required");
        }
        clientProps.prepare();
        if ("stdio".equals(clientProps.getChannel())) {
            if (clientProps.getCommand() == null) {
                throw new IllegalArgumentException("Command is null!");
            }
        } else if (Utils.isEmpty((String)clientProps.getUrl())) {
            throw new IllegalArgumentException("Url is empty!");
        }
        this.clientProps = clientProps;
        this.heartbeatHandle();
    }

    public void clearCache() {
        this.cacheService.clear();
    }

    private McpAsyncClient buildClient() {
        McpClientTransport clientTransport;
        if ("stdio".equals(this.clientProps.getChannel())) {
            clientTransport = new StdioClientTransport(ServerParameters.builder(this.clientProps.getCommand()).args(this.clientProps.getArgs()).env(this.clientProps.getEnv()).build());
        } else {
            URI url = URI.create(this.clientProps.getUrl());
            String baseUri = url.getScheme() + "://" + url.getAuthority();
            String endpoint = null;
            endpoint = Utils.isEmpty((String)url.getRawQuery()) ? url.getRawPath() : url.getRawPath() + "?" + url.getRawQuery();
            if (Utils.isEmpty((String)endpoint)) {
                throw new IllegalArgumentException("SseEndpoint is empty!");
            }
            HttpUtilsBuilder webBuilder = new HttpUtilsBuilder();
            webBuilder.baseUri(baseUri);
            if (Utils.isNotEmpty((String)this.clientProps.getApiKey())) {
                webBuilder.headerSet("Authorization", "Bearer " + this.clientProps.getApiKey());
            }
            this.clientProps.getHeaders().forEach((k, v) -> webBuilder.headerSet(k, v));
            if (this.clientProps.getHttpTimeout() != null) {
                webBuilder.timeout(this.clientProps.getHttpTimeout());
            }
            if (this.clientProps.getHttpProxy() != null) {
                webBuilder.proxy(this.clientProps.getHttpProxy());
            }
            if (this.clientProps.getHttpSsl() != null) {
                webBuilder.ssl(this.clientProps.getHttpSsl());
            }
            clientTransport = "sse".equals(this.clientProps.getChannel()) ? WebRxSseClientTransport.builder(webBuilder).sseEndpoint(endpoint).build() : WebRxStreamableHttpTransport.builder(webBuilder).endpoint(endpoint).build();
        }
        return McpClient.async(clientTransport).clientInfo(new McpSchema.Implementation(this.clientProps.getName(), this.clientProps.getVersion())).requestTimeout(this.clientProps.getRequestTimeout()).initializationTimeout(this.clientProps.getInitializationTimeout()).loggingConsumer(logging -> {
            logging.setLevel(this.loggingLevel);
            return Mono.empty();
        }).toolsChangeConsumer(this::onToolsChange).resourcesChangeConsumer(this::onResourcesChange).resourcesUpdateConsumer(this::onResourcesUpdate).promptsChangeConsumer(this::onPromptsChange).build();
    }

    private Mono<Void> onToolsChange(List<McpSchema.Tool> tools) {
        this.cacheService.remove(cache_prefix_tools + null);
        if (this.clientProps.getToolsChangeConsumer() != null) {
            return this.clientProps.getToolsChangeConsumer().apply(tools);
        }
        return Mono.empty();
    }

    private Mono<Void> onResourcesChange(List<McpSchema.Resource> resources) {
        this.cacheService.remove(cache_prefix_resource + null);
        this.cacheService.remove(cache_prefix_resource_templates + null);
        if (this.clientProps.getResourcesChangeConsumer() != null) {
            return this.clientProps.getResourcesChangeConsumer().apply(resources);
        }
        return Mono.empty();
    }

    private Mono<Void> onResourcesUpdate(List<McpSchema.ResourceContents> resourceContents) {
        this.cacheService.remove(cache_prefix_resource + null);
        this.cacheService.remove(cache_prefix_resource_templates + null);
        if (this.clientProps.getResourcesUpdateConsumer() != null) {
            return this.clientProps.getResourcesUpdateConsumer().apply(resourceContents);
        }
        return Mono.empty();
    }

    private Mono<Void> onPromptsChange(List<McpSchema.Prompt> prompts) {
        this.cacheService.remove(cache_prefix_prompts + null);
        if (this.clientProps.getPromptsChangeConsumer() != null) {
            return this.clientProps.getPromptsChangeConsumer().apply(prompts);
        }
        return Mono.empty();
    }

    public McpAsyncClient getClient() {
        this.LOCKER.lock();
        try {
            if (this.isClosed.get()) {
                throw new IllegalStateException("The current status has been closed.");
            }
            this.isStarted.set(true);
            if (this.client == null) {
                this.client = this.buildClient();
            }
            if (!this.client.isInitialized()) {
                this.client.initialize().block();
            }
            McpAsyncClient mcpAsyncClient = this.client;
            return mcpAsyncClient;
        }
        finally {
            this.LOCKER.unlock();
        }
    }

    public void setLoggingLevel(McpSchema.LoggingLevel loggingLevel) {
        if (loggingLevel != null) {
            this.loggingLevel = loggingLevel;
        }
    }

    private void heartbeatHandle() {
        if (this.clientProps.getHeartbeatInterval() == null) {
            return;
        }
        if (this.clientProps.getHeartbeatInterval().getSeconds() < 5L) {
            return;
        }
        if (this.heartbeatExecutor == null) {
            this.heartbeatExecutor = Executors.newSingleThreadScheduledExecutor();
        }
        this.heartbeatHandleDo();
    }

    private void heartbeatHandleDo() {
        if (this.heartbeatExecutor == null) {
            return;
        }
        this.heartbeatExecutor.schedule(() -> {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (!this.isClosed.get()) {
                if (this.isStarted.get()) {
                    RunUtil.runAndTry(() -> {
                        try {
                            this.getClient().ping().block();
                        }
                        catch (Throwable ex) {
                            this.reset();
                        }
                    });
                }
                this.heartbeatHandleDo();
            }
        }, this.clientProps.getHeartbeatInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.LOCKER.lock();
        try {
            if (!this.isClosed.get()) {
                this.isClosed.set(true);
                this.isStarted.set(false);
                if (this.heartbeatExecutor != null) {
                    this.heartbeatExecutor.shutdownNow();
                    this.heartbeatExecutor = null;
                }
                this.reset();
            }
        }
        finally {
            this.LOCKER.unlock();
        }
    }

    public void reopen() {
        this.LOCKER.lock();
        try {
            if (this.isClosed.get()) {
                this.isClosed.set(false);
                this.getClient();
                this.heartbeatHandle();
            }
        }
        finally {
            this.LOCKER.unlock();
        }
    }

    private void reset() {
        this.LOCKER.lock();
        try {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
        finally {
            this.LOCKER.unlock();
        }
    }

    public Text callToolAsText(String name, Map<String, Object> args) {
        McpSchema.CallToolResult result = this.callTool(name, args);
        if (Utils.isEmpty(result.getContent())) {
            return null;
        }
        McpSchema.Content tmp = result.getContent().get(0);
        if (tmp instanceof McpSchema.TextContent) {
            return Text.of((boolean)false, (String)((McpSchema.TextContent)tmp).getText());
        }
        throw new IllegalArgumentException("The tool result content is not a text content.");
    }

    public Image callToolAsImage(String name, Map<String, Object> args) {
        McpSchema.CallToolResult result = this.callTool(name, args);
        if (Utils.isEmpty(result.getContent())) {
            return null;
        }
        McpSchema.Content tmp = result.getContent().get(0);
        if (tmp instanceof McpSchema.ImageContent) {
            McpSchema.ImageContent imageContent = (McpSchema.ImageContent)tmp;
            return Image.ofBase64((String)imageContent.getData(), (String)imageContent.getMimeType());
        }
        throw new IllegalArgumentException("The tool result content is not a image content.");
    }

    public Audio callToolAsAudio(String name, Map<String, Object> args) {
        McpSchema.CallToolResult result = this.callTool(name, args);
        if (Utils.isEmpty(result.getContent())) {
            return null;
        }
        McpSchema.Content tmp = result.getContent().get(0);
        if (tmp instanceof McpSchema.AudioContent) {
            McpSchema.AudioContent audioContent = (McpSchema.AudioContent)tmp;
            return Audio.ofBase64((String)audioContent.getData(), (String)audioContent.getMimeType());
        }
        throw new IllegalArgumentException("The tool result content is not a audio content.");
    }

    public McpSchema.CallToolResult callTool(String name, Map<String, Object> args) {
        try {
            McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest(name, args);
            McpSchema.CallToolResult result = (McpSchema.CallToolResult)this.getClient().callTool(callToolRequest).block();
            if (result.getIsError() == null || !result.getIsError().booleanValue()) {
                return result;
            }
            if (Utils.isEmpty(result.getContent())) {
                throw new McpException("Call Toll Failed");
            }
            throw new McpException(result.getContent().get(0).toString());
        }
        catch (RuntimeException ex) {
            this.reset();
            throw ex;
        }
    }

    public Text readResourceAsText(String uri) {
        McpSchema.ReadResourceResult result = this.readResource(uri);
        if (Utils.isEmpty(result.getContents())) {
            return null;
        }
        McpSchema.ResourceContents tmp = result.getContents().get(0);
        if (tmp instanceof McpSchema.TextResourceContents) {
            McpSchema.TextResourceContents textContents = (McpSchema.TextResourceContents)tmp;
            return Text.of((boolean)false, (String)textContents.getText(), (String)textContents.getMimeType());
        }
        McpSchema.BlobResourceContents blobContents = (McpSchema.BlobResourceContents)tmp;
        return Text.of((boolean)true, (String)blobContents.getBlob(), (String)blobContents.getMimeType());
    }

    public McpSchema.ReadResourceResult readResource(String uri) {
        try {
            McpSchema.ReadResourceRequest callToolRequest = new McpSchema.ReadResourceRequest(uri);
            McpSchema.ReadResourceResult result = (McpSchema.ReadResourceResult)this.getClient().readResource(callToolRequest).block();
            if (Utils.isEmpty(result.getContents())) {
                throw new McpException("Read resource Failed");
            }
            return result;
        }
        catch (RuntimeException ex) {
            this.reset();
            throw ex;
        }
    }

    public List<ChatMessage> getPromptAsMessages(String name, Map<String, Object> args) {
        ArrayList<ChatMessage> tmp = new ArrayList<ChatMessage>();
        McpSchema.GetPromptResult result = this.getPrompt(name, args);
        for (McpSchema.PromptMessage pm : result.getMessages()) {
            McpSchema.Content content = pm.getContent();
            if (pm.getRole() == McpSchema.Role.ASSISTANT) {
                if (!(content instanceof McpSchema.TextContent)) continue;
                tmp.add((ChatMessage)ChatMessage.ofAssistant((String)((McpSchema.TextContent)content).getText()));
                continue;
            }
            if (content instanceof McpSchema.TextContent) {
                tmp.add((ChatMessage)ChatMessage.ofUser((String)((McpSchema.TextContent)content).getText()));
                continue;
            }
            if (!(content instanceof McpSchema.ImageContent)) continue;
            McpSchema.ImageContent imageContent = (McpSchema.ImageContent)content;
            String contentData = imageContent.getData();
            if (contentData.contains("://")) {
                tmp.add((ChatMessage)ChatMessage.ofUser((AiMedia)Image.ofUrl((String)contentData)));
                continue;
            }
            tmp.add((ChatMessage)ChatMessage.ofUser((AiMedia)Image.ofBase64((String)contentData, (String)imageContent.getMimeType())));
        }
        return tmp;
    }

    public McpSchema.GetPromptResult getPrompt(String name, Map<String, Object> args) {
        try {
            McpSchema.GetPromptRequest callToolRequest = new McpSchema.GetPromptRequest(name, args);
            McpSchema.GetPromptResult result = (McpSchema.GetPromptResult)this.getClient().getPrompt(callToolRequest).block();
            if (Utils.isEmpty(result.getMessages())) {
                throw new McpException("Read resource Failed");
            }
            return result;
        }
        catch (RuntimeException ex) {
            this.reset();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getByCache(String key, Type type, Supplier<T> supplier) {
        if (this.clientProps.getCacheSeconds() > 0) {
            this.cacheLocker.lock(key);
            try {
                Object object = this.cacheService.getOrStore(key, type, this.clientProps.getCacheSeconds(), supplier);
                return (T)object;
            }
            finally {
                this.cacheLocker.unlock(key);
            }
        }
        return supplier.get();
    }

    public Collection<FunctionTool> getTools() {
        return this.getTools(null);
    }

    public Collection<FunctionTool> getTools(String cursor) {
        return this.getByCache(cache_prefix_tools + cursor, (Type)((Object)Collection.class), () -> this.getToolsDo(cursor));
    }

    private Collection<FunctionTool> getToolsDo(String cursor) {
        ArrayList<FunctionTool> toolList = new ArrayList<FunctionTool>();
        McpSchema.ListToolsResult result = null;
        result = cursor == null ? (McpSchema.ListToolsResult)this.getClient().listTools().block() : (McpSchema.ListToolsResult)this.getClient().listTools(cursor).block();
        for (McpSchema.Tool tool : result.getTools()) {
            String name = tool.getName();
            String title = tool.getTitle();
            String description = tool.getDescription();
            Boolean returnDirect = tool.getAnnotations() == null ? false : tool.getAnnotations().getReturnDirect();
            String inputSchema = ONode.load((Object)tool.getInputSchema()).toJson();
            String outputSchema = tool.getOutputSchema() == null ? null : ONode.load(tool.getOutputSchema()).toJson();
            FunctionToolDesc functionRefer = new FunctionToolDesc(name, title, description, returnDirect, inputSchema, outputSchema, args -> this.callToolAsText(name, args).getContent());
            toolList.add((FunctionTool)functionRefer);
        }
        return toolList;
    }

    @Override
    public Collection<FunctionResource> getResources() {
        return this.getResources(null);
    }

    public Collection<FunctionResource> getResources(String cursor) {
        return this.getByCache(cache_prefix_resource + cursor, (Type)((Object)Collection.class), () -> this.getResourcesDo(cursor));
    }

    private Collection<FunctionResource> getResourcesDo(String cursor) {
        ArrayList<FunctionResource> resourceList = new ArrayList<FunctionResource>();
        McpSchema.ListResourcesResult result = null;
        result = cursor == null ? (McpSchema.ListResourcesResult)this.getClient().listResources().block() : (McpSchema.ListResourcesResult)this.getClient().listResources(cursor).block();
        for (McpSchema.Resource resource : result.getResources()) {
            String name = resource.getName();
            String uri = resource.getUri();
            String description = resource.getDescription();
            FunctionResourceDesc functionDesc = new FunctionResourceDesc(name);
            functionDesc.description(description);
            functionDesc.uri(uri);
            functionDesc.mimeType(resource.getMimeType());
            functionDesc.doHandle(reqUri -> this.readResourceAsText((String)reqUri));
            resourceList.add(functionDesc);
        }
        return resourceList;
    }

    public Collection<FunctionResource> getResourceTemplates() {
        return this.getResourceTemplates(null);
    }

    public Collection<FunctionResource> getResourceTemplates(String cursor) {
        return this.getByCache(cache_prefix_resource_templates + cursor, (Type)((Object)Collection.class), () -> this.getResourceTemplatesDo(cursor));
    }

    private Collection<FunctionResource> getResourceTemplatesDo(String cursor) {
        ArrayList<FunctionResource> resourceList = new ArrayList<FunctionResource>();
        McpSchema.ListResourceTemplatesResult result = null;
        result = cursor == null ? (McpSchema.ListResourceTemplatesResult)this.getClient().listResourceTemplates().block() : (McpSchema.ListResourceTemplatesResult)this.getClient().listResourceTemplates(cursor).block();
        for (McpSchema.ResourceTemplate resource : result.getResourceTemplates()) {
            String name = resource.getName();
            String uriTemplate = resource.getUriTemplate();
            String description = resource.getDescription();
            FunctionResourceDesc functionDesc = new FunctionResourceDesc(name);
            functionDesc.description(description);
            functionDesc.uri(uriTemplate);
            functionDesc.mimeType(resource.getMimeType());
            functionDesc.doHandle(reqUri -> this.readResourceAsText((String)reqUri));
            resourceList.add(functionDesc);
        }
        return resourceList;
    }

    @Override
    public Collection<FunctionPrompt> getPrompts() {
        return this.getPrompts(null);
    }

    public Collection<FunctionPrompt> getPrompts(String cursor) {
        return this.getByCache(cache_prefix_prompts + cursor, (Type)((Object)Collection.class), () -> this.getPromptsDo(cursor));
    }

    private Collection<FunctionPrompt> getPromptsDo(String cursor) {
        ArrayList<FunctionPrompt> promptList = new ArrayList<FunctionPrompt>();
        McpSchema.ListPromptsResult result = null;
        result = cursor == null ? (McpSchema.ListPromptsResult)this.getClient().listPrompts().block() : (McpSchema.ListPromptsResult)this.getClient().listPrompts(cursor).block();
        for (McpSchema.Prompt prompt : result.getPrompts()) {
            String name = prompt.getName();
            String description = prompt.getDescription();
            FunctionPromptDesc functionDesc = new FunctionPromptDesc(name);
            functionDesc.description(description);
            for (McpSchema.PromptArgument p1 : prompt.getArguments()) {
                functionDesc.paramAdd(p1.getName(), p1.getRequired(), p1.getDescription());
            }
            functionDesc.doHandle(args -> this.getPromptAsMessages(name, (Map<String, Object>)args));
            promptList.add(functionDesc);
        }
        return promptList;
    }

    @Deprecated
    public static Map<String, McpClientProvider> fromMcpServers(String uri) throws IOException {
        return McpProviders.fromMcpServers(uri).getProviders();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private McpClientProperties props = new McpClientProperties();

        public Builder name(String name) {
            this.props.setName(name);
            return this;
        }

        public Builder version(String version) {
            this.props.setVersion(version);
            return this;
        }

        public Builder channel(String channel) {
            this.props.setChannel(channel);
            return this;
        }

        public Builder requestTimeout(Duration requestTimeout) {
            this.props.setRequestTimeout(requestTimeout);
            return this;
        }

        public Builder initializationTimeout(Duration initializationTimeout) {
            this.props.setInitializationTimeout(initializationTimeout);
            return this;
        }

        public Builder heartbeatInterval(Duration heartbeatInterval) {
            this.props.setHeartbeatInterval(heartbeatInterval);
            return this;
        }

        public Builder cacheSeconds(int cacheSeconds) {
            this.props.setCacheSeconds(cacheSeconds);
            return this;
        }

        public Builder url(String url) {
            this.props.setApiUrl(url);
            return this;
        }

        public Builder header(String name, String value) {
            this.props.getHeaders().put(name, value);
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            if (Utils.isNotEmpty(headers)) {
                this.props.getHeaders().putAll(headers);
            }
            return this;
        }

        public Builder timeout(Duration duration) {
            this.props.setTimeout(duration);
            return this;
        }

        public Builder httpTimeout(HttpTimeout httpTimeout) {
            this.props.setHttpTimeout(httpTimeout);
            return this;
        }

        public Builder httpProxy(Proxy httpProxy) {
            this.props.setHttpProxy(httpProxy);
            return this;
        }

        public Builder httpProxy(String host, int port) {
            return this.httpProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port)));
        }

        public Builder httpSsl(HttpSslSupplier httpSslSupplier) {
            this.props.setHttpSsl(httpSslSupplier);
            return this;
        }

        public Builder command(String command) {
            Assert.notNull((Object)command, (String)"The command can not be null");
            this.props.setCommand(command);
            return this;
        }

        public Builder args(String ... args) {
            Assert.notNull((Object)args, (String)"The args can not be null");
            this.props.setArgs(Arrays.asList(args));
            return this;
        }

        public Builder args(List<String> args) {
            Assert.notNull(args, (String)"The args can not be null");
            this.props.setArgs(new ArrayList<String>(args));
            return this;
        }

        public Builder arg(String arg) {
            Assert.notNull((Object)arg, (String)"The arg can not be null");
            this.props.getArgs().add(arg);
            return this;
        }

        public Builder env(Map<String, String> env) {
            if (Utils.isNotEmpty(env)) {
                this.props.getEnv().putAll(env);
            }
            return this;
        }

        public Builder addEnvVar(String key, String value) {
            Assert.notNull((Object)key, (String)"The key can not be null");
            Assert.notNull((Object)value, (String)"The value can not be null");
            this.props.getEnv().put(key, value);
            return this;
        }

        @Deprecated
        public Builder apiUrl(String apiUrl) {
            this.props.setApiUrl(apiUrl);
            return this;
        }

        @Deprecated
        public Builder apiKey(String apiKey) {
            this.props.setApiKey(apiKey);
            return this;
        }

        @Deprecated
        public Builder headerSet(String name, String value) {
            this.props.getHeaders().put(name, value);
            return this;
        }

        @Deprecated
        public Builder headerSet(Map<String, String> headers) {
            if (Utils.isNotEmpty(headers)) {
                this.props.getHeaders().putAll(headers);
            }
            return this;
        }

        @Deprecated
        public Builder serverParameters(McpServerParameters serverParameters) {
            Assert.notNull((Object)serverParameters, (String)"The serverParameters can not be null");
            this.props.setCommand(serverParameters.getCommand());
            this.props.setArgs(serverParameters.getArgs());
            this.props.setEnv(serverParameters.getEnv());
            return this;
        }

        public Builder toolsChangeConsumer(Function<List<McpSchema.Tool>, Mono<Void>> toolsChangeConsumer) {
            this.props.setToolsChangeConsumer(toolsChangeConsumer);
            return this;
        }

        public Builder resourcesChangeConsumer(Function<List<McpSchema.Resource>, Mono<Void>> resourcesChangeConsumer) {
            this.props.setResourcesChangeConsumer(resourcesChangeConsumer);
            return this;
        }

        public Builder resourcesUpdateConsumer(Function<List<McpSchema.ResourceContents>, Mono<Void>> resourcesUpdateConsumer) {
            this.props.setResourcesUpdateConsumer(resourcesUpdateConsumer);
            return this;
        }

        public Builder promptsChangeConsumer(Function<List<McpSchema.Prompt>, Mono<Void>> promptsChangeConsumer) {
            this.props.setPromptsChangeConsumer(promptsChangeConsumer);
            return this;
        }

        public McpClientProvider build() {
            return new McpClientProvider(this.props);
        }
    }
}

