/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.repository;

import io.qdrant.client.PointIdFactory;
import io.qdrant.client.QdrantClient;
import io.qdrant.client.QueryFactory;
import io.qdrant.client.ValueFactory;
import io.qdrant.client.VectorsFactory;
import io.qdrant.client.WithPayloadSelectorFactory;
import io.qdrant.client.WithVectorsSelectorFactory;
import io.qdrant.client.grpc.Collections;
import io.qdrant.client.grpc.JsonWithInt;
import io.qdrant.client.grpc.Points;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.embedding.EmbeddingModel;
import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.rag.RepositoryLifecycle;
import org.noear.solon.ai.rag.RepositoryStorable;
import org.noear.solon.ai.rag.repository.qdrant.FilterTransformer;
import org.noear.solon.ai.rag.repository.qdrant.QdrantValueUtil;
import org.noear.solon.ai.rag.util.ListUtil;
import org.noear.solon.ai.rag.util.QueryCondition;
import org.noear.solon.ai.rag.util.SimilarityUtil;
import org.noear.solon.expression.Expression;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class QdrantRepository
implements RepositoryStorable,
RepositoryLifecycle {
    private final Builder config;

    private QdrantRepository(Builder config) {
        this.config = config;
        this.initRepository();
    }

    public void initRepository() {
        try {
            boolean exists = (Boolean)this.config.client.collectionExistsAsync(this.config.collectionName).get();
            if (!exists) {
                int dimensions = this.config.embeddingModel.dimensions();
                this.config.client.createCollectionAsync(this.config.collectionName, Collections.VectorParams.newBuilder().setSize((long)dimensions).setDistance(Collections.Distance.Cosine).build()).get();
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to initialize Qdrant repository", e);
        }
    }

    public void dropRepository() {
        try {
            this.config.client.deleteCollectionAsync(this.config.collectionName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to drop Qdrant repository", e);
        }
    }

    public void insert(List<Document> documents) throws IOException {
        if (Utils.isEmpty(documents)) {
            return;
        }
        for (List batch : ListUtil.partition(documents, (int)this.config.embeddingModel.batchSize())) {
            this.config.embeddingModel.embed(batch);
            List points = batch.stream().map(this::toPointStruct).collect(Collectors.toList());
            try {
                this.config.client.upsertAsync(Points.UpsertPoints.newBuilder().setCollectionName(this.config.collectionName).addAllPoints(points).build()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException("Failed to insert documents from Qdrant", e);
            }
        }
    }

    public void delete(String ... ids) throws IOException {
        try {
            List pointIds = Arrays.stream(ids).map(id -> Points.PointId.newBuilder().setUuid(id).build()).collect(Collectors.toList());
            this.config.client.deleteAsync(this.config.collectionName, pointIds).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to delete documents from Qdrant", e);
        }
    }

    public boolean exists(String id) throws IOException {
        try {
            List points = (List)this.config.client.retrieveAsync(Points.GetPoints.newBuilder().setCollectionName(this.config.collectionName).addIds(PointIdFactory.id((UUID)UUID.fromString(id))).build(), null).get();
            return points.size() > 0;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to check document existence in Qdrant", e);
        }
    }

    public List<Document> search(QueryCondition condition) throws IOException {
        try {
            float[] queryVector = this.config.embeddingModel.embed(condition.getQuery());
            Points.QueryPoints.Builder queryBuilder = Points.QueryPoints.newBuilder().setCollectionName(this.config.collectionName).setQuery(QueryFactory.nearest((float[])queryVector)).setLimit((long)condition.getLimit()).setScoreThreshold((float)condition.getSimilarityThreshold()).setWithPayload(WithPayloadSelectorFactory.include(Arrays.asList(this.config.contentFieldName, this.config.metadataFieldName))).setWithVectors(WithVectorsSelectorFactory.enable((boolean)true));
            Points.Filter filter = FilterTransformer.getInstance().transform((Expression<Boolean>)condition.getFilterExpression());
            if (filter != null) {
                queryBuilder.setFilter(filter);
            }
            List points = (List)this.config.client.queryAsync(queryBuilder.build()).get();
            Stream<Document> docs = points.stream().map(this::toDocument);
            return SimilarityUtil.refilter(docs, (QueryCondition)condition);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to search documents in Qdrant", e);
        }
    }

    private Points.PointStruct toPointStruct(Document doc) {
        if (doc.getId() == null) {
            doc.id(Utils.uuid());
        }
        Map<String, JsonWithInt.Value> payload = QdrantValueUtil.fromMap(doc.getMetadata());
        payload.put(this.config.contentFieldName, ValueFactory.value((String)doc.getContent()));
        if (doc.getMetadata() != null) {
            String metadataJson = ONode.stringify((Object)doc.getMetadata());
            payload.put("metadata", ValueFactory.value((String)metadataJson));
        }
        return Points.PointStruct.newBuilder().setId(PointIdFactory.id((UUID)UUID.fromString(doc.getId()))).setVectors(VectorsFactory.vectors((float[])doc.getEmbedding())).putAllPayload(payload).build();
    }

    private Document toDocument(Points.ScoredPoint scoredPoint) {
        String id = scoredPoint.getId().getUuid();
        float score = scoredPoint.getScore();
        Map payload = scoredPoint.getPayloadMap();
        String content = ((JsonWithInt.Value)payload.get(this.config.contentFieldName)).getStringValue();
        Map metadata = null;
        if (payload.containsKey(this.config.metadataFieldName)) {
            String metadataJson = ((JsonWithInt.Value)payload.get(this.config.metadataFieldName)).getStringValue();
            metadata = (Map)ONode.deserialize((String)metadataJson, Map.class);
        }
        float[] embedding = this.listToFloatArray(scoredPoint.getVectors().getVector().getDataList());
        Document doc = new Document(id, content, metadata, (double)score);
        return doc.embedding(embedding);
    }

    private float[] listToFloatArray(List<Float> list) {
        float[] array = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i).floatValue();
        }
        return array;
    }

    public static Builder builder(EmbeddingModel embeddingModel, QdrantClient client) {
        return new Builder(embeddingModel, client);
    }

    public static class Builder {
        private final EmbeddingModel embeddingModel;
        private final QdrantClient client;
        private String collectionName = "solon_ai";
        private String contentFieldName = "content";
        private String metadataFieldName = "metadata";

        public Builder(EmbeddingModel embeddingModel, QdrantClient client) {
            this.embeddingModel = embeddingModel;
            this.client = client;
        }

        public Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public QdrantRepository build() {
            return new QdrantRepository(this);
        }
    }
}

