/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.repository.qdrant;

import io.qdrant.client.ValueFactory;
import io.qdrant.client.grpc.JsonWithInt;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;

public class QdrantValueUtil {
    public static Map<String, JsonWithInt.Value> fromMap(Map<String, Object> inputMap) {
        assert (inputMap != null);
        return inputMap.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> QdrantValueUtil.value(e.getValue())));
    }

    private static JsonWithInt.Value value(Object value) {
        if (value == null) {
            return ValueFactory.nullValue();
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            Object[] objectArray = new Object[length];
            for (int i = 0; i < length; ++i) {
                objectArray[i] = Array.get(value, i);
            }
            return QdrantValueUtil.value(objectArray);
        }
        if (value instanceof Map) {
            return QdrantValueUtil.value((Map)value);
        }
        switch (value.getClass().getSimpleName()) {
            case "String": {
                return ValueFactory.value((String)((String)value));
            }
            case "Integer": {
                return ValueFactory.value((long)((Integer)value).intValue());
            }
            case "Double": {
                return ValueFactory.value((double)((Double)value));
            }
            case "Float": {
                return ValueFactory.value((double)((Float)value).floatValue());
            }
            case "Boolean": {
                return ValueFactory.value((boolean)((Boolean)value));
            }
        }
        throw new IllegalArgumentException("Unsupported Qdrant value type: " + value.getClass());
    }

    private static JsonWithInt.Value value(Object[] elements) {
        ArrayList<JsonWithInt.Value> values = new ArrayList<JsonWithInt.Value>(elements.length);
        for (Object element : elements) {
            values.add(QdrantValueUtil.value(element));
        }
        return ValueFactory.list(values);
    }

    private static JsonWithInt.Value value(Map<String, Object> inputMap) {
        JsonWithInt.Struct.Builder structBuilder = JsonWithInt.Struct.newBuilder();
        Map<String, JsonWithInt.Value> map = QdrantValueUtil.fromMap(inputMap);
        structBuilder.putAllFields(map);
        return JsonWithInt.Value.newBuilder().setStructValue(structBuilder).build();
    }
}

