/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.repository.qdrant;

import io.qdrant.client.ConditionFactory;
import io.qdrant.client.grpc.Points;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.Transformer;
import org.noear.solon.expression.snel.ComparisonNode;
import org.noear.solon.expression.snel.ConstantNode;
import org.noear.solon.expression.snel.LogicalNode;
import org.noear.solon.expression.snel.VariableNode;

public class FilterTransformer
implements Transformer<Boolean, Points.Filter> {
    private static FilterTransformer instance = new FilterTransformer();

    public static FilterTransformer getInstance() {
        return instance;
    }

    public Points.Filter transform(Expression<Boolean> source) {
        return this.transformDo(source);
    }

    protected Points.Filter transformDo(Expression operand) {
        Points.Filter.Builder context = Points.Filter.newBuilder();
        ArrayList<Points.Condition> mustClauses = new ArrayList<Points.Condition>();
        ArrayList<Points.Condition> shouldClauses = new ArrayList<Points.Condition>();
        ArrayList<Points.Condition> mustNotClauses = new ArrayList<Points.Condition>();
        if (operand instanceof LogicalNode) {
            LogicalNode logicalNode = (LogicalNode)operand;
            switch (logicalNode.getOperator()) {
                case NOT: {
                    mustNotClauses.add(ConditionFactory.filter((Points.Filter)this.transformDo(logicalNode.getLeft())));
                    break;
                }
                case AND: {
                    mustClauses.add(ConditionFactory.filter((Points.Filter)this.transformDo(logicalNode.getLeft())));
                    mustClauses.add(ConditionFactory.filter((Points.Filter)this.transformDo(logicalNode.getRight())));
                    break;
                }
                case OR: {
                    shouldClauses.add(ConditionFactory.filter((Points.Filter)this.transformDo(logicalNode.getLeft())));
                    shouldClauses.add(ConditionFactory.filter((Points.Filter)this.transformDo(logicalNode.getRight())));
                }
            }
        } else if (operand instanceof ComparisonNode) {
            ComparisonNode comparisonNode = (ComparisonNode)operand;
            if (comparisonNode.getRight() instanceof ConstantNode) {
                mustClauses.add(this.parseComparison(comparisonNode));
            } else {
                throw new RuntimeException("Non logical expression must have Value right argument!");
            }
        }
        return context.addAllMust(mustClauses).addAllShould(shouldClauses).addAllMustNot(mustNotClauses).build();
    }

    protected Points.Condition parseComparison(ComparisonNode expr) {
        VariableNode left = (VariableNode)expr.getLeft();
        ConstantNode right = (ConstantNode)expr.getRight();
        switch (expr.getOperator()) {
            case eq: {
                return this.buildEqCondition(left, right);
            }
            case neq: {
                return this.buildNeCondition(left, right);
            }
            case gt: {
                return this.buildGtCondition(left, right);
            }
            case gte: {
                return this.buildGteCondition(left, right);
            }
            case lt: {
                return this.buildLtCondition(left, right);
            }
            case lte: {
                return this.buildLteCondition(left, right);
            }
            case in: {
                return this.buildInCondition(left, right);
            }
            case nin: {
                return this.buildNInCondition(left, right);
            }
        }
        throw new RuntimeException("Unsupported expression type: " + expr.getOperator());
    }

    protected Points.Condition buildEqCondition(VariableNode key, ConstantNode value) {
        String identifier = key.getName();
        if (value.getValue() instanceof String) {
            String valueStr = value.getValue().toString();
            return ConditionFactory.matchKeyword((String)identifier, (String)valueStr);
        }
        if (value.getValue() instanceof Number) {
            long lValue = ((Number)value.getValue()).longValue();
            return ConditionFactory.match((String)identifier, (long)lValue);
        }
        throw new IllegalArgumentException("Invalid value type for EQ. Can either be a string or Number");
    }

    protected Points.Condition buildNeCondition(VariableNode key, ConstantNode value) {
        String identifier = key.getName();
        if (value.getValue() instanceof String) {
            String valueStr = value.getValue().toString();
            return ConditionFactory.filter((Points.Filter)Points.Filter.newBuilder().addMustNot(ConditionFactory.matchKeyword((String)identifier, (String)valueStr)).build());
        }
        if (value.getValue() instanceof Number) {
            long lValue = ((Number)value.getValue()).longValue();
            Points.Condition condition = ConditionFactory.match((String)identifier, (long)lValue);
            return ConditionFactory.filter((Points.Filter)Points.Filter.newBuilder().addMustNot(condition).build());
        }
        throw new IllegalArgumentException("Invalid value type for NEQ. Can either be a string or Number");
    }

    protected Points.Condition buildGtCondition(VariableNode key, ConstantNode value) {
        String identifier = key.getName();
        if (value.getValue() instanceof Number) {
            Double dvalue = ((Number)value.getValue()).doubleValue();
            return ConditionFactory.range((String)identifier, (Points.Range)Points.Range.newBuilder().setGt(dvalue.doubleValue()).build());
        }
        throw new RuntimeException("Unsupported value type for GT condition. Only supports Number");
    }

    protected Points.Condition buildLtCondition(VariableNode key, ConstantNode value) {
        String identifier = key.getName();
        if (value.getValue() instanceof Number) {
            Double dvalue = ((Number)value.getValue()).doubleValue();
            return ConditionFactory.range((String)identifier, (Points.Range)Points.Range.newBuilder().setLt(dvalue.doubleValue()).build());
        }
        throw new RuntimeException("Unsupported value type for LT condition. Only supports Number");
    }

    protected Points.Condition buildGteCondition(VariableNode key, ConstantNode value) {
        String identifier = key.getName();
        if (value.getValue() instanceof Number) {
            Double dvalue = ((Number)value.getValue()).doubleValue();
            return ConditionFactory.range((String)identifier, (Points.Range)Points.Range.newBuilder().setGte(dvalue.doubleValue()).build());
        }
        throw new RuntimeException("Unsupported value type for GTE condition. Only supports Number");
    }

    protected Points.Condition buildLteCondition(VariableNode key, ConstantNode value) {
        String identifier = key.getName();
        if (value.getValue() instanceof Number) {
            Double dvalue = ((Number)value.getValue()).doubleValue();
            return ConditionFactory.range((String)identifier, (Points.Range)Points.Range.newBuilder().setLte(dvalue.doubleValue()).build());
        }
        throw new RuntimeException("Unsupported value type for LTE condition. Only supports Number");
    }

    protected Points.Condition buildInCondition(VariableNode key, ConstantNode value) {
        List valueList;
        if (value.getValue() instanceof List && Utils.isNotEmpty((Collection)(valueList = (List)value.getValue()))) {
            Object firstValue = valueList.get(0);
            String identifier = key.getName();
            if (firstValue instanceof String) {
                ArrayList<String> stringValues = new ArrayList<String>();
                for (Object valueObj : valueList) {
                    stringValues.add(valueObj.toString());
                }
                return ConditionFactory.matchKeywords((String)identifier, stringValues);
            }
            if (firstValue instanceof Number) {
                ArrayList<Long> longValues = new ArrayList<Long>();
                for (Object valueObj : valueList) {
                    Long longValue = Long.parseLong(valueObj.toString());
                    longValues.add(longValue);
                }
                return ConditionFactory.matchValues((String)identifier, longValues);
            }
            throw new RuntimeException("Unsupported value in IN value list. Only supports String or Number");
        }
        throw new RuntimeException("Unsupported value type for IN condition. Only supports non-empty List of String or Number");
    }

    protected Points.Condition buildNInCondition(VariableNode key, ConstantNode value) {
        List valueList;
        if (value.getValue() instanceof List && Utils.isNotEmpty((Collection)(valueList = (List)value.getValue()))) {
            Object firstValue = valueList.get(0);
            String identifier = key.getName();
            if (firstValue instanceof String) {
                ArrayList<String> stringValues = new ArrayList<String>();
                for (Object valueObj : valueList) {
                    stringValues.add(valueObj.toString());
                }
                return ConditionFactory.matchExceptKeywords((String)identifier, stringValues);
            }
            if (firstValue instanceof Number) {
                ArrayList<Long> longValues = new ArrayList<Long>();
                for (Object valueObj : valueList) {
                    Long longValue = Long.parseLong(valueObj.toString());
                    longValues.add(longValue);
                }
                return ConditionFactory.matchExceptValues((String)identifier, longValues);
            }
            throw new RuntimeException("Unsupported value in NIN value list. Only supports String or Number");
        }
        throw new RuntimeException("Unsupported value type for NIN condition. Only supports non-empty List of String or Number");
    }
}

