/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.repository.vectorex;

import io.github.javpower.vectorexclient.builder.QueryBuilder;
import java.util.List;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.Transformer;
import org.noear.solon.expression.snel.ComparisonNode;
import org.noear.solon.expression.snel.ConstantNode;
import org.noear.solon.expression.snel.LogicalNode;
import org.noear.solon.expression.snel.VariableNode;

public class FilterTransformer
implements Transformer<Boolean, QueryBuilder> {
    private String collectionName;

    public FilterTransformer(String collectionName) {
        this.collectionName = collectionName;
    }

    public QueryBuilder transform(Expression<Boolean> source) {
        QueryBuilder builder = this.transformDo(source);
        if (builder == null) {
            return QueryBuilder.lambda((String)this.collectionName);
        }
        return builder;
    }

    private String getName(Expression node) {
        if (node instanceof VariableNode) {
            return ((VariableNode)node).getName();
        }
        throw new IllegalStateException("can't get name of " + node);
    }

    private Object getValue(Expression node) {
        if (node instanceof ConstantNode) {
            return ((ConstantNode)node).getValue();
        }
        throw new IllegalStateException("can't get value of " + node);
    }

    private QueryBuilder transformDo(Expression<Boolean> node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ComparisonNode) {
            ComparisonNode compNode = (ComparisonNode)node;
            QueryBuilder compQb = QueryBuilder.lambda((String)this.collectionName);
            String name = this.getName(compNode.getLeft());
            Object value = this.getValue(compNode.getRight());
            switch (compNode.getOperator()) {
                case eq: {
                    return compQb.eq(name, value);
                }
                case gt: {
                    return compQb.gt(name, (Comparable)value);
                }
                case gte: {
                    return compQb.ge(name, (Comparable)value);
                }
                case lt: {
                    return compQb.lt(name, (Comparable)value);
                }
                case lte: {
                    return compQb.le(name, (Comparable)value);
                }
                case lk: {
                    return compQb.like(name, (String)value);
                }
                case in: {
                    return compQb.in(name, (List)value);
                }
            }
            throw new IllegalStateException("not support " + compNode.getOperator());
        }
        if (node instanceof LogicalNode) {
            LogicalNode opNode = (LogicalNode)node;
            switch (opNode.getOperator()) {
                case AND: {
                    QueryBuilder leftQb = this.transformDo((Expression<Boolean>)opNode.getLeft());
                    QueryBuilder rightQb = this.transformDo((Expression<Boolean>)opNode.getRight());
                    return leftQb.and(rightQb);
                }
                case OR: {
                    QueryBuilder leftQb = this.transformDo((Expression<Boolean>)opNode.getLeft());
                    QueryBuilder rightQb = this.transformDo((Expression<Boolean>)opNode.getRight());
                    return leftQb.or(rightQb);
                }
            }
            throw new IllegalStateException("not support " + opNode.getOperator());
        }
        return null;
    }
}

