/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.repository;

import io.github.javpower.vectorexclient.VectorRexClient;
import io.github.javpower.vectorexclient.builder.QueryBuilder;
import io.github.javpower.vectorexclient.entity.MetricType;
import io.github.javpower.vectorexclient.entity.ScalarField;
import io.github.javpower.vectorexclient.entity.VectorFiled;
import io.github.javpower.vectorexclient.req.CollectionDataAddReq;
import io.github.javpower.vectorexclient.req.CollectionDataDelReq;
import io.github.javpower.vectorexclient.req.VectoRexCollectionReq;
import io.github.javpower.vectorexclient.res.ServerResponse;
import io.github.javpower.vectorexclient.res.VectorSearchResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.ai.embedding.EmbeddingModel;
import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.rag.RepositoryLifecycle;
import org.noear.solon.ai.rag.RepositoryStorable;
import org.noear.solon.ai.rag.repository.vectorex.FilterTransformer;
import org.noear.solon.ai.rag.util.QueryCondition;
import org.noear.solon.ai.rag.util.SimilarityUtil;
import org.noear.solon.expression.Expression;

public class VectoRexRepository
implements RepositoryStorable,
RepositoryLifecycle {
    private final Builder config;

    private VectoRexRepository(Builder config) {
        this.config = config;
    }

    public void initRepository() throws Exception {
        ArrayList<ScalarField> scalarFields = new ArrayList<ScalarField>();
        ScalarField id = ScalarField.builder().name("id").isPrimaryKey(Boolean.valueOf(true)).build();
        scalarFields.add(id);
        ArrayList<VectorFiled> vectorFileds = new ArrayList<VectorFiled>();
        VectorFiled vector = VectorFiled.builder().name("embedding").metricType(MetricType.FLOAT_CANBERRA_DISTANCE).dimensions(Integer.valueOf(3)).build();
        vectorFileds.add(vector);
        ServerResponse face = this.config.client.createCollection(VectoRexCollectionReq.builder().collectionName("face").scalarFields(scalarFields).vectorFileds(vectorFileds).build());
    }

    public void dropRepository() throws Exception {
        ServerResponse response = this.config.client.delCollection(this.config.collectionName);
        if (!response.isSuccess()) {
            throw new IOException(response.getMsg());
        }
    }

    public void insert(List<Document> documents) throws IOException {
        for (final Document doc : documents) {
            doc.id(Utils.uuid());
            doc.embedding(this.config.embeddingModel.embed(doc.getContent()));
            CollectionDataAddReq req = CollectionDataAddReq.builder().collectionName(this.config.collectionName).metadata((Map)new HashMap<String, Object>(){
                {
                    this.put("id", doc.getId());
                    this.put("embedding", doc.getEmbedding());
                    this.put("content", doc.getContent());
                    this.put("metadata", doc.getMetadata());
                }
            }).build();
            ServerResponse response = this.config.client.addCollectionData(req);
            if (response.isSuccess()) continue;
            throw new IOException(response.getMsg());
        }
    }

    public void delete(String ... ids) throws IOException {
        for (String id : ids) {
            CollectionDataDelReq req = new CollectionDataDelReq(this.config.collectionName, id);
            ServerResponse response = this.config.client.deleteCollectionData(req);
            if (response.isSuccess()) continue;
            throw new IOException(response.getMsg());
        }
    }

    public boolean exists(String id) throws IOException {
        QueryBuilder queryBuilder = QueryBuilder.lambda((String)this.config.collectionName);
        queryBuilder.eq("id", (Object)id);
        ServerResponse response = this.config.client.queryCollectionData(queryBuilder);
        return response.isSuccess() && Utils.isNotEmpty((Collection)((Collection)response.getData()));
    }

    public List<Document> search(QueryCondition condition) throws IOException {
        float[] embed = this.config.embeddingModel.embed(condition.getQuery());
        QueryBuilder queryBuilder = new FilterTransformer(this.config.collectionName).transform((Expression<Boolean>)condition.getFilterExpression());
        queryBuilder.vector("embedding", Arrays.asList(new float[][]{embed})).topK(Integer.valueOf(condition.getLimit()));
        ServerResponse response = this.config.client.queryCollectionData(queryBuilder);
        if (!response.isSuccess()) {
            throw new IOException(response.getMsg());
        }
        return SimilarityUtil.refilter(((List)response.getData()).stream().map(this::toDocument), (QueryCondition)condition);
    }

    private Document toDocument(VectorSearchResult rst) {
        return new Document((String)rst.getData().getMetadata().get("id"), (String)rst.getData().getMetadata().get("content"), (Map)rst.getData().getMetadata().get("metadata"), (double)rst.getScore().floatValue());
    }

    public static Builder builder(EmbeddingModel embeddingModel, VectorRexClient client) {
        return new Builder(embeddingModel, client);
    }

    static /* synthetic */ Builder access$300(VectoRexRepository x0) {
        return x0.config;
    }

    public static class Builder {
        private final EmbeddingModel embeddingModel;
        private final VectorRexClient client;
        private String collectionName = "solon_ai";
        private final String idFieldName = "id";
        private final String embeddingFieldName = "embedding";
        private final String contentFieldName = "content";
        private final String metadataFieldName = "metadata";

        public Builder(EmbeddingModel embeddingModel, VectorRexClient client) {
            this.embeddingModel = embeddingModel;
            this.client = client;
        }

        public Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public VectoRexRepository build() {
            return new VectoRexRepository(this);
        }
    }
}

