/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.noear.snack.ONode;
import org.noear.solon.ai.AiConfig;
import org.noear.solon.ai.embedding.EmbeddingModel;
import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.rag.Repository;
import org.noear.solon.ai.rag.util.QueryCondition;
import org.noear.solon.ai.rag.util.SimilarityUtil;
import org.noear.solon.lang.Nullable;
import org.noear.solon.net.http.HttpUtils;

public class BaiduWebSearchRepository
implements Repository {
    private final AiConfig config;
    private final SearchType searchType;
    private final String model;
    @Nullable
    private final EmbeddingModel embeddingModel;

    private BaiduWebSearchRepository(AiConfig config, SearchType searchType, String model, EmbeddingModel embeddingModel) {
        this.config = config;
        this.searchType = searchType != null ? searchType : SearchType.BASIC;
        this.model = model != null ? model : "ernie-3.5-8k";
        this.embeddingModel = embeddingModel;
    }

    public static BaiduAiSearchRepositoryBuilder ofBasic() {
        return new BaiduAiSearchRepositoryBuilder(SearchType.BASIC);
    }

    public static BaiduAiSearchRepositoryBuilder ofAI() {
        return new BaiduAiSearchRepositoryBuilder(SearchType.AI);
    }

    public static BaiduAiSearchRepositoryBuilder of(SearchType searchType) {
        return new BaiduAiSearchRepositoryBuilder(searchType);
    }

    public List<Document> search(QueryCondition condition) throws IOException {
        String query = condition.getQuery();
        if (query == null || query.trim().isEmpty()) {
            return new ArrayList<Document>();
        }
        HttpUtils httpUtils = this.config.createHttpUtils();
        ONode requestBody = new ONode();
        ONode messagesArray = requestBody.getOrNew("messages").asArray();
        ONode message = messagesArray.addNew();
        message.set("role", (Object)"user");
        message.set("content", (Object)query.trim());
        if (this.searchType == SearchType.AI) {
            requestBody.set("model", (Object)this.model);
            requestBody.set("stream", (Object)false);
            requestBody.set("enable_corner_markers", (Object)true);
            requestBody.set("enable_deep_search", (Object)false);
            requestBody.set("enable_followup_queries", (Object)false);
        }
        if (condition.getLimit() > 0) {
            ONode resourceTypeFilter = requestBody.getOrNew("resource_type_filter").asArray().addNew();
            resourceTypeFilter.set("type", (Object)"web");
            resourceTypeFilter.set("top_k", (Object)condition.getLimit());
        }
        httpUtils.header("X-Appbuilder-Authorization", "Bearer " + this.config.getApiKey());
        httpUtils.header("Content-Type", "application/json");
        String respJson = httpUtils.bodyOfJson(requestBody.toJson()).post();
        return this.parseResponse(respJson, condition);
    }

    private List<Document> parseResponse(String respJson, QueryCondition condition) throws IOException {
        ONode referencesArray;
        String aiContent;
        ONode firstChoice;
        ONode choicesArray;
        ONode respNode = ONode.load((Object)respJson);
        if (respNode.contains("code")) {
            int code = respNode.get("code").getInt();
            String message = respNode.get("message").getString();
            if (code != 0) {
                throw new IOException("BaiduAiSearch error (code=" + code + "): " + message);
            }
        }
        ArrayList<Document> docs = new ArrayList<Document>();
        if (this.searchType == SearchType.AI && respNode.contains("choices") && (choicesArray = respNode.get("choices")).isArray() && choicesArray.count() > 0 && (firstChoice = choicesArray.get(0)).contains("message") && (aiContent = firstChoice.get("message").get("content").getString()) != null && !aiContent.trim().isEmpty()) {
            docs.add(new Document(aiContent.trim()).title("Solon AI\u667a\u80fd\u56de\u7b54").metadata("type", (Object)"ai_answer").metadata("source", (Object)"baidu_ai_search"));
        }
        if (respNode.contains("references") && (referencesArray = respNode.get("references")).isArray()) {
            for (ONode ref : referencesArray.ary()) {
                String content = ref.get("content").getString();
                String title = ref.get("title").getString();
                String url = ref.get("url").getString();
                if (content == null || content.trim().isEmpty()) continue;
                Document doc2 = new Document(content.trim());
                if (title != null && !title.trim().isEmpty()) {
                    doc2.title(title.trim());
                }
                if (url != null && !url.trim().isEmpty()) {
                    doc2.url(url.trim());
                }
                if (ref.contains("id")) {
                    doc2.metadata("id", (Object)ref.get("id").getString());
                }
                if (ref.contains("date") && ref.get("date").getString() != null) {
                    doc2.metadata("date", (Object)ref.get("date").getString());
                }
                if (ref.contains("type")) {
                    doc2.metadata("type", (Object)ref.get("type").getString());
                } else {
                    doc2.metadata("type", (Object)"web");
                }
                if (ref.contains("web_anchor")) {
                    doc2.metadata("web_anchor", (Object)ref.get("web_anchor").getString());
                }
                if (ref.contains("icon")) {
                    doc2.metadata("icon", (Object)ref.get("icon").getString());
                }
                doc2.metadata("source", (Object)"baidu_search");
                docs.add(doc2);
            }
        }
        if (docs.isEmpty()) {
            throw new IOException("No content found in BaiduAiSearch response: " + respJson.substring(0, Math.min(200, respJson.length())));
        }
        if (this.embeddingModel != null) {
            this.embeddingModel.embed(docs);
            float[] queryEmbed = this.embeddingModel.embed(condition.getQuery());
            return SimilarityUtil.refilter(docs.stream().map(doc -> SimilarityUtil.score((Document)doc, (float[])queryEmbed)), (QueryCondition)condition);
        }
        return docs;
    }

    public static class BaiduAiSearchRepositoryBuilder {
        private final SearchType searchType;
        private AiConfig config = new AiConfig();
        private String model;
        private EmbeddingModel embeddingModel;

        private BaiduAiSearchRepositoryBuilder(SearchType searchType) {
            this.searchType = searchType;
        }

        public BaiduAiSearchRepositoryBuilder apiKey(String apiKey) {
            this.config.setApiKey(apiKey);
            return this;
        }

        public BaiduAiSearchRepositoryBuilder apiUrl(String apiUrl) {
            this.config.setApiUrl(apiUrl);
            return this;
        }

        public BaiduAiSearchRepositoryBuilder model(String model) {
            this.model = model;
            return this;
        }

        public BaiduAiSearchRepositoryBuilder embeddingModel(EmbeddingModel embeddingModel) {
            this.embeddingModel = embeddingModel;
            return this;
        }

        public BaiduWebSearchRepository build() {
            return new BaiduWebSearchRepository(this.config, this.searchType, this.model, this.embeddingModel);
        }
    }

    public static enum SearchType {
        BASIC,
        AI;

    }
}

