/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.dialect;

import java.util.Date;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.chat.ChatChoice;
import org.noear.solon.ai.chat.ChatConfig;
import org.noear.solon.ai.chat.ChatException;
import org.noear.solon.ai.chat.ChatResponseDefault;
import org.noear.solon.ai.chat.dialect.AbstractChatDialect;
import org.noear.solon.ai.chat.message.AssistantMessage;
import org.noear.solon.ai.chat.message.UserMessage;
import org.noear.solon.core.util.DateUtil;

public class OllamaChatDialect
extends AbstractChatDialect {
    private static OllamaChatDialect instance = new OllamaChatDialect();

    public static OllamaChatDialect getInstance() {
        return instance;
    }

    @Override
    public boolean matched(ChatConfig config) {
        return "ollama".equals(config.getProvider());
    }

    @Override
    protected void buildChatMessageNodeDo(ONode oNode, UserMessage msg) {
        oNode.set("role", (Object)msg.getRole().name().toLowerCase());
        if (Utils.isEmpty(msg.getImages())) {
            oNode.set("content", (Object)msg.getContent());
        } else {
            oNode.set("content", (Object)msg.getContent());
            oNode.set("images", msg.getImages());
        }
    }

    @Override
    public boolean parseResponseJson(ChatConfig config, ChatResponseDefault resp, String json) {
        ONode oResp = ONode.load((Object)json);
        if (!oResp.isObject()) {
            return false;
        }
        if (oResp.contains("error")) {
            resp.setError(new ChatException(oResp.get("error").getString()));
        } else {
            resp.setModel(oResp.get("model").getString());
            resp.setFinished(oResp.get("done").getBoolean());
            String done_reason = oResp.get("done_reason").getString();
            String createdStr = oResp.get("created_at").getString();
            if (createdStr != null) {
                createdStr = createdStr.substring(0, createdStr.indexOf(".") + 4);
            }
            Date created = DateUtil.parseTry((String)createdStr);
            AssistantMessage message1 = this.parseAssistantMessage(resp, oResp.get("message"));
            resp.addChoice(new ChatChoice(0, created, done_reason, message1));
            if (resp.isFinished()) {
                long promptTokens = oResp.get("prompt_eval_count").getLong();
                long completionTokens = oResp.get("eval_count").getLong();
                long totalTokens = promptTokens + completionTokens;
                resp.setUsage(new AiUsage(promptTokens, completionTokens, totalTokens));
            }
        }
        return true;
    }
}

