/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.message;

import java.util.List;
import java.util.Map;
import org.noear.solon.ai.chat.ChatRole;
import org.noear.solon.ai.chat.function.ChatFunctionCall;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class AssistantMessage
implements ChatMessage {
    private final ChatRole role = ChatRole.ASSISTANT;
    private String content;
    private String reasoningContent;
    private List<ChatFunctionCall> toolCalls;
    private List<Map> toolCallsRaw;
    private boolean isReasoning;

    public AssistantMessage() {
    }

    public AssistantMessage(String content, boolean isReasoning, String reasoningContent, List<Map> toolCallsRaw, List<ChatFunctionCall> toolCalls) {
        this.content = content;
        this.isReasoning = isReasoning;
        this.reasoningContent = reasoningContent;
        this.toolCallsRaw = toolCallsRaw;
        this.toolCalls = toolCalls;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public boolean isReasoning() {
        return this.isReasoning;
    }

    public String getReasoningContent() {
        return this.reasoningContent;
    }

    public List<ChatFunctionCall> getToolCalls() {
        return this.toolCalls;
    }

    public List<Map> getToolCallsRaw() {
        return this.toolCallsRaw;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("role=").append(this.getRole().name().toLowerCase());
        if (this.content != null) {
            buf.append(", content='").append(this.content).append('\'');
        }
        if (this.reasoningContent != null) {
            buf.append(", reasoning_content='").append(this.reasoningContent).append('\'');
        }
        if (this.toolCallsRaw != null) {
            buf.append(", tool_calls=").append(this.toolCallsRaw);
        }
        buf.append("}");
        return buf.toString();
    }
}

