/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.message;

import java.io.Serializable;
import java.util.List;
import org.noear.snack.ONode;
import org.noear.snack.core.Feature;
import org.noear.solon.ai.chat.ChatRole;
import org.noear.solon.ai.chat.message.AssistantMessage;
import org.noear.solon.ai.chat.message.SystemMessage;
import org.noear.solon.ai.chat.message.ToolMessage;
import org.noear.solon.ai.chat.message.UserMessage;

public interface ChatMessage
extends Serializable {
    public ChatRole getRole();

    public String getContent();

    public static AssistantMessage ofAssistant(String content) {
        return new AssistantMessage(content, false, null, null, null);
    }

    public static ChatMessage ofSystem(String content) {
        return new SystemMessage(content);
    }

    public static ChatMessage ofUser(String content) {
        return new UserMessage(content, null);
    }

    public static ChatMessage ofUser(String content, List<String> images) {
        return new UserMessage(content, images);
    }

    public static ChatMessage ofTool(String content, String name, String toolCallId) {
        return new ToolMessage(content, name, toolCallId);
    }

    public static String toJson(ChatMessage message) {
        return ONode.stringify((Object)message, (Feature[])new Feature[]{Feature.EnumUsingName});
    }

    public static ChatMessage fromJson(String json) {
        ONode oNode = ONode.loadStr((String)json);
        ChatRole role = ChatRole.valueOf(oNode.get("role").getString());
        if (role == ChatRole.TOOL) {
            return (ChatMessage)oNode.toObject(ToolMessage.class);
        }
        if (role == ChatRole.SYSTEM) {
            return (ChatMessage)oNode.toObject(SystemMessage.class);
        }
        if (role == ChatRole.USER) {
            return (ChatMessage)oNode.toObject(UserMessage.class);
        }
        return (ChatMessage)oNode.toObject(AssistantMessage.class);
    }
}

