/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.repository;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.Utils;
import org.noear.solon.ai.embedding.EmbeddingModel;
import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.rag.RepositoryStorable;
import org.noear.solon.ai.rag.util.FilterUtil;
import org.noear.solon.ai.rag.util.QueryCondition;

public class InMemoryRepository
implements RepositoryStorable {
    private final EmbeddingModel embeddingModel;
    private final Map<String, Document> store = new ConcurrentHashMap<String, Document>();

    public InMemoryRepository(EmbeddingModel embeddingModel) {
        this.embeddingModel = embeddingModel;
    }

    @Override
    public void store(List<Document> documents) throws IOException {
        this.embeddingModel.embed(documents);
        for (Document doc : documents) {
            if (Utils.isEmpty((String)doc.getId())) {
                doc.id(Utils.uuid());
            }
            this.store.put(doc.getId(), doc);
        }
    }

    @Override
    public void remove(String id) {
        this.store.remove(id);
    }

    @Override
    public List<Document> search(QueryCondition condition) throws IOException {
        return FilterUtil.similarityFilter(condition, this.embeddingModel, this.store.values().stream());
    }
}

