/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.util;

public final class SimilarityMath {
    public static double cosineSimilarity(float[] embedA, float[] embedB) {
        if (embedA != null && embedB != null) {
            if (embedA.length != embedB.length) {
                throw new IllegalArgumentException("Embed length must be equal");
            }
            float dotProduct = SimilarityMath.dotProduct(embedA, embedB);
            float normA = SimilarityMath.norm(embedA);
            float normB = SimilarityMath.norm(embedB);
            if (normA != 0.0f && normB != 0.0f) {
                return (double)dotProduct / (Math.sqrt(normA) * Math.sqrt(normB));
            }
            throw new IllegalArgumentException("Embed cannot be zero norm");
        }
        throw new RuntimeException("Embed must not be null");
    }

    public static float dotProduct(float[] embedA, float[] embedB) {
        if (embedA.length != embedB.length) {
            throw new IllegalArgumentException("Embed length must be equal");
        }
        float tmp = 0.0f;
        for (int i = 0; i < embedA.length; ++i) {
            tmp += embedA[i] * embedB[i];
        }
        return tmp;
    }

    public static float norm(float[] vector) {
        return SimilarityMath.dotProduct(vector, vector);
    }
}

