/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.dialect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.noear.solon.ai.chat.ChatConfig;
import org.noear.solon.ai.chat.dialect.ChatDialect;
import org.noear.solon.ai.chat.dialect.DashscopeDialect;
import org.noear.solon.ai.chat.dialect.OllamaChatDialect;
import org.noear.solon.ai.chat.dialect.OpenaiChatDialect;
import org.noear.solon.core.util.RankEntity;

public class ChatDialectManager {
    private static List<RankEntity<ChatDialect>> dialects = new ArrayList<RankEntity<ChatDialect>>();

    public static ChatDialect select(ChatConfig config) {
        for (RankEntity<ChatDialect> d : dialects) {
            if (!((ChatDialect)d.target).matched(config)) continue;
            return (ChatDialect)d.target;
        }
        return OpenaiChatDialect.instance();
    }

    public static void register(ChatDialect dialect) {
        ChatDialectManager.register(dialect, 0);
    }

    public static void register(ChatDialect dialect, int index) {
        dialects.add((RankEntity<ChatDialect>)new RankEntity((Object)dialect, index));
        Collections.sort(dialects);
    }

    public static void unregister(ChatDialect dialect) {
        dialects.removeIf(rankEntity -> rankEntity.target == dialect);
    }

    static {
        ChatDialectManager.register(OllamaChatDialect.getInstance());
        ChatDialectManager.register(DashscopeDialect.getInstance());
    }
}

