/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.dialect;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.chat.ChatChoice;
import org.noear.solon.ai.chat.ChatConfig;
import org.noear.solon.ai.chat.ChatException;
import org.noear.solon.ai.chat.ChatOptions;
import org.noear.solon.ai.chat.ChatResponseDefault;
import org.noear.solon.ai.chat.dialect.AbstractChatDialect;
import org.noear.solon.ai.chat.message.AssistantMessage;
import org.noear.solon.ai.chat.message.ChatMessage;

public class DashscopeDialect
extends AbstractChatDialect {
    private static DashscopeDialect instance = new DashscopeDialect();

    public static DashscopeDialect getInstance() {
        return instance;
    }

    @Override
    public boolean matched(ChatConfig config) {
        return "dashscope".equals(config.getProvider());
    }

    @Override
    public String buildRequestJson(ChatConfig config, ChatOptions options, List<ChatMessage> messages, boolean stream) {
        return new ONode().build(n -> {
            n.set("stream", (Object)stream);
            if (Utils.isNotEmpty((String)config.getModel())) {
                n.set("model", (Object)config.getModel());
            }
            n.getOrNew("input").getOrNew("messages").build(n1 -> {
                for (ChatMessage m1 : messages) {
                    n1.add((Object)this.buildChatMessageNode(m1));
                }
            });
            for (Map.Entry<String, Object> kv : options.options().entrySet()) {
                n.set(kv.getKey(), kv.getValue());
            }
            ONode p = n.getOrNew("parameters");
            p.set("result_format", (Object)"message");
            this.buildReqFunctionsNodeDo(p, config.getGlobalFunctions());
            this.buildReqFunctionsNodeDo(p, options.functions());
        }).toJson();
    }

    @Override
    public boolean parseResponseJson(ChatConfig config, ChatResponseDefault resp, String json) {
        if (json.startsWith("data:") && "[DONE]".equals(json = json.substring(6))) {
            resp.setFinished(true);
            return true;
        }
        ONode oResp = ONode.load((Object)json);
        if (!oResp.isObject()) {
            return false;
        }
        if (oResp.contains("code") && !Utils.isEmpty((String)oResp.get("code").getString())) {
            resp.setError(new ChatException(oResp.get("code").getString() + ": " + oResp.get("message").getString()));
        } else {
            resp.setModel(config.getModel());
            int index = 0;
            Date created = null;
            for (ONode oChoice1 : oResp.get("output").get("choices").ary()) {
                String finish_reason = oChoice1.get("finish_reason").getString();
                if ("stop".equals(finish_reason)) {
                    resp.setFinished(true);
                }
                AssistantMessage message1 = oChoice1.contains("delta") ? this.parseAssistantMessage(resp, oChoice1.get("delta")) : this.parseAssistantMessage(resp, oChoice1.get("message"));
                resp.addChoice(new ChatChoice(index, created, finish_reason, message1));
                ++index;
            }
            ONode oUsage = oResp.getOrNull("usage");
            if (oUsage != null) {
                long promptTokens = oUsage.get("input_tokens").getLong();
                long completionTokens = oUsage.get("output_tokens").getLong();
                long totalTokens = oUsage.get("total_tokens").getLong();
                resp.setUsage(new AiUsage(promptTokens, completionTokens, totalTokens));
            }
        }
        return true;
    }
}

