/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.message;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.ChatRole;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.ai.chat.message.UserMessageTemplate;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class UserMessage
implements ChatMessage {
    private final ChatRole role = ChatRole.USER;
    private String content;
    private List<String> images;

    public static ChatMessage augment(String message, Object context) {
        String newContent = String.format("%s\n\n now: %s \n\n context: %s", message, LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME), context);
        return new UserMessage(newContent);
    }

    public static UserMessageTemplate template(String tmpl) {
        return new UserMessageTemplate(tmpl);
    }

    public UserMessage() {
    }

    public UserMessage(String content) {
        this(content, null);
    }

    public UserMessage(String content, List<String> images) {
        this.content = content;
        this.images = images;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public List<String> getImages() {
        return this.images;
    }

    public String toString() {
        if (Utils.isEmpty(this.images)) {
            return "{role='" + (Object)((Object)this.getRole()) + '\'' + ", content='" + this.content + '\'' + '}';
        }
        return "{role='" + (Object)((Object)this.getRole()) + '\'' + ", content='" + this.content + '\'' + ", image_urls='" + this.images + '\'' + '}';
    }
}

