/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.embedding.dialect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.noear.solon.ai.embedding.EmbeddingConfig;
import org.noear.solon.ai.embedding.dialect.EmbeddingDialect;
import org.noear.solon.ai.embedding.dialect.OllamaEmbeddingDialect;
import org.noear.solon.ai.embedding.dialect.OpenaiEmbeddingDialect;
import org.noear.solon.core.util.RankEntity;

public class EmbeddingDialectManager {
    private static List<RankEntity<EmbeddingDialect>> dialects = new ArrayList<RankEntity<EmbeddingDialect>>();

    public static EmbeddingDialect select(EmbeddingConfig config) {
        for (RankEntity<EmbeddingDialect> d : dialects) {
            if (!((EmbeddingDialect)d.target).matched(config)) continue;
            return (EmbeddingDialect)d.target;
        }
        return OpenaiEmbeddingDialect.getInstance();
    }

    public static void register(EmbeddingDialect dialect) {
        EmbeddingDialectManager.register(dialect, 0);
    }

    public static void register(EmbeddingDialect dialect, int index) {
        dialects.add((RankEntity<EmbeddingDialect>)new RankEntity((Object)dialect, index));
        Collections.sort(dialects);
    }

    public static void unregister(EmbeddingDialect dialect) {
        dialects.removeIf(rankEntity -> rankEntity.target == dialect);
    }

    static {
        EmbeddingDialectManager.register(OllamaEmbeddingDialect.getInstance());
    }
}

