/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.util;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.noear.solon.ai.embedding.EmbeddingModel;
import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.rag.util.QueryCondition;
import org.noear.solon.ai.rag.util.SimilarityMath;

public final class FilterUtil {
    public static List<Document> similarityFilter(QueryCondition condition, EmbeddingModel embeddingModel, Stream<Document> docs) throws IOException {
        float[] queryEmbed = embeddingModel.embed(condition.getQuery());
        return FilterUtil.similarityFilter(condition, docs, queryEmbed);
    }

    public static List<Document> similarityFilter(QueryCondition condition, Stream<Document> docs, float[] queryEmbed) throws IOException {
        return docs.filter(condition.getFilter()).map(doc -> FilterUtil.mapDo(doc, queryEmbed)).filter(doc -> FilterUtil.filterDo(doc, condition)).sorted(Comparator.comparing(Document::getScore).reversed()).limit(condition.getLimit()).collect(Collectors.toList());
    }

    private static Document mapDo(Document doc, float[] queryEmbed) {
        return new Document(doc.getId(), doc.getContent(), doc.getMetadata(), SimilarityMath.cosineSimilarity(queryEmbed, doc.getEmbedding()));
    }

    private static boolean filterDo(Document doc, QueryCondition condition) {
        return doc.getScore() >= condition.getSimilarityThreshold();
    }
}

