/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.dialect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiMedia;
import org.noear.solon.ai.audio.Audio;
import org.noear.solon.ai.chat.ChatConfig;
import org.noear.solon.ai.chat.ChatOptions;
import org.noear.solon.ai.chat.ChatResponseDefault;
import org.noear.solon.ai.chat.dialect.ChatDialect;
import org.noear.solon.ai.chat.function.ChatFunction;
import org.noear.solon.ai.chat.function.ChatFunctionCall;
import org.noear.solon.ai.chat.function.ChatFunctionParam;
import org.noear.solon.ai.chat.message.AssistantMessage;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.ai.chat.message.SystemMessage;
import org.noear.solon.ai.chat.message.ToolMessage;
import org.noear.solon.ai.chat.message.UserMessage;
import org.noear.solon.ai.image.Image;
import org.noear.solon.ai.video.Video;

public abstract class AbstractChatDialect
implements ChatDialect {
    protected void buildChatMessageNodeDo(ONode oNode, AssistantMessage msg) {
        oNode.set("role", (Object)msg.getRole().name().toLowerCase());
        int tinkIndex = msg.getContent().indexOf("</tink>");
        if (tinkIndex > 0) {
            oNode.set("content", (Object)msg.getContent().substring(tinkIndex));
        } else {
            oNode.set("content", (Object)msg.getContent());
        }
        if (Utils.isNotEmpty(msg.getToolCallsRaw())) {
            oNode.set("tool_calls", (Object)ONode.load(msg.getToolCallsRaw()));
        }
    }

    protected void buildChatMessageNodeDo(ONode oNode, SystemMessage msg) {
        oNode.set("role", (Object)msg.getRole().name().toLowerCase());
        oNode.set("content", (Object)msg.getContent());
    }

    protected void buildChatMessageNodeDo(ONode oNode, ToolMessage msg) {
        oNode.set("role", (Object)msg.getRole().name().toLowerCase());
        oNode.set("content", (Object)msg.getContent());
        if (Utils.isNotEmpty((String)msg.getName())) {
            oNode.set("name", (Object)msg.getName());
        }
        if (Utils.isNotEmpty((String)msg.getToolCallId())) {
            oNode.set("tool_call_id", (Object)msg.getToolCallId());
        }
    }

    protected void buildChatMessageNodeDo(ONode oNode, UserMessage msg) {
        oNode.set("role", (Object)msg.getRole().name().toLowerCase());
        if (Utils.isEmpty(msg.getMedias())) {
            oNode.set("content", (Object)msg.getContent());
        } else {
            oNode.getOrNew("content").build(n1 -> {
                n1.addNew().set("type", (Object)"text").set("text", (Object)msg.getContent());
                for (AiMedia media : msg.getMedias()) {
                    if (media instanceof Image) {
                        n1.addNew().set("type", (Object)"image_url").getOrNew("image_url").set("url", (Object)media.toDataString(true));
                        continue;
                    }
                    if (media instanceof Audio) {
                        n1.addNew().set("type", (Object)"audio_url").getOrNew("audio_url").set("url", (Object)media.getUrl());
                        continue;
                    }
                    if (!(media instanceof Video)) continue;
                    n1.addNew().set("type", (Object)"video_url").getOrNew("video_url").set("url", (Object)media.getUrl());
                }
            });
        }
    }

    public ONode buildChatMessageNode(ChatMessage chatMessage) {
        ONode oNode = new ONode();
        if (chatMessage instanceof AssistantMessage) {
            this.buildChatMessageNodeDo(oNode, (AssistantMessage)chatMessage);
        } else if (chatMessage instanceof SystemMessage) {
            this.buildChatMessageNodeDo(oNode, (SystemMessage)chatMessage);
        } else if (chatMessage instanceof ToolMessage) {
            this.buildChatMessageNodeDo(oNode, (ToolMessage)chatMessage);
        } else if (chatMessage instanceof UserMessage) {
            this.buildChatMessageNodeDo(oNode, (UserMessage)chatMessage);
        } else {
            throw new IllegalArgumentException("Unsupported chat message type: " + chatMessage.getClass());
        }
        return oNode;
    }

    protected void buildReqFunctionsNode(ONode n, ChatConfig config, ChatOptions options, ChatMessage lastMessage) {
        this.buildReqFunctionsNodeDo(n, config.getGlobalFunctions());
        this.buildReqFunctionsNodeDo(n, options.functions());
    }

    protected void buildReqFunctionsNodeDo(ONode n, Collection<ChatFunction> funcs) {
        if (Utils.isEmpty(funcs)) {
            return;
        }
        n.getOrNew("tools").build(n1 -> {
            for (ChatFunction func : funcs) {
                n1.addNew().build(n2 -> {
                    n2.set("type", (Object)"function");
                    n2.getOrNew("function").build(n3 -> {
                        n3.set("name", (Object)func.name());
                        n3.set("description", (Object)func.description());
                        n3.getOrNew("parameters").build(n4 -> {
                            n4.set("type", (Object)"object");
                            ONode n4r = n4.getOrNew("required").asArray();
                            n4.getOrNew("properties").build(n5 -> {
                                for (ChatFunctionParam p1 : func.params()) {
                                    n5.getOrNew(p1.name()).build(n6 -> this.buildReqFunctionParamNodeDo(p1, (ONode)n6));
                                    if (!p1.required()) continue;
                                    n4r.add((Object)p1.name());
                                }
                            });
                        });
                    });
                });
            }
        });
    }

    protected void buildReqFunctionParamNodeDo(ChatFunctionParam p1, ONode n6) {
        String typeStr = p1.type().getSimpleName().toLowerCase();
        if (p1.type().isArray()) {
            n6.set("type", (Object)"array");
            String typeItem = typeStr.substring(0, typeStr.length() - 2);
            n6.getOrNew("items").set("type", (Object)typeItem);
        } else if (p1.type().isEnum()) {
            n6.set("type", (Object)typeStr);
            n6.getOrNew("enum").build(n7 -> {
                for (Object e : p1.type().getEnumConstants()) {
                    n7.add((Object)e.toString());
                }
            });
        } else {
            n6.set("type", (Object)typeStr);
        }
        n6.set("description", (Object)p1.description());
    }

    @Override
    public String buildRequestJson(ChatConfig config, ChatOptions options, List<ChatMessage> messages, boolean stream) {
        return new ONode().build(n -> {
            n.set("stream", (Object)stream);
            if (Utils.isNotEmpty((String)config.getModel())) {
                n.set("model", (Object)config.getModel());
            }
            n.getOrNew("messages").build(n1 -> {
                for (ChatMessage m1 : messages) {
                    if (m1.isThinking()) continue;
                    n1.add((Object)this.buildChatMessageNode(m1));
                }
            });
            for (Map.Entry<String, Object> kv : options.options().entrySet()) {
                n.set(kv.getKey(), kv.getValue());
            }
            ChatMessage lastMessage = (ChatMessage)messages.get(messages.size() - 1);
            this.buildReqFunctionsNode((ONode)n, config, options, lastMessage);
        }).toJson();
    }

    protected List<ChatFunctionCall> parseToolCalls(ONode toolCallsNode) {
        if (toolCallsNode == null) {
            return null;
        }
        ArrayList<ChatFunctionCall> toolCalls = new ArrayList<ChatFunctionCall>();
        for (ONode n1 : toolCallsNode.ary()) {
            String callId = n1.get("id").getString();
            ONode n1f = n1.get("function");
            String name = n1f.get("name").getString();
            ONode n1fArgs = n1f.get("arguments");
            if (n1fArgs.isValue()) {
                n1fArgs = ONode.loadStr((String)n1fArgs.getString());
            }
            Map args = (Map)n1fArgs.toObject(Map.class);
            toolCalls.add(new ChatFunctionCall(callId, name, args));
        }
        return toolCalls;
    }

    protected List<AssistantMessage> parseAssistantMessage(boolean isStream, ChatResponseDefault resp, ONode oMessage) {
        ArrayList<AssistantMessage> messageList = new ArrayList<AssistantMessage>();
        String content = oMessage.get("content").getRawString();
        ONode toolCallsNode = oMessage.getOrNull("tool_calls");
        List toolCallsRaw = null;
        List<ChatFunctionCall> toolCalls = this.parseToolCalls(toolCallsNode);
        if (Utils.isNotEmpty(toolCalls)) {
            toolCallsRaw = (List)toolCallsNode.toObject(List.class);
        }
        if (oMessage.contains("reasoning_content")) {
            String reasoning_content = oMessage.get("reasoning_content").getRawString();
            if (isStream) {
                if (content == null) {
                    if (!resp.reasoning) {
                        messageList.add(new AssistantMessage("<think>", true, null, null));
                        messageList.add(new AssistantMessage("\n\n", true, null, null));
                        if (Utils.isNotEmpty((String)reasoning_content)) {
                            content = reasoning_content;
                        }
                    } else {
                        content = reasoning_content;
                    }
                    resp.reasoning = true;
                } else {
                    if (resp.reasoning) {
                        messageList.add(new AssistantMessage("</think>", true, null, null));
                        messageList.add(new AssistantMessage("\n\n", false, null, null));
                    }
                    resp.reasoning = false;
                }
            } else if (Utils.isNotEmpty((String)reasoning_content)) {
                content = "<think>\n\n" + reasoning_content + "</think>\n\n" + content;
            }
        } else if (isStream) {
            int thinkEnd;
            if (content.startsWith("<think>")) {
                resp.reasoning = true;
            } else if (resp.reasoning && (thinkEnd = content.indexOf("</think>")) >= 0) {
                resp.reasoning = false;
                messageList.add(new AssistantMessage(content, true, null, null));
                return messageList;
            }
        }
        if (content != null) {
            messageList.add(new AssistantMessage(content, resp.reasoning, toolCallsRaw, toolCalls));
        }
        return messageList;
    }
}

