/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.noear.solon.ai.chat.function.ChatFunction;
import org.noear.solon.ai.chat.function.ChatFunctionParam;
import org.noear.solon.ai.chat.function.ChatFunctionParamDecl;

public class ChatFunctionDecl
implements ChatFunction {
    private final String name;
    private final List<ChatFunctionParam> params;
    private String description;
    private Function<Map<String, Object>, String> handler;

    public ChatFunctionDecl(String name) {
        this.name = name;
        this.params = new ArrayList<ChatFunctionParam>();
    }

    public ChatFunctionDecl description(String description) {
        this.description = description;
        return this;
    }

    public ChatFunctionDecl param(String name, Class<?> type, String description) {
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException("type must be primitive");
        }
        this.params.add(new ChatFunctionParamDecl(name, type, description));
        return this;
    }

    public ChatFunctionDecl stringParam(String name, String description) {
        return this.param(name, String.class, description);
    }

    public ChatFunctionDecl intParam(String name, String description) {
        return this.param(name, Integer.TYPE, description);
    }

    public ChatFunctionDecl floatParam(String name, String description) {
        return this.param(name, Float.TYPE, description);
    }

    public ChatFunctionDecl handle(Function<Map<String, Object>, String> handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Iterable<ChatFunctionParam> params() {
        return this.params;
    }

    @Override
    public String handle(Map<String, Object> args) throws Throwable {
        return this.handler.apply(args);
    }
}

