/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.chat.ChatChoice;
import org.noear.solon.ai.chat.ChatException;
import org.noear.solon.ai.chat.ChatResponse;
import org.noear.solon.ai.chat.message.AssistantMessage;
import org.noear.solon.lang.Nullable;

public class ChatResponseDefault
implements ChatResponse {
    protected final List<ChatChoice> choices = new ArrayList<ChatChoice>();
    protected ChatException error;
    protected AiUsage usage;
    protected String model;
    protected boolean finished;
    public boolean reasoning;

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public ChatException getError() {
        return this.error;
    }

    @Override
    public List<ChatChoice> getChoices() {
        return this.choices;
    }

    @Override
    public boolean hasChoices() {
        return Utils.isNotEmpty(this.choices);
    }

    @Override
    public AssistantMessage getMessage() {
        if (this.hasChoices()) {
            return this.choices.get(this.choices.size() - 1).getMessage();
        }
        return null;
    }

    @Override
    @Nullable
    public AiUsage getUsage() {
        return this.usage;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    public void reset() {
        this.error = null;
        this.choices.clear();
    }

    public void addChoice(ChatChoice choice) {
        this.choices.add(choice);
    }

    public void setError(ChatException error) {
        this.error = error;
    }

    public void setUsage(AiUsage usage) {
        this.usage = usage;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }
}

