/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.message;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.ChatRole;
import org.noear.solon.ai.chat.function.ChatFunctionCall;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class AssistantMessage
implements ChatMessage {
    private final ChatRole role = ChatRole.ASSISTANT;
    private String content;
    private Map<String, Object> metadata;
    private List<ChatFunctionCall> toolCalls;
    private List<Map> toolCallsRaw;
    private boolean isThinking;

    public AssistantMessage() {
    }

    public AssistantMessage(String content, boolean isThinking, List<Map> toolCallsRaw, List<ChatFunctionCall> toolCalls) {
        this.content = content;
        this.isThinking = isThinking;
        this.toolCallsRaw = toolCallsRaw;
        this.toolCalls = toolCalls;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public Map<String, Object> getMetadata() {
        if (this.metadata == null) {
            this.metadata = new LinkedHashMap<String, Object>();
        }
        return this.metadata;
    }

    public AssistantMessage addMetadata(Map<String, Object> map) {
        if (Utils.isNotEmpty(map)) {
            this.getMetadata().putAll(map);
        }
        return this;
    }

    public AssistantMessage addMetadata(String key, Object value) {
        if (Utils.isNotEmpty((String)key)) {
            this.getMetadata().put(key, value);
        }
        return this;
    }

    @Override
    public boolean isThinking() {
        return this.isThinking;
    }

    public List<ChatFunctionCall> getToolCalls() {
        return this.toolCalls;
    }

    public List<Map> getToolCallsRaw() {
        return this.toolCallsRaw;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("role=").append(this.getRole().name().toLowerCase());
        if (this.content != null) {
            buf.append(", content='").append(this.content).append('\'');
        }
        if (this.metadata != null) {
            buf.append(", metadata=").append(this.metadata);
        }
        if (this.toolCallsRaw != null) {
            buf.append(", tool_calls=").append(this.toolCallsRaw);
        }
        buf.append("}");
        return buf.toString();
    }
}

