/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.repository;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.Utils;
import org.noear.solon.ai.embedding.EmbeddingModel;
import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.rag.RepositoryStorable;
import org.noear.solon.ai.rag.util.ListUtil;
import org.noear.solon.ai.rag.util.QueryCondition;
import org.noear.solon.ai.rag.util.SimilarityUtil;

public class InMemoryRepository
implements RepositoryStorable {
    private final EmbeddingModel embeddingModel;
    private final Map<String, Document> store = new ConcurrentHashMap<String, Document>();

    public InMemoryRepository(EmbeddingModel embeddingModel) {
        this.embeddingModel = embeddingModel;
    }

    @Override
    public void insert(List<Document> documents) throws IOException {
        if (Utils.isEmpty(documents)) {
            return;
        }
        for (List<Document> sub : ListUtil.partition(documents, 20)) {
            this.embeddingModel.embed(sub);
        }
        for (Document doc : documents) {
            if (Utils.isEmpty((String)doc.getId())) {
                doc.id(Utils.uuid());
            }
            this.store.put(doc.getId(), doc);
        }
    }

    @Override
    public void delete(String ... ids) {
        for (String id : ids) {
            this.store.remove(id);
        }
    }

    @Override
    public boolean exists(String id) {
        return this.store.containsKey(id);
    }

    @Override
    public List<Document> search(QueryCondition condition) throws IOException {
        float[] queryEmbed = this.embeddingModel.embed(condition.getQuery());
        return SimilarityUtil.scoreAndfilter(condition, this.store.values().stream(), queryEmbed);
    }
}

