/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.image;

import java.util.Base64;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiMedia;

public class Image
implements AiMedia {
    private String b64_json;
    private String url;

    public static Image ofUrl(String url) {
        Image tmp = new Image();
        tmp.url = url;
        return tmp;
    }

    public static Image ofBase64(String base64String) {
        Image tmp = new Image();
        tmp.b64_json = base64String;
        return tmp;
    }

    public static Image ofBase64(byte[] base64) {
        Image tmp = new Image();
        tmp.b64_json = Base64.getEncoder().encodeToString(base64);
        return tmp;
    }

    public String getB64Json() {
        return this.b64_json;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String toDataString(boolean useMime) {
        if (Utils.isEmpty((String)this.b64_json)) {
            return this.url;
        }
        if (useMime) {
            return "data:image/jpeg;base64," + this.b64_json;
        }
        return this.b64_json;
    }

    public String toString() {
        return "Image{b64_json='" + this.b64_json + '\'' + ", url='" + this.url + '\'' + '}';
    }
}

