/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.reranking.dialect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.noear.solon.ai.reranking.RerankingConfig;
import org.noear.solon.ai.reranking.dialect.DashscopeRerankingDialect;
import org.noear.solon.ai.reranking.dialect.OpenaiRerankingDialect;
import org.noear.solon.ai.reranking.dialect.RerankingDialect;
import org.noear.solon.core.util.RankEntity;

public class RerankingDialectManager {
    private static List<RankEntity<RerankingDialect>> dialects = new ArrayList<RankEntity<RerankingDialect>>();

    public static RerankingDialect select(RerankingConfig config) {
        for (RankEntity<RerankingDialect> d : dialects) {
            if (!((RerankingDialect)d.target).matched(config)) continue;
            return (RerankingDialect)d.target;
        }
        return OpenaiRerankingDialect.getInstance();
    }

    public static void register(RerankingDialect dialect) {
        RerankingDialectManager.register(dialect, 0);
    }

    public static void register(RerankingDialect dialect, int index) {
        dialects.add((RankEntity<RerankingDialect>)new RankEntity((Object)dialect, index));
        Collections.sort(dialects);
    }

    public static void unregister(RerankingDialect dialect) {
        dialects.removeIf(rankEntity -> rankEntity.target == dialect);
    }

    static {
        RerankingDialectManager.register(DashscopeRerankingDialect.getInstance());
    }
}

