/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.dialect;

import java.util.Date;
import java.util.List;
import org.noear.snack.ONode;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.chat.ChatChoice;
import org.noear.solon.ai.chat.ChatConfig;
import org.noear.solon.ai.chat.ChatException;
import org.noear.solon.ai.chat.ChatOptions;
import org.noear.solon.ai.chat.ChatResponseDefault;
import org.noear.solon.ai.chat.ChatRole;
import org.noear.solon.ai.chat.dialect.AbstractChatDialect;
import org.noear.solon.ai.chat.message.AssistantMessage;
import org.noear.solon.ai.chat.message.ChatMessage;

public class OpenaiChatDialect
extends AbstractChatDialect {
    private static final OpenaiChatDialect instance = new OpenaiChatDialect();

    public static OpenaiChatDialect instance() {
        return instance;
    }

    @Override
    public boolean matched(ChatConfig config) {
        return false;
    }

    @Override
    protected void buildReqFunctionsNode(ONode n, ChatConfig config, ChatOptions options, ChatMessage lastMessage) {
        if (lastMessage.getRole() != ChatRole.TOOL) {
            this.buildReqFunctionsNodeDo(n, config.getGlobalFunctions());
            this.buildReqFunctionsNodeDo(n, options.functions());
        }
    }

    @Override
    public boolean parseResponseJson(ChatConfig config, ChatResponseDefault resp, String json) {
        if ("[DONE]".equals(json)) {
            resp.setFinished(true);
            return true;
        }
        ONode oResp = ONode.load((Object)json);
        if (!oResp.isObject()) {
            return false;
        }
        if ("error".equals(oResp.get("object").getString())) {
            resp.setError(new ChatException(oResp.get("message").getString()));
        } else if (oResp.contains("error")) {
            resp.setError(new ChatException(oResp.get("error").getString()));
        } else {
            resp.setModel(oResp.get("model").getString());
            String finish_reason = oResp.get("finish_reason").getString();
            Date created = new Date(oResp.get("created").getLong() * 1000L);
            for (ONode oChoice1 : oResp.get("choices").ary()) {
                int index = oChoice1.get("index").getInt();
                List<AssistantMessage> messageList = oChoice1.contains("delta") ? this.parseAssistantMessage(resp, oChoice1.get("delta")) : this.parseAssistantMessage(resp, oChoice1.get("message"));
                for (AssistantMessage msg1 : messageList) {
                    resp.addChoice(new ChatChoice(index, created, finish_reason, msg1));
                }
            }
            ONode oUsage = oResp.getOrNull("usage");
            if (oUsage != null) {
                long promptTokens = oUsage.get("prompt_tokens").getLong();
                long completionTokens = oUsage.get("completion_tokens").getLong();
                long totalTokens = oUsage.get("total_tokens").getLong();
                resp.setUsage(new AiUsage(promptTokens, completionTokens, totalTokens));
            }
        }
        return true;
    }
}

