/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.function;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.annotation.FunctionMapping;
import org.noear.solon.ai.chat.annotation.FunctionParam;
import org.noear.solon.ai.chat.function.ChatFunction;
import org.noear.solon.ai.chat.function.ChatFunctionParam;
import org.noear.solon.ai.chat.function.ChatFunctionParamDecl;

public class MethodChatFunction
implements ChatFunction {
    private final Object target;
    private final Method method;
    private final String description;
    private final String name;
    private final List<ChatFunctionParam> params = new ArrayList<ChatFunctionParam>();

    public MethodChatFunction(Object target, Method method) {
        this.target = target;
        this.method = method;
        FunctionMapping m1Anno = method.getAnnotation(FunctionMapping.class);
        this.name = Utils.annoAlias((String)m1Anno.name(), (String)method.getName());
        this.description = m1Anno.description();
        for (Parameter p1 : method.getParameters()) {
            FunctionParam p1Anno = p1.getAnnotation(FunctionParam.class);
            String name = Utils.annoAlias((String)p1Anno.name(), (String)p1.getName());
            this.params.add(new ChatFunctionParamDecl(name, p1.getType(), p1Anno.required(), p1Anno.description()));
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public List<ChatFunctionParam> params() {
        return Collections.unmodifiableList(this.params);
    }

    @Override
    public String handle(Map<String, Object> args) throws Throwable {
        Object[] vals = new Object[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            vals[i] = args.get(this.params.get(i).name());
        }
        Object rst = this.method.invoke(this.target, vals);
        return String.valueOf(rst);
    }
}

